##PROJECT_GLOBAL_BEGIN
[Programs]
Count=1

[Misc Info]
Author=
Company=
Version=1.0
EditTime=19912
CyProVersion=3.0.2

[Protection]
Level=0
Password=
##PROJECT_GLOBAL_END

##PROGRAM_BEGIN_1
#PROJECT_OPTIONS_BEGIN
[Program]
Name=PLC SW

[VCP]
I2CPriority=5
SendSource=1
SendAlloc=1
ProtectWithPasswd=0
Password=
ScanOverrunStopsProgram=1
OutputRetentive=0
AutoStart=1
Com1Mode=3
Com1Baudrate=2
Com1Data=1
Com2Mode=1
Com2Baudrate=3
Com2Data=0
EthAbusEnable=1
EthModbusEnable=0
WANUrl=
PushEvent=0
PushUrl=89.212.244.21
ModbusDelay=20
ModbusDeviceAddress=1
ModbusPLCDataModel=2
ModbusAddress=0
ModbusRegisterCount=1
ModbusCoilsArrayVar=
ModbusRegistersArrayVar=
PLCCoilVars=
PLCRegisterVars=
ModbusCoilAddresses=
ModbusRegisterAddresses=

[Misc Info]
MonitorHistorySpeed=10

[Hardware]
CPUUnit=10
VarAreaTyp0.7.0=2
VarAreaTyp0.7.1=2
VarAreaTyp0.7.2=2
VarAreaTyp0.7.3=2
VarAreaTyp0.7.4=0
VarAreaTyp0.7.5=0
Card1=42
Type1=0
NAD1=600
VarPrefix1=eno00_
Card2=12
Type2=0
NAD2=700
VarPrefix2=air00_
VarAreaTyp2.5.0=0
VarAreaTyp2.5.1=0
VarAreaTyp2.5.2=5
Card3=26
Type3=0
NAD3=800
VarPrefix3=ts00_
Card4=26
Type4=0
NAD4=801
VarPrefix4=ts01_
Card5=26
Type5=0
NAD5=802
VarPrefix5=ts02_
Card6=26
Type6=0
NAD6=803
VarPrefix6=ts03_
Card7=26
Type7=0
NAD7=804
VarPrefix7=ts04_
Card8=26
Type8=0
NAD8=805
VarPrefix8=ts05_
Card9=26
Type9=0
NAD9=806
VarPrefix9=ts06_
Card10=26
Type10=0
NAD10=807
VarPrefix10=ts07_

[Socket00]
ID=1
SocketType=4
Descr=IQ-to-IQ sync
Var00=socket_request
Var01=socket_from
Var02=socket_to
Var03=socket_command
Var04=socket_argument_0
Var05=socket_argument_1
Var06=socket_argument_2
Var07=socket_argument_3

[Socket01]
ID=2
SocketType=0
Descr=Power and energy values from eStore machine
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=estore_soc
Var04=estore_power_to_grid
Var05=estore_power_from_grid
Var06=estore_power_production
Var07=estore_power_to_battery
Var08=estore_power_from_battery
Var09=estore_power_consumption
Var10=estore_energy_to_grid
Var11=estore_energy_from_grid
Var12=estore_energy_production
Var13=estore_energy_to_battery
Var14=estore_energy_from_battery
Var15=estore_energy_consumption
Var16=estore_charge_power
Var17=estore_discharge_power

[Socket02]
ID=3
SocketType=0
Descr=HIQ Home
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=hiq_home_pm_power
Var04=hiq_home_out_power[0]
Var05=hiq_home_out_power[1]
Var06=hiq_home_out_power[2]
Var07=hiq_home_out_power[3]
Var08=hiq_home_out_power[4]
Var09=hiq_home_out_power[5]
Var10=hiq_home_out_power[6]
Var11=hiq_home_out_power[7]
Var12=hiq_home_out_power[8]
Var13=hiq_home_out_power[9]
Var14=hiq_home_out_power[10]
Var15=hiq_home_out_power[11]
Var16=hiq_home_out_power[12]
Var17=hiq_home_out_power[13]
Var18=hiq_home_out_power[14]
Var19=hiq_home_out_power[15]
Var20=hiq_home_out_power[16]
Var21=hiq_home_out_power[17]
Var22=hiq_home_out_power[18]
Var23=hiq_home_out_power[19]
Var24=hiq_home_out_power[20]
Var25=hiq_home_out_power[21]
Var26=hiq_home_out_power[22]
Var27=hiq_home_out_power[23]
Var28=hiq_home_out_power[24]
Var29=hiq_home_out_power[25]
Var30=hiq_home_out_power[26]
Var31=hiq_home_out_power[27]
Var32=hiq_home_out_power[28]
Var33=hiq_home_out_power[29]
Var34=hiq_home_out_power[30]
Var35=hiq_home_out_power[31]
Var36=hiq_home_out_power[32]
Var37=hiq_home_out_power[33]
Var38=hiq_home_out_power[34]
Var39=hiq_home_out_power[35]
Var40=hiq_home_out_power[36]
Var41=hiq_home_out_power[37]
Var42=hiq_home_out_power[38]
Var43=hiq_home_out_power[39]
Var44=hiq_home_dim_power[0]
Var45=hiq_home_dim_power[1]
Var46=hiq_home_dim_power[2]
Var47=hiq_home_dim_power[3]
Var48=hiq_home_dim_power[4]
Var49=hiq_home_dim_power[5]
Var50=hiq_home_dim_power[6]
Var51=hiq_home_dim_power[7]
Var52=hiq_home_dim_power[8]
Var53=hiq_home_dim_power[9]
Var54=hiq_home_dim_power[10]
Var55=hiq_home_dim_power[11]
Var56=hiq_home_dim_power[12]
Var57=hiq_home_dim_power[13]
Var58=hiq_home_dim_power[14]
Var59=hiq_home_dim_power[15]
Var60=hiq_home_pm_energy
Var61=hiq_home_out_energy[0]
Var62=hiq_home_out_energy[1]
Var63=hiq_home_out_energy[2]
Var64=hiq_home_out_energy[3]
Var65=hiq_home_out_energy[4]
Var66=hiq_home_out_energy[5]
Var67=hiq_home_out_energy[6]
Var68=hiq_home_out_energy[7]
Var69=hiq_home_out_energy[8]
Var70=hiq_home_out_energy[9]
Var71=hiq_home_out_energy[10]
Var72=hiq_home_out_energy[11]
Var73=hiq_home_out_energy[12]
Var74=hiq_home_out_energy[13]
Var75=hiq_home_out_energy[14]
Var76=hiq_home_out_energy[15]
Var77=hiq_home_out_energy[16]
Var78=hiq_home_out_energy[17]
Var79=hiq_home_out_energy[18]
Var80=hiq_home_out_energy[19]
Var81=hiq_home_out_energy[20]
Var82=hiq_home_out_energy[21]
Var83=hiq_home_out_energy[22]
Var84=hiq_home_out_energy[23]
Var85=hiq_home_out_energy[24]
Var86=hiq_home_out_energy[25]
Var87=hiq_home_out_energy[26]
Var88=hiq_home_out_energy[27]
Var89=hiq_home_out_energy[28]
Var90=hiq_home_out_energy[29]
Var91=hiq_home_out_energy[30]
Var92=hiq_home_out_energy[31]
Var93=hiq_home_out_energy[32]
Var94=hiq_home_out_energy[33]
Var95=hiq_home_out_energy[34]
Var96=hiq_home_out_energy[35]
Var97=hiq_home_out_energy[36]
Var98=hiq_home_out_energy[37]
Var99=hiq_home_out_energy[38]
Var100=hiq_home_out_energy[39]
Var101=hiq_home_dim_energy[0]
Var102=hiq_home_dim_energy[1]
Var103=hiq_home_dim_energy[2]
Var104=hiq_home_dim_energy[3]
Var105=hiq_home_dim_energy[4]
Var106=hiq_home_dim_energy[5]
Var107=hiq_home_dim_energy[6]
Var108=hiq_home_dim_energy[7]
Var109=hiq_home_dim_energy[8]
Var110=hiq_home_dim_energy[9]
Var111=hiq_home_dim_energy[10]
Var112=hiq_home_dim_energy[11]
Var113=hiq_home_dim_energy[12]
Var114=hiq_home_dim_energy[13]
Var115=hiq_home_dim_energy[14]
Var116=hiq_home_dim_energy[15]

[Socket03]
ID=4
SocketType=0
Descr=HIQ Home
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=hiq_home_out[0]
Var04=hiq_home_out[1]
Var05=hiq_home_out[2]
Var06=hiq_home_out[3]
Var07=hiq_home_out[4]
Var08=hiq_home_out[5]
Var09=hiq_home_out[6]
Var10=hiq_home_out[7]
Var11=hiq_home_out[8]
Var12=hiq_home_out[9]
Var13=hiq_home_out[10]
Var14=hiq_home_out[11]
Var15=hiq_home_out[12]
Var16=hiq_home_out[13]
Var17=hiq_home_out[14]
Var18=hiq_home_out[15]
Var19=hiq_home_out[16]
Var20=hiq_home_out[17]
Var21=hiq_home_out[18]
Var22=hiq_home_out[19]
Var23=hiq_home_out[20]
Var24=hiq_home_out[21]
Var25=hiq_home_out[22]
Var26=hiq_home_out[23]
Var27=hiq_home_out[24]
Var28=hiq_home_out[25]
Var29=hiq_home_out[26]
Var30=hiq_home_out[27]
Var31=hiq_home_out[28]
Var32=hiq_home_out[29]
Var33=hiq_home_out[30]
Var34=hiq_home_out[31]
Var35=hiq_home_out[32]
Var36=hiq_home_out[33]
Var37=hiq_home_out[34]
Var38=hiq_home_out[35]
Var39=hiq_home_out[36]
Var40=hiq_home_out[37]
Var41=hiq_home_out[38]
Var42=hiq_home_out[39]
Var43=hiq_home_out[40]
Var44=hiq_home_out[41]
Var45=hiq_home_out[42]
Var46=hiq_home_out[43]
Var47=hiq_home_out[44]
Var48=hiq_home_out[45]
Var49=hiq_home_out[46]
Var50=hiq_home_out[47]
Var51=hiq_home_out[48]
Var52=hiq_home_out[49]
Var53=hiq_home_out[50]
Var54=hiq_home_out[51]
Var55=hiq_home_out[52]
Var56=hiq_home_out[53]
Var57=hiq_home_out[54]
Var58=hiq_home_out[55]
Var59=hiq_home_out[56]
Var60=hiq_home_out[57]
Var61=hiq_home_out[58]
Var62=hiq_home_out[59]
Var63=hiq_home_out[60]
Var64=hiq_home_out[61]
Var65=hiq_home_out[62]
Var66=hiq_home_out[63]
Var67=hiq_home_out[64]
Var68=hiq_home_out[65]
Var69=hiq_home_out[66]
Var70=hiq_home_out[67]
Var71=hiq_home_out[68]
Var72=hiq_home_out[69]
Var73=hiq_home_out[70]
Var74=hiq_home_out[71]
Var75=hiq_home_out[72]
Var76=hiq_home_out[73]
Var77=hiq_home_out[74]
Var78=hiq_home_out[75]
Var79=hiq_home_out[76]
Var80=hiq_home_out[77]
Var81=hiq_home_out[78]
Var82=hiq_home_out[79]
Var83=hiq_home_out[80]
Var84=hiq_home_out[81]
Var85=hiq_home_out[82]
Var86=hiq_home_out[83]
Var87=hiq_home_out[84]
Var88=hiq_home_out[85]
Var89=hiq_home_out[86]
Var90=hiq_home_out[87]
Var91=hiq_home_out[88]
Var92=hiq_home_out[89]
Var93=hiq_home_out[90]
Var94=hiq_home_out[91]
Var95=hiq_home_out[92]

[Net]
CurrentNAD=-1

[Monitor01]
VarCount=12
VarName1=total_energy[0]
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=total_energy[1]
VarBase2=1
VarValue2=0
VarColor2=0
VarIndex2=1
VarName3=total_energy[2]
VarBase3=1
VarValue3=0
VarColor3=0
VarIndex3=2
VarName4=total_energy[3]
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
VarName5=total_energy[4]
VarBase5=1
VarValue5=0
VarColor5=0
VarIndex5=4
VarName6=total_energy[5]
VarBase6=1
VarValue6=0
VarColor6=0
VarIndex6=5
VarName7=total_energy[6]
VarBase7=1
VarValue7=0
VarColor7=0
VarIndex7=6
VarName8=total_consumer_energy[0]
VarBase8=1
VarValue8=0
VarColor8=0
VarIndex8=7
VarName9=total_consumer_energy[1]
VarBase9=1
VarValue9=0
VarColor9=0
VarIndex9=8
VarName10=total_consumer_energy[2]
VarBase10=1
VarValue10=0
VarColor10=0
VarIndex10=9
VarName11=total_consumer_energy[3]
VarBase11=1
VarValue11=0
VarColor11=0
VarIndex11=10
VarName12=total_consumer_energy[4]
VarBase12=1
VarValue12=0
VarColor12=0
VarIndex12=11
#PROJECT_OPTIONS_END

#DMVARSLIST_BEGIN
#DMVARSLIST_END

#MASKS_BEGIN
#MASKS_END

#CODE_BEGIN
// AllocGroupList="User Variables", "I/O Variables", "Constants", "system", "push", "modbus", "power meter", "com_nok", "nok devices", "enocean", "source", "consumers", "load", "hiq comm", "estore", "socket", "timetable", "forecast", "hiq commander", "hiq_home", "parameters", "datetime", "price", "gui totals"
var retain
  application_id: long; // yypppnnn => yy = 2 digits year; ppp = 3 digits project number;         nnn = 3 digits application SN within project {AllocGroup="system"}
  version_major: int; // PLC application major version: increments with functionality changes (functionality redefined, changed main HW components,...) {AllocGroup="system"}
  version_minor: int; // PLC application minor version: increments with cosmetic changes (added variables, updated functionalities, ...) {AllocGroup="system"}
  version_release: int; // PLC application release version: increments with bug & issues fixes {AllocGroup="system"}
  version_state: int; // PLC application major version state: 0=alfa, 1=beta, 2=release candidate, 3=release {AllocGroup="system"}
  kernel_major: int; // kernel major version {AllocGroup="system"}
  kernel_minor: int; // kernel minor version {AllocGroup="system"}
  push_req_counter: long; // Number of push messages sent. Program is configured to send push periodically, once a minute. {AllocGroup="push"}
  push_ack_counter: long; // Number of received acknowledges. Acknowledge confirms that connection to server work in both directions. {AllocGroup="push"}
  source_status: ARRAY[0..9] OF int; // source status: 0=disabled, 1=ok, 2=error, 3=off, 4=on {AllocGroup="source"}
  source_power: ARRAY[0..9] OF long; // source power in W {AllocGroup="source"}
  source_energy: ARRAY[0..9] OF long; // source energy in 0.1 kWh {AllocGroup="source"}
  total_source_power: ARRAY[0..3] OF long; // totals for source powers in W; index: 0=all sources, 1=grid, 2=plant, 3=storage {AllocGroup="source"}
  total_source_energy: ARRAY[0..3] OF long; // totals for source energies in 0.1 kWh; index: 0=all sources, 1=grid, 2=plant, 3=storage {AllocGroup="source"}
  consumer_status: ARRAY[0..17] OF int; // consumer power-meter status: 0=none, 1=ok, 2= err {AllocGroup="consumers"}
  consumer_power: ARRAY[0..17] OF long; // consumer power in W {AllocGroup="consumers"}
  consumer_energy: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="consumers"}
  consumer_status_timer: ARRAY[0..17] OF int; // consumer status timer in ms {AllocGroup="consumers"}
  consumer_partial_power: ARRAY[0..179] OF long; // consumer power per source index=xxy, xx=consumer index, y=source index {AllocGroup="consumers"}
  consumer_partial_energy: ARRAY[0..179] OF long; // consumer energy per source index=xxy, xx=consumer index, y=source index {AllocGroup="consumers"}
  estore_nad_list: ARRAY[0..9] OF int; // List of detected eStores (NAD) {AllocGroup="estore"}
  timetable: ARRAY[0..5375] OF int; // 8 x timetable; 15 min resolution; bit coded: b0=local recurring off, b1=local recurring on, b2=local once off, b3=local once on, b4=cloud override, b5=cloud recurring off, b6=cloud recurring on, b7=cloud once off, b8=cloud once on {AllocGroup="timetable"}
  forecast_state: ARRAY[0..7] OF int; // forecast state (bit coded for b0=actual state, b1=state for next 15 min...) {AllocGroup="forecast"}
  eno_status: ARRAY[0..17] OF int; // enocean push-button status (0=no, 1=ok, 2=waiting off button press command, 3=waiting off button release command, 4=waiting on button press command, 5=waiting on button press command) {AllocGroup="enocean"}
  hiq_address: ARRAY[0..17] OF int; // HIQ Home address {AllocGroup="hiq_home"}
  hiq_index: ARRAY[0..17] OF int; // HIQ Home index {AllocGroup="hiq_home"}
  hiq_type: ARRAY[0..17] OF int; // HIQ Home type {AllocGroup="hiq_home"}
  hiq_home_nad_list: ARRAY[0..9] OF int; // List of detected HIQ Home NAD {AllocGroup="hiq comm"}
  source_status_timer: ARRAY[0..9] OF int; // timer for calculating status in ms {AllocGroup="source"}
  total_consumer_power: ARRAY[0..4] OF long; // total consumers power in W; index 0=all, 1=grid, 2=plants, 3=storages {AllocGroup="consumers"}
  total_consumer_energy: ARRAY[0..4] OF long; // total consumers power in W; index 0=all, 1=grid, 2=plants, 3=storages {AllocGroup="consumers"}
  timetable_cloud_once: ARRAY[0..7] OF bool; // enabled cloud optimization {AllocGroup="timetable"}
  timetable_cloud_recurring: ARRAY[0..7] OF bool; // enabled cloud optimization {AllocGroup="timetable"}
  timetable_analog: ARRAY[0..5375] OF int; // analog timetable: 0..100=setpoint in %, -1=disabled {AllocGroup="timetable"}
  timetable_cloud_analog: ARRAY[0..7] OF bool; // timetable cloud optimization enabled {AllocGroup="timetable"}
  timetable_tariff: ARRAY[0..671] OF int; // tarif system timetable; 15 min resolution 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="timetable"}
  timetable_battery: ARRAY[0..671] OF int; // battery timetable: -100..100=setpoint in %, -32768=auto (selfconsumption) {AllocGroup="timetable"}
  timetable_battery_optimization: bool; // timetable cloud optimization enabled {AllocGroup="timetable"}
  timetable_battery_default: int; // default timetable value: 0=off, 1=auto(selfconsumption) {AllocGroup="timetable"}
  timetable_set: ARRAY[0..17] OF bool; // Timetable set command {AllocGroup="timetable"}
  analog_out: ARRAY[0..17] OF int; // analog output 0..100 {AllocGroup="load"}
  power_meter_type: ARRAY[0..17] OF int; // power meter type: 0=none, 1=1ph (Eastron SDM120), 2=3ph (Iskra WM3-8) {AllocGroup="power meter"}
  power_meter_new: int; // new power meter detected: 0=none, 1=eastron, 3=iskra {AllocGroup="power meter"}
  pm_type: ARRAY[0..18] OF int; // autodetected power meter type: 0=none, 1=1ph(eastron), 2=2ph(iskra) {AllocGroup="power meter"}
  load_manager_energy: ARRAY[0..17] OF long; // 4noks load-manager energy in Wh {AllocGroup="nok devices"}
  load_manager_set: ARRAY[0..17] OF bool; // 4noks load-manager output set {AllocGroup="nok devices"}
  general_status: int; // general status 0=unknown, 1=ok, 2=error {AllocGroup="system"}
  reset_counter: int; // Total number of controller resets. {AllocGroup="system"}
  operating_hours: long; // Total number of operating hours [h]. {AllocGroup="system"}
  push_enable: bool; // Allow controller to send periodical push messages to server: 0-off, 1-on. {AllocGroup="push"}
  consumer_icon: ARRAY[0..18] OF int; // consumer icon: see consumer icon.txt {AllocGroup="consumers"}
  consumer_name: ARRAY[0..294] OF int; // consumer name {AllocGroup="consumers"}
  consumer_override_preset: ARRAY[0..17] OF int; // manual set override timer in min; 0=no manual override {AllocGroup="consumers"}
  consumer_type: ARRAY[0..17] OF int; // consumer type: 0=disabled, 1=3 ph power meter, 2=1 ph power meter, 3=wireless socket, 4=eStore, 5= HIQ home power meter, 6=HIQ Home digital output, 7= HIQ Home dimmer {AllocGroup="consumers"}
  consumer_address: ARRAY[0..17] OF int; // consumer address, depends on consumer type {AllocGroup="consumers"}
  consumer_index: ARRAY[0..17] OF int; // consumer index, depends on consumer type {AllocGroup="consumers"}
  timetable_enable: ARRAY[0..7] OF bool; // timetable enabled {AllocGroup="timetable"}
  eno_mem_0: ARRAY[0..17] OF int; // enocean switching off commands {AllocGroup="enocean"}
  eno_mem_1: ARRAY[0..17] OF int; // enocean switching on commands {AllocGroup="enocean"}
  load_type: ARRAY[0..17] OF int; // load type: 0=disabled, 1=hems digital out, 2=hems wireless socket, 3=HIQ Home digital output, 4= HIQ Home dimmer (0/100%) {AllocGroup="load"}
  load_address: ARRAY[0..17] OF int; // load address; depends on type {AllocGroup="load"}
  load_index: ARRAY[0..17] OF int; // load index; depends on type {AllocGroup="load"}
  load_override_preset: ARRAY[0..17] OF int; // manual set override timer in min; 0=no manual override {AllocGroup="load"}
  source_power_nominal: ARRAY[0..9] OF long; // source nominal power in W {AllocGroup="source"}
  consumer_power_nominal: ARRAY[0..17] OF long; // consumer nominal power in W {AllocGroup="consumers"}
  load_inverted: ARRAY[0..17] OF bool; // load output inverted {AllocGroup="load"}
  modbus_msg_tout: int; // modbus message timeout in ms {AllocGroup="modbus"}
  modbus_char_tout: int; // modbus character timeout in ms {AllocGroup="modbus"}
  modbus_retry: int; // modbus retry {AllocGroup="modbus"}
  tariff_energy_price: ARRAY[0..3] OF long; // grid energy price in cents per MWh, index: 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="price"}
  parameters_crc_tmp: long; // real-time parameters CRC32 {AllocGroup="parameters"}
  parameters_crc32: long; // delayed parameters CRC32 {AllocGroup="parameters"}
  parameters_autosave: bool; // parameters autosave enabled {AllocGroup="parameters"}
  parameters_crc_preset: int; default=15; // preset time for parameters CRC32 update in minutes {AllocGroup="parameters"}
  tmp_i: ARRAY[0..99] OF long;
  total_energy: ARRAY[0..6] OF long; // {AllocGroup="gui totals"}
  source_energy_abs: ARRAY[0..9] OF long; // source energy in 0.1 kWh {AllocGroup="source"}
  consumer_energy_abs: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="consumers"}
  source_energy_abs_old: ARRAY[0..9] OF long; // source energy in 0.1 kWh {AllocGroup="source"}
  consumer_energy_abs_old: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="consumers"}
  power_meter_energy_imported: ARRAY[0..17] OF long; // power meter energy imported in Wh {AllocGroup="power meter"}
  power_meter_energy_exported: ARRAY[0..17] OF long; // power meter energy exported in Wh {AllocGroup="power meter"}
  energy_reset_year: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_month: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_date: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_hour: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_min: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_sec: int; // energy reset date {AllocGroup="consumers"}
  energy_reset_weekday: int; // energy reset date {AllocGroup="consumers"}
  load_out: ARRAY[0..17] OF bool; // load state 0=off, 1=off {AllocGroup="load"}
  load_set: ARRAY[0..17] OF bool; // load state 0=off, 1=off {AllocGroup="load"}
var_end;

var permanent
  ee_parameters: ARRAY[0..999] OF long; // {AllocGroup="parameters"}
var_end;

var
  i: int;
  j: int;
  kernel_release: int; // kernel release version {AllocGroup="system"}
  tmp: int;
  push_timer: int; // Timer for periodically sending push message [s]. {AllocGroup="push"}
  push_req: bool; // Set to send push message and start timer. {AllocGroup="push"}
  push_status: int; // Push status: 0-idle, 1-waiting, 2-ok, 3-error. {AllocGroup="push"}
  push_roundtrip: int; // Time from sending push message to receiving acknowledge [ms]. {AllocGroup="push"}
  hiq_home_general_error: bool; // No HIQ Home detected {AllocGroup="hiq comm"}
  hiq_home_nad_txt: ARRAY[0..70] OF int; // Text of HIQ Home NAD (csv) {AllocGroup="hiq comm"}
  hiq_home_nad_list_clr: bool; // Command to clear HIQ Home list {AllocGroup="hiq comm"}
  hiq_home_address: int; // HIQ Home address {AllocGroup="hiq comm"}
  hiq_home_pm_power: long; // Measured power consumption [W]. {AllocGroup="hiq comm"}
  hiq_home_pm_energy: long; // Energy consumption total [kWh]. {AllocGroup="hiq comm"}
  estore_soc: int; // State of charge in 0.1% {AllocGroup="estore"}
  estore_power_to_grid: long; // Power delivered to power grid in W {AllocGroup="estore"}
  estore_power_from_grid: long; // Power from power grid in W {AllocGroup="estore"}
  estore_power_production: long; // Power plant production in W (+ = produced) {AllocGroup="estore"}
  estore_power_to_battery: long; // Power stored to battery in W {AllocGroup="estore"}
  estore_power_from_battery: long; // Power feeded from battery in W {AllocGroup="estore"}
  estore_power_consumption: long; // Total power consumption in W (- = consumed) {AllocGroup="estore"}
  estore_energy_to_grid: long; // Total energy exported to grid in Wh {AllocGroup="estore"}
  estore_energy_from_grid: long; // Total energy imported from grid in Wh {AllocGroup="estore"}
  estore_energy_production: long; // Total produced energy in Wh {AllocGroup="estore"}
  estore_energy_to_battery: long; // Total energy to battery in Wh {AllocGroup="estore"}
  estore_energy_from_battery: long; // Total energy from battery in Wh {AllocGroup="estore"}
  estore_energy_consumption: long; // Total consumed energy in Wh {AllocGroup="estore"}
  estore_nad_txt: ARRAY[0..70] OF int; // TXT of detected eStores (csv, NAD) {AllocGroup="estore"}
  estore_nad_list_clr: bool; // Command to clear eStore list {AllocGroup="estore"}
  estore_general_error: bool; // Any eStore detected {AllocGroup="estore"}
  socket_request: bool; // socket 1 request {AllocGroup="socket"}
  socket_id: int; // socket id: 0= none, 2=eStore socket, 3=HIQ Home powers and energyes, 4=HIQ Home output states {AllocGroup="socket"}
  socket_from: int; // socket sender NAD {AllocGroup="socket"}
  socket_to: int; // socket destination NAD; 0=broadcast {AllocGroup="socket"}
  socket_command: int; // socket 1 command {AllocGroup="socket"}
  socket_argument_0: int; // socket 1 1st argument {AllocGroup="socket"}
  socket_argument_1: int; // socket 1 2nd argument {AllocGroup="socket"}
  socket_argument_2: int; // socket 1 3rd argument {AllocGroup="socket"}
  socket_argument_3: int; // socket 1 4th argument {AllocGroup="socket"}
  timetable_e: ARRAY[0..671] OF bool; // temporary timetable for editing purpose {AllocGroup="timetable"}
  timetable_e_cmd: int; // editing timetable command {AllocGroup="timetable"}
  timetable_e_idx: int; // editing timetable index {AllocGroup="timetable"}
  tariff: int; // active grid tariff: 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="timetable"}
  tariff_cmd: int; // editing tariff timetable command {AllocGroup="timetable"}
  program_id: int; default=3; // Identification number used for HIQ autodetect, must be equal 3. {AllocGroup="hiq commander"}
  lc00_general_error: bool; // Combined system error (timeout or program error), module is not operational. {AllocGroup="hiq commander"}
  lc00_qx00: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx01: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx02: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx03: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx04: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx05: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx06: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx07: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx08: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_qx09: bool; // Relay output (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix00: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix01: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix02: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix03: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix04: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix05: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix06: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix07: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix08: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  lc00_ix09: bool; // Binary input (0-open, 1-closed). {AllocGroup="hiq commander"}
  hiq_status: ARRAY[0..17] OF int; // HIQ Home status {AllocGroup="hiq_home"}
  hiq_home_out_power: ARRAY[0..39] OF long; // Power currently used by a single output [W]. {AllocGroup="hiq comm"}
  hiq_home_out_energy: ARRAY[0..39] OF long; // Total energy consumption per output [kWh]. {AllocGroup="hiq comm"}
  hiq_home_dim_power: ARRAY[0..15] OF long; // Power currently used by a single dimmer [W]. {AllocGroup="hiq comm"}
  hiq_home_dim_energy: ARRAY[0..15] OF long; // Total energy consumption per dimmer [kWh]. {AllocGroup="hiq comm"}
  hiq_home_out: ARRAY[0..92] OF bool; // HIQ Home output state {AllocGroup="hiq comm"}
  tmp_l: long;
  timetable_battery_cmd: bool; // timetable command: 1= vrite value to timetable {AllocGroup="timetable"}
  timetable_battery_val: int; // timetable value to write: -100..100= set setpoint, -32768=auto, auto return to 32767 {AllocGroup="timetable"}
  optimization_index: ARRAY[0..50] OF int; // timetable oprimization index (0=broadcast) {AllocGroup="timetable"}
  estore_setpoint: int; // Setpoint_ -100..100= setpoint, -32768=auto {AllocGroup="estore"}
  optimization_start: ARRAY[0..50] OF int; // timetable optimization start time (hhmmw; hh=hour, mm=minute, w=weekday-1=monday) {AllocGroup="timetable"}
  battery_soc: ARRAY[0..1] OF int; // State of charge in 0.1% {AllocGroup="estore"}
  battery_forecast: ARRAY[0..16] OF int; // battery forecast: -100..100=%, -32768=auto {AllocGroup="estore"}
  estore_charge_power: int; // Alowed charging power in -W {AllocGroup="estore"}
  estore_discharge_power: int; // Alowed discharging power in W {AllocGroup="estore"}
  modbus_data: ARRAY[0..999] OF int; // modbus data bytes {AllocGroup="modbus"}
  modbus_status: int; // modbus status: 0=idle, 1=reading data, 2=read OK, 3=read error {AllocGroup="modbus"}
  modbus_read_timer: long; // modbus device retry ms timer {AllocGroup="modbus"}
  modbus_step: int; // modbus state machine step {AllocGroup="modbus"}
  modbus_retry_count: int; // modbus retry count {AllocGroup="modbus"}
  modbus_command: int; // Execute: 0=no operation, 1=Address PM, 2=Init NOK_GW, 3=Rebuild NOK_GW, 4=Clear new NOK_D, 5=Add NOK_D {AllocGroup="modbus"}
  modbus_argument: int; // modbus_command argument {AllocGroup="modbus"}
  load_status: ARRAY[0..17] OF int; // load status: 0=disabled, 1=ok, 2=error, 3=off, 4=on {AllocGroup="load"}
  nok_general_error: bool; // Combined system error (timeout or program error), system is not operational. {AllocGroup="com_nok"}
  nok_network_created: bool; // Wireless network state: 0-not created, 1-created. {AllocGroup="com_nok"}
  nok_network_open: bool; // Wireless network for connecting new devices: 0-closed, 1-open. {AllocGroup="com_nok"}
  nok_network_status: int; // closed), 3-network open, 4-destroying network, 5-network destroyed, 6-creating network, 7-creating error, 8-waiting keypress, 9-device detected, 10-updating devices, 11-addressing error, 12-parameters error {AllocGroup="com_nok"}
  nok_new_device_type: int; // New 4noks device type: 38=plug or wall switch,  39= wall power meter, 42= din rail power meter, 2=2 NTC + 2 DI module, 3=indoor temperature and humidity {AllocGroup="com_nok"}
  nok_new_device_address: int; // New 4noks device address - entred by user 1..8 {AllocGroup="com_nok"}
  nok_new_device_status: int; // 4noks new device status: 0=no, 1=ok, 2=err {AllocGroup="com_nok"}
  power_meter_status: ARRAY[0..17] OF int; // power meter status: 0=no, 1=ok, 2=err {AllocGroup="power meter"}
  power_meter_power: ARRAY[0..17] OF int; // power meter power in W (+=import, -=export) {AllocGroup="power meter"}
  power_meter_old_address: int; // new power meter old address {AllocGroup="power meter"}
  power_meter_new_address: int; // new power meter new address {AllocGroup="power meter"}
  power_meter_new_msg: int; // new power meter addressing message: 0="", 1=no new device, 2=address changed, 3=addressing error {AllocGroup="power meter"}
  power_meter_new_type: int; // new power meter type {AllocGroup="power meter"}
  pm_refresh_req: bool; // Request to fast refresh all power meters {AllocGroup="power meter"}
  eno_msg: int; // enocean message {AllocGroup="enocean"}
  load_manager_status: ARRAY[0..17] OF int; // 4noks load manager device status: 0=no, 1=ok, 2=err {AllocGroup="nok devices"}
  load_manager_power: ARRAY[0..17] OF int; // 4noks load-manager power in W {AllocGroup="nok devices"}
  load_manager_message_cnt: ARRAY[0..17] OF int; // 4noks load-manager wireless messages count {AllocGroup="nok devices"}
  load_manager_signal: ARRAY[0..17] OF int; // 4noks load-manager wireless signal strenght {AllocGroup="nok devices"}
  sensor_status: ARRAY[0..17] OF int; // 4noks sensor device status: 0=no, 1=ok, 2=err {AllocGroup="nok devices"}
  sensor_temperature_1: ARRAY[0..17] OF int; // 4noks sensor device temperature 1 in 0.1 C {AllocGroup="nok devices"}
  sensor_temperature_2: ARRAY[0..17] OF int; // 4noks sensor device temperature 2 in 0.1 C {AllocGroup="nok devices"}
  sensor_humidity: ARRAY[0..17] OF int; // 4noks sensor device relative humidity in % {AllocGroup="nok devices"}
  sensor_ix00: ARRAY[0..17] OF bool; // 4noks sensor device digital input 1 state {AllocGroup="nok devices"}
  sensor_ix01: ARRAY[0..17] OF bool; // 4noks sensor device digital input 2 state {AllocGroup="nok devices"}
  sensor_message_cnt: ARRAY[0..17] OF int; // 4noks sensor device wireless messages count {AllocGroup="nok devices"}
  sensor_signal: ARRAY[0..17] OF int; // 4noks sensor device wireless signal strenght {AllocGroup="nok devices"}
  bridge_status: ARRAY[0..17] OF int; // 4noks bridge status 0=no, 1=OK, 2=ERR {AllocGroup="nok devices"}
  bridge_signal: ARRAY[0..17] OF int; // 4noks bridge wireless signal strenght {AllocGroup="nok devices"}
  device_enabled: ARRAY[0..17] OF bool; // device enabled (any of source or consumer power meter or load management device active) {AllocGroup="nok devices"}
  nok_button_selected: ARRAY[0..2] OF bool; // 4noks button selected {AllocGroup="nok devices"}
  sensor_state: ARRAY[0..17] OF int; // general sensor device status: 0=no, 1=ok, 2=err {AllocGroup="nok devices"}
  load_manager_selected: ARRAY[0..17] OF bool; // 4noks load-manager selected {AllocGroup="nok devices"}
  sensor_selected: ARRAY[0..17] OF bool; // 4noks sensor device selected {AllocGroup="nok devices"}
  optimization_time: ARRAY[0..50] OF int; // timetable optimization period in min {AllocGroup="timetable"}
  optimization_command: ARRAY[0..50] OF int; // timetable optimization command: 1= set once action, 2= set recurring action, 3=set critical peak tariff, 4=set mask, 5=set setpoint {AllocGroup="timetable"}
  optimization_value: ARRAY[0..50] OF int; // timetable optimization value , depends of command command (-1=clear/clear critical peak tariff, 0=set off/lo tariff, 1= set on/hi tariff, 2=set critical peak tariff, -100..100 set setpoint, -32768=auto) {AllocGroup="timetable"}
  timetable_analog_cmd: ARRAY[0..3] OF int; // timetable command: 1= vrite value to timetable {AllocGroup="timetable"}
  timetable_analog_val: int; // timetable value to write: 0..100= set setpoint, -1=auto {AllocGroup="timetable"}
  start: bool; default=0; // {AllocGroup="system"}
  edit_year: int; // {AllocGroup="datetime"}
  edit_month: int; // {AllocGroup="datetime"}
  edit_date: int; // {AllocGroup="datetime"}
  edit_weekday: int; // {AllocGroup="datetime"}
  edit_hour: int; // {AllocGroup="datetime"}
  edit_min: int; // {AllocGroup="datetime"}
  edit_sec: int; // {AllocGroup="datetime"}
  datetime_cmd: int; // {AllocGroup="datetime"}
  edit_datetime: bool; // {AllocGroup="datetime"}
  cybro_uptime: long; // Number of operating hours since power-on [h]. {AllocGroup="system"}
  day_min: int; // minute of the day {AllocGroup="datetime"}
  parameters_cmd: int; // parameters manipulation command: 1=init, 2=save, 3=read; auto returns to 0 {AllocGroup="parameters"}
  ee_parameters_error: bool; // ee parameters values not within min-max {AllocGroup="parameters"}
  ee_parameters_ok: bool; // ee parameters values within min-max {AllocGroup="parameters"}
  parameters_error: bool; // parameters values not within min-max {AllocGroup="parameters"}
  parameters_error_idx: int; // index of first error parameter {AllocGroup="parameters"}
  parameters_ok: bool; // parameters values within min-max {AllocGroup="parameters"}
  parameters_saved: bool; // parameters equals to ee {AllocGroup="parameters"}
  ee_save_req: bool; // save ee_par to eeprom {AllocGroup="parameters"}
  parameters_status: int; // parameters status (bit coded:b2=EE OK, b2=par OK, b0=saved) {AllocGroup="parameters"}
  buyout_energy_price: long; // current grid energy price in cents per MWh {AllocGroup="price"}
  current_energy_price: long; // current energy price in cents per MWh {AllocGroup="price"}
  parameters_unsaved_idx: int; // index of first unsaved parameter {AllocGroup="parameters"}
  parameters_crc_timer: long; // parameters CRC32 timer in ms {AllocGroup="parameters"}
  energy_reset_req: bool; // reset all energies to 0 {AllocGroup="consumers"}
var_end;

function main:void; language 'Structured Text';
  function f_parameters:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var retain
    retentive_magic: int;
    parameters_crc_tmp_old: long;
  var_end;

    function f_parameters_manage(idx:int; val,def,min,max:long):long; language 'Structured Text';
    begin
      //*****************************************************************************
      // f_parameters_manage(value,ee_array_index,defoult_value,min_value,max_value,command)
      //*****************************************************************************
      
      // test ee
      if ee_parameters[idx] < min or ee_parameters[idx] > max then
        ee_parameters_error := 1;
      end_if;
      
      // test parameter
      if val < min or val > max then
        parameters_error := 1;
        if parameters_error_idx = -1 then
          parameters_error_idx := idx;
        end_if;
      end_if;
      
      // execute command
      case parameters_cmd of
        1 : // init
          result := def;
          ee_parameters[idx] := def;
          ee_save_req := 1;
        2 : // save
          result := val;
          ee_parameters[idx] := val;
          ee_save_req := 1;
        3 : // load
          result := ee_parameters[idx];
      else
        result := val;
      end_case;
      
      // test if saved
      if result <> ee_parameters[idx] then
        parameters_saved := 0;
        parameters_unsaved_idx := idx;
      end_if;
      
      // crc 32 calc
      parameters_crc_tmp := f_crc_32_update(parameters_crc_tmp,result);
    end;
    function f_crc_32_update(crc,val:long):long; language 'Structured Text';
    begin
      
      
      result := crc xor val;
      for j := 1 to 8 do
        if (result and 1) <> 0 then
          result := (result shr 1) xor 16#EDB88320;
        else
          result := (result shr 1);
        end_if;
      end_for;
      
    end;
  begin
    
    if !ee_read_req and !ee_write_req then
    
      // init general parameters statuses
      parameters_saved := 1;
      parameters_error_idx := -1;
      parameters_unsaved_idx := -1;
      parameters_error := 0;
      ee_parameters_error := 0;
    
      // if retentive fail then read from ee
      if retentive_magic <> 31415 and ee_parameters_ok then
        parameters_cmd := 3; // read from ee
        retentive_magic := 31415;
      end_if;
    
      // don't read if ee parameters are not ok
      if !ee_parameters_ok and parameters_cmd = 3 then
        parameters_cmd := 0;
      end_if;
      // don't save if parameters are not ok
      if !parameters_ok and parameters_cmd = 2 then
        parameters_cmd := 0;
      end_if;
    
      //*********************************************************************************************************************
    
      // CRC32 init
      parameters_crc_tmp := 16#FFFFFFFF;
    
      // system [0..9]
      push_enable := bit(f_parameters_manage( 0,push_enable,1,0,1));
      modbus_msg_tout := int(f_parameters_manage( 1,modbus_msg_tout,250,0,1000));
      modbus_char_tout := int(f_parameters_manage( 2,modbus_char_tout,25,0,1000));
      modbus_retry := int(f_parameters_manage( 3,modbus_retry,5,0,10));
    
      // enocean commands [10..49]
      for i := 0 to 17 do
        eno_mem_0[i] := int(f_parameters_manage(10+i,eno_mem_0[i],0,-32768,32767));
        eno_mem_1[i] := int(f_parameters_manage(30+i,eno_mem_1[i],0,-32768,32767));
      end_for;
    
      // sources [50..59]
      for i := 0 to 9 do
        if consumer_type[i] <> 3 then
          source_power_nominal[i] := (f_parameters_manage(50+i,source_power_nominal[i],0,0,999999));
        end_if;
      end_for;
    
      // consumers [60..78]
      for i := 0 to 18 do
        consumer_icon[i] := int(f_parameters_manage(60+i,consumer_icon[i],0,0,39));
      end_for;
    
      // [80..179]
      for i := 0 to 17 do
        consumer_override_preset[i] := int(f_parameters_manage(80+i,consumer_override_preset[i],0,0,32767));
        consumer_type[i] := int(f_parameters_manage(100+i,consumer_type[i],0,0,7));
        consumer_address[i] := int(f_parameters_manage(120+i,consumer_address[i],0,0,32767));
        consumer_index[i] := int(f_parameters_manage(140+i,consumer_index[i],0,0,32767));
        if consumer_type[i] <> 3 then
          consumer_power_nominal[i] := (f_parameters_manage(160+i,consumer_power_nominal[i],0,0,999999));
        end_if;
      end_for;
      // [180..479]
      for i := 0 to 294 do
        consumer_name[i] := int(f_parameters_manage(180+i,consumer_name[i],0,0,32767));
      end_for;
    
      // loads [480..579]
      for i := 0 to 17 do
        load_type[i] := int(f_parameters_manage(480+i,load_type[i],0,0,8));
        load_address[i] := int(f_parameters_manage(500+i,load_address[i],0,0,32767));
        load_index[i] := int(f_parameters_manage(520+i,load_index[i],0,0,32767));
        load_override_preset[i] := int(f_parameters_manage(540+i,load_override_preset[i],0,0,32767));
        load_inverted[i] := bit(f_parameters_manage(560+i,load_inverted[i],0,0,1));
      end_for;
    
      // timetable [580..589]
      for i := 0 to 7 do
        timetable_enable[i] := bit(f_parameters_manage(580+i,timetable_enable[i],0,0,1));
      end_for;
    
      // cloud optimization [590..617]
      for i := 0 to 7 do
        timetable_cloud_once[i] := bit(f_parameters_manage(590+i,timetable_cloud_once[i],1,0,1));
        timetable_cloud_recurring[i] := bit(f_parameters_manage(600+i,timetable_cloud_recurring[i],1,0,1));
        timetable_cloud_analog[i] := bit(f_parameters_manage(610+i,timetable_cloud_analog[i],1,0,1));
      end_for;
    
      timetable_battery_default := bit(f_parameters_manage(620,timetable_battery_default,1,0,1));
      timetable_battery_optimization := bit(f_parameters_manage(621,timetable_battery_optimization,1,0,1));
    
    
      // finish crc 32 calc
      parameters_crc_tmp := !parameters_crc_tmp;
    
      //*********************************************************************************************************************
    
      // OK if no errors
      ee_parameters_ok := !ee_parameters_error;
      parameters_ok := !parameters_error;
    
      // save ee_par
      if ee_save_req then
        ee_write_magic := 31415;
        ee_write_req := 1;
      end_if;
      ee_save_req := 0;
    
      // init non ee parameters
      if parameters_cmd = 1 then
        // timetables
        for i := 0 to 5375 do
          timetable[i] := 0;
          timetable_analog[i] := -1;
        end_for;
        // tariff timetable
        for i := 0 to 671 do
          timetable_tariff[i] := 0;
        end_for;
        // battery timetable
        for i := 0 to 671 do
          timetable_battery[i] := -32768;
        end_for;
    
        modbus_step := 0; // restart modbus comm
    
      end_if;
    
      if parameters_cmd <> 0 then
        parameters_crc32 := parameters_crc_tmp;
      end_if;
    
      // clear command
      parameters_cmd := 0;
    
      // status
      parameters_status := 4*ee_parameters_ok + 2*parameters_ok + parameters_saved;
    
    end_if;
    
    // parameters crc32 calculations
    
    if parameters_crc_tmp = parameters_crc_tmp_old and parameters_crc_tmp <> parameters_crc32 then
      parameters_crc_timer := parameters_crc_timer + scan_time;
    else
      parameters_crc_timer := 0;
    end_if;
    parameters_crc_tmp_old := parameters_crc_tmp;
    
    if parameters_crc_timer >= (long(parameters_crc_preset)*60*1000) then
      parameters_crc32 := parameters_crc_tmp;
      if parameters_autosave then
        parameters_cmd := 2;
      end_if;
    end_if;
    
    
  end;
  function f_system:void; language 'Structured Text';
    function f_push:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var constant
      PUSHPERIOD = 30; // Period in which push message is sent to server [s].
    var_end;

    begin
      /*
      
        Push communication with WEB server
      
      */
      
      if fp(clock_1s) then // generate periodic push message
        if push_enable then
          if push_timer>0 then
            push_timer:=push_timer-1;
          else
            push_req:=1;
            push_timer:=PUSHPERIOD-1; // push period [s]
          end_if;
        else
          push_timer:=0;
          push_status:=0; // disabled
        end_if;
      end_if;
      
      if push_req then // new push cycle
        push_req:=0;
        push_status:=1; // waiting
        push_roundtrip:=0;
        push_message_req:=1; // send push message
        push_req_counter:=push_req_counter+1; // transmitted messages
      end_if;
      
      if push_message_ack then // acknowledge received
        push_message_ack:=0;
        push_status:=2; // ok
        push_ack_counter:=push_ack_counter+1; // received messages
      end_if;
      
      if push_status==1 then // waiting for answer
        push_roundtrip:=push_roundtrip+scan_time; // elapsed milliseconds
        if push_roundtrip>=5000 then // server timeout [ms]
          push_roundtrip:=0;
          push_status:=3; // error
        end_if;
      end_if;
      
    end;
    function f_general_status:void; language 'Structured Text';
    begin
      
      general_status := 1; // OK
      
      for i := 0 to 17 do
        if consumer_status[i] = 2 or load_status[i] = 2 then
          general_status := 2; // ERR
        end_if;
      end_for;
      
      if nok_network_status <> 2 then
        general_status := 2; // ERR
      end_if;
      
      if parameters_status <> 2#0111 then
        general_status := 2; // ERR
      end_if;
    end;
    function f_time:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      edit_year_old: int;
      edit_month_old: int;
      edit_date_old: int;
      edit_weekday_old: int;
      edit_hour_old: int;
      edit_min_old: int;
      edit_sec_old: int;
      time: long;
    var_end;

    begin
      // ****************************************************************************
      // rtc
      // ****************************************************************************
      
      day_min := rtc_hour*60+rtc_min;
      
      // ****************************************************************************
      // edit date time
      // ****************************************************************************
      
      if edit_year <> edit_year_old or
         edit_month <> edit_month_old or
         edit_date <> edit_date_old or
         edit_weekday <> edit_weekday_old or
         edit_hour <> edit_hour_old or
         edit_min <> edit_min_old or
         edit_sec <> edit_sec_old
      then
        edit_datetime := 1;
      end_if;
      
      //if first_scan then
      //  datetime_cmd := 2;
      //end_if;
      
      if !edit_datetime then
        datetime_cmd := 0;
      end_if;
      
      case datetime_cmd of // set datetime
        1: // set datetime
          rtc_year := edit_year;
          rtc_month := edit_month;
          rtc_date := edit_date;
          rtc_weekday := edit_weekday;
          rtc_hour := edit_hour;
          rtc_min := edit_min;
          rtc_sec := edit_sec;
          rtc_write_req := 1;
          edit_datetime := 0;
        2:  // cancel
          edit_year := rtc_year;
          edit_month := rtc_month;
          edit_date := rtc_date;
          edit_weekday := rtc_weekday;
          edit_hour := rtc_hour;
          edit_min := rtc_min;
          edit_sec := rtc_sec;
          edit_year_old := edit_year;
          edit_month_old := edit_month;
          edit_date_old := edit_date;
          edit_weekday_old := edit_weekday;
          edit_hour_old := edit_hour;
          edit_min_old := edit_min;
          edit_sec_old := edit_sec;
          edit_datetime := 0;
      end_case;
      datetime_cmd := 0;
      
      if !edit_datetime then
        edit_year := rtc_year;
        edit_month := rtc_month;
        edit_date := rtc_date;
        edit_weekday := rtc_weekday;
        edit_hour := rtc_hour;
        edit_min := rtc_min;
        edit_sec := rtc_sec;
        edit_year_old := edit_year;
        edit_month_old := edit_month;
        edit_date_old := edit_date;
        edit_weekday_old := edit_weekday;
        edit_hour_old := edit_hour;
        edit_min_old := edit_min;
        edit_sec_old := edit_sec;
      end_if;
      
    end;
    function f_hiq:void; language 'Structured Text';
    begin
      // ****************************************************************************
      // hiq commander compatibility
      // ****************************************************************************
      
      // update load_set
      if fp(lc00_qx00) or fn(lc00_qx00) then
        load_set[10] := lc00_qx00;
      end_if;
      if fp(lc00_qx01) or fn(lc00_qx01) then
        load_set[11] := lc00_qx01;
      end_if;
      if fp(lc00_qx02) or fn(lc00_qx02) then
        load_set[12] := lc00_qx02;
      end_if;
      if fp(lc00_qx03) or fn(lc00_qx03) then
        load_set[13] := lc00_qx03;
      end_if;
      if fp(lc00_qx04) or fn(lc00_qx04) then
        load_set[14] := lc00_qx04;
      end_if;
      if fp(lc00_qx05) or fn(lc00_qx05) then
        load_set[15] := lc00_qx05;
      end_if;
      if fp(lc00_qx06) or fn(lc00_qx06) then
        load_set[16] := lc00_qx06;
      end_if;
      if fp(lc00_qx07) or fn(lc00_qx07) then
        load_set[17] := lc00_qx07;
      end_if;
      
      lc00_qx00 := load_set[10];
      lc00_qx01 := load_set[11];
      lc00_qx02 := load_set[12];
      lc00_qx03 := load_set[13];
      lc00_qx04 := load_set[14];
      lc00_qx05 := load_set[15];
      lc00_qx06 := load_set[16];
      lc00_qx07 := load_set[17];
      
      
    end;
  begin
    
    if !start then
      reset_counter:=reset_counter+1;
      datetime_cmd := 2; // cancel
      eno00_general_error := 1;
      air00_general_error := 1;
      ts00_general_error := 1;
      ts01_general_error := 1;
      ts02_general_error := 1;
      ts03_general_error := 1;
      ts04_general_error := 1;
      ts05_general_error := 1;
      ts06_general_error := 1;
      ts07_general_error := 1;
      start := 1;
    end_if;
    
    // once per hour increment cybro uptime and operating hours
    
    if fp(rtc_min==0) then
      cybro_uptime:=cybro_uptime+1;
      operating_hours:=operating_hours+1;
    end_if;
    
    f_time();
    
    f_push();
    
    f_general_status();
    
    f_hiq();
    
    
  end;
  function f_io_mux:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var static
    cybro_qx00_old: bool;
    cybro_qx01_old: bool;
    cybro_qx02_old: bool;
    cybro_qx03_old: bool;
    cybro_qx04_old: bool;
    cybro_qx05_old: bool;
    cybro_qx06_old: bool;
    cybro_qx07_old: bool;
  var_end;

  var
    txt_i: int;
    chr: int;
    txt_j: int;
    insert: bool;
    full: bool;
  var_end;

    function min_max(val,v_min,v_max:int):int; language 'Structured Text';
    begin
      
      // function min_max(val, min, max:int):int;
      //
      // limit val to min - max
      
      if val > v_max then
        result := v_max;
      elsif val < v_min then
        result := v_min;
      else
        result := val;
      end_if;
    end;
  begin
    // ****************************************************************************
    // HEMS digital IO
    // ****************************************************************************
    
    i := 10;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx00 <> cybro_qx00_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx00;
        else
          load_set[i] := cybro_qx00;
        end_if;
      else
        cybro_qx00 := load_out[i];
      end_if;
    end_if;
    cybro_qx00_old := cybro_qx00;
    
    i := 11;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx01 <> cybro_qx01_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx01;
        else
          load_set[i] := cybro_qx01;
        end_if;
      else
        cybro_qx01 := load_out[i];
      end_if;
    end_if;
    cybro_qx01_old := cybro_qx01;
    
    i := 12;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx02 <> cybro_qx02_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx02;
        else
          load_set[i] := cybro_qx02;
        end_if;
      else
        cybro_qx02 := load_out[i];
      end_if;
    end_if;
    cybro_qx02_old := cybro_qx02;
    
    i := 13;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx03 <> cybro_qx03_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx03;
        else
          load_set[i] := cybro_qx03;
        end_if;
      else
        cybro_qx03 := load_out[i];
      end_if;
    end_if;
    cybro_qx03_old := cybro_qx03;
    
    i := 14;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx04 <> cybro_qx04_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx04;
        else
          load_set[i] := cybro_qx04;
        end_if;
      else
        cybro_qx04 := load_out[i];
      end_if;
    end_if;
    cybro_qx04_old := cybro_qx04;
    
    i := 15;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx05 <> cybro_qx05_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx05;
        else
          load_set[i] := cybro_qx05;
        end_if;
      else
        cybro_qx05 := load_out[i];
      end_if;
    end_if;
    cybro_qx05_old := cybro_qx05;
    
    i := 16;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx06 <> cybro_qx06_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx06;
        else
          load_set[i] := cybro_qx06;
        end_if;
      else
        cybro_qx06 := load_out[i];
      end_if;
    end_if;
    cybro_qx06_old := cybro_qx06;
    
    i := 17;
    if load_type[i]=1 or load_type[i]=8  or load_type[i]=10 then
      if cybro_qx07 <> cybro_qx07_old then
        if load_inverted[i] then
          load_set[i] := !cybro_qx07;
        else
          load_set[i] := cybro_qx07;
        end_if;
      else
        cybro_qx07 := load_out[i];
      end_if;
    end_if;
    cybro_qx07_old := cybro_qx07;
    
    if fp(cybro_ix00) and load_type[10]=1 then load_set[10] := !load_set[10]; end_if;
    if fp(cybro_ix01) and load_type[11]=1 then load_set[11] := !load_set[11]; end_if;
    if fp(cybro_ix02) and load_type[12]=1 then load_set[12] := !load_set[12]; end_if;
    if fp(cybro_ix03) and load_type[13]=1 then load_set[13] := !load_set[13]; end_if;
    if fp(cybro_ix04) and load_type[14]=1 then load_set[14] := !load_set[14]; end_if;
    if fp(cybro_ix05) and load_type[15]=1 then load_set[15] := !load_set[15]; end_if;
    if fp(cybro_ix06) and load_type[16]=1 then load_set[16] := !load_set[16]; end_if;
    if fp(cybro_ix07) and load_type[17]=1 then load_set[17] := !load_set[17]; end_if;
    
    // ****************************************************************************
    // HEMS analog out
    // ****************************************************************************
    
    pulse_train_frequency := 1000; // PWM f = 1 kHz
    
    i := 10;
    analog_out[i] := min_max(analog_out[i],0,100);
    case load_type[i] of
      7 : // AO 0..10V
        cybro_qw12 := 100 * analog_out[i];
        cybro_io12_mode := 5;
      8 : // DO + AO 0..10V
        cybro_qw12 := 100 * analog_out[i];
        cybro_io12_mode := 5;
      9 : // AO PWM
        cybro_qw12 := analog_out[i];
        cybro_io12_mode := 11;
      10 : // DO + AO PWM
        cybro_qw12 := analog_out[i];
        cybro_io12_mode := 11;
    else
        cybro_qw12 := 0;
    end_case;
    
    i := 11;
    analog_out[i] := min_max(analog_out[i],0,100);
    case load_type[i] of
      7 : // AO 0..10V
        cybro_qw13 := 100 * analog_out[i];
        cybro_io13_mode := 5;
      8 : // DO + AO 0..10V
        cybro_qw13 := 100 * analog_out[i];
        cybro_io13_mode := 5;
      9 : // AO PWM
        cybro_qw13 := analog_out[i];
        cybro_io13_mode := 11;
      10 : // DO + AO PWM
        cybro_qw13 := analog_out[i];
        cybro_io13_mode := 11;
    else
        cybro_qw13 := 0;
    end_case;
    
    i := 12;
    analog_out[i] := min_max(analog_out[i],0,100);
    case load_type[i] of
      7 : // AO 0..10V
        cybro_qw14 := 100 * analog_out[i];
        cybro_io14_mode := 5;
      8 : // DO + AO 0..10V
        cybro_qw14 := 100 * analog_out[i];
        cybro_io14_mode := 5;
      9 : // AO PWM
        cybro_qw14 := analog_out[i];
        cybro_io14_mode := 11;
      10 : // DO + AO PWM
        cybro_qw14 := analog_out[i];
        cybro_io14_mode := 11;
    else
        cybro_qw14 := 0;
    end_case;
    
    i := 13;
    analog_out[i] := min_max(analog_out[i],0,100);
    case load_type[i] of
      7 : // AO 0..10V
        cybro_qw15 := 100 * analog_out[i];
        cybro_io15_mode := 5;
      8 : // DO + AO 0..10V
        cybro_qw15 := 100 * analog_out[i];
        cybro_io15_mode := 5;
      9 : // AO PWM
        cybro_qw15 := analog_out[i];
        cybro_io15_mode := 11;
      10 : // DO + AO PWM
        cybro_qw15 := analog_out[i];
        cybro_io15_mode := 11;
    else
        cybro_qw15 := 0;
    end_case;
    
    // ****************************************************************************
    // SENSORS
    // ****************************************************************************
    
    for i := 10 to 17 do
      sensor_state[i] := sensor_status[i];
      if sensor_status[i] <> 1 then
        sensor_temperature_1[i] := 0;
        sensor_temperature_2[i] := 0;
        sensor_humidity[i] := 0;
        sensor_ix00[i] := 0;
        sensor_ix01[i] := 0;
      end_if;
    end_for;
    
    if !air00_general_error then
      i := 10;
      if !air00_sensor_error_0 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw00;
        sensor_state[i] := 1;
      end_if;
      i := 11;
      if !air00_sensor_error_1 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw01;
        sensor_state[i] := 1;
      end_if;
      i := 12;
      if !air00_sensor_error_2 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw02;
        sensor_state[i] := 1;
      end_if;
      i := 13;
      if !air00_sensor_error_3 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw03;
        sensor_state[i] := 1;
      end_if;
      i := 14;
      if !air00_sensor_error_4 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw04;
        sensor_state[i] := 1;
      end_if;
      i := 15;
      if !air00_sensor_error_5 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw05;
        sensor_state[i] := 1;
      end_if;
      i := 16;
      if !air00_sensor_error_6 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw06;
        sensor_state[i] := 1;
      end_if;
      i := 17;
      if !air00_sensor_error_7 and sensor_state[i]<>1 then
        sensor_temperature_1[i] := air00_iw07;
        sensor_state[i] := 1;
      end_if;
    else
      air00_sensor_error_0 := 1;
      air00_sensor_error_1 := 1;
      air00_sensor_error_2 := 1;
      air00_sensor_error_3 := 1;
      air00_sensor_error_4 := 1;
      air00_sensor_error_5 := 1;
      air00_sensor_error_6 := 1;
      air00_sensor_error_7 := 1;
      air00_sensor_error_8 := 1;
      air00_sensor_error_9 := 1;
      air00_sensor_error_10 := 1;
      air00_sensor_error_11 := 1;
    end_if;
    
    i := 10;
    if !ts00_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts00_temperature_0 * !ts00_sensor_error_0;
      sensor_temperature_2[i] := ts00_temperature_1 * !ts00_sensor_error_1;
      sensor_humidity[i] := ts00_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 11;
    if !ts01_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts01_temperature_0 * !ts01_sensor_error_0;
      sensor_temperature_2[i] := ts01_temperature_1 * !ts01_sensor_error_1;
      sensor_humidity[i] := ts01_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 12;
    if !ts02_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts02_temperature_0 * !ts02_sensor_error_0;
      sensor_temperature_2[i] := ts02_temperature_1 * !ts02_sensor_error_1;
      sensor_humidity[i] := ts02_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 13;
    if !ts03_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts03_temperature_0 * !ts03_sensor_error_0;
      sensor_temperature_2[i] := ts03_temperature_1 * !ts03_sensor_error_1;
      sensor_humidity[i] := ts03_humidity ;
      sensor_state[i] := 1;
    end_if;
    
    i := 14;
    if !ts04_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts04_temperature_0 * !ts04_sensor_error_0;
      sensor_temperature_2[i] := ts04_temperature_1 * !ts04_sensor_error_1;
      sensor_humidity[i] := ts04_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 15;
    if !ts05_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts05_temperature_0 * !ts05_sensor_error_0;
      sensor_temperature_2[i] := ts05_temperature_1 * !ts05_sensor_error_1;
      sensor_humidity[i] := ts05_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 16;
    if !ts06_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts06_temperature_0 * !ts06_sensor_error_0;
      sensor_temperature_2[i] := ts06_temperature_1 * !ts06_sensor_error_1;
      sensor_humidity[i] := ts06_humidity;
      sensor_state[i] := 1;
    end_if;
    
    i := 17;
    if !ts07_general_error and sensor_state[i]<>1 then
      sensor_temperature_1[i] := ts07_temperature_0 * !ts07_sensor_error_0;
      sensor_temperature_2[i] := ts07_temperature_1 * !ts07_sensor_error_1;
      sensor_humidity[i] := ts07_humidity;
      sensor_state[i] := 1;
    end_if;
    
    
    // ****************************************************************************
    // discover eStore and HIQ Home
    // ****************************************************************************
    
    txt_i := 0;
    txt_j := 0;
    for i := 0 to 70 do
      estore_nad_txt[i] := 0;
      hiq_home_nad_txt[i] := 0;
    end_for;
    estore_general_error := 1;
    hiq_home_general_error := 1;
    for i := 0 to 9 do
      if estore_nad_list[i] > 0 then
        estore_general_error := 0;
        for j := 0 to 6 do
          case j of
            0 : if txt_i > 0 then chr := 44; else chr := 0; end_if;
            1 : if txt_i > 0 then chr := 32; else chr := 0; end_if;
            2 : if estore_nad_list[i] > 9999 then chr := 48 + estore_nad_list[i] / 10000; else chr := 0; end_if;
            3 : if estore_nad_list[i] > 999 then chr := 48 + (estore_nad_list[i] / 1000) % 10; else chr := 0; end_if;
            4 : if estore_nad_list[i] > 99 then chr := 48 + (estore_nad_list[i] / 100) % 10; else chr := 0; end_if;
            5 : if estore_nad_list[i] > 9 then chr := 48 + (estore_nad_list[i] / 10) % 10; else chr := 0; end_if;
            6 : chr := 48 + (estore_nad_list[i]) % 10;
          end_case;
          if chr > 0 then
            estore_nad_txt[txt_i] := chr;
            txt_i := txt_i + 1;
          end_if;
        end_for;
      end_if;
      if hiq_home_nad_list[i] > 0 then
        hiq_home_general_error := 0;
        for j := 0 to 6 do
          case j of
            0 : if txt_j > 0 then chr := 44; else chr := 0; end_if;
            1 : if txt_j > 0 then chr := 32; else chr := 0; end_if;
            2 : if hiq_home_nad_list[i] > 9999 then chr := 48 + hiq_home_nad_list[i] / 10000; else chr := 0; end_if;
            3 : if hiq_home_nad_list[i] > 999 then chr := 48 + (hiq_home_nad_list[i] / 1000) % 10; else chr := 0; end_if;
            4 : if hiq_home_nad_list[i] > 99 then chr := 48 + (hiq_home_nad_list[i] / 100) % 10; else chr := 0; end_if;
            5 : if hiq_home_nad_list[i] > 9 then chr := 48 + (hiq_home_nad_list[i] / 10) % 10; else chr := 0; end_if;
            6 : chr := 48 + (hiq_home_nad_list[i]) % 10;
          end_case;
          if chr > 0 then
            hiq_home_nad_txt[txt_j] := chr;
            txt_j := txt_j + 1;
          end_if;
        end_for;
      end_if;
    end_for;
    
    if socket_id=2 and socket_from > 0 then
      insert := 1;
      full := 1;
      for i := 0 to 9 do
        if socket_from = estore_nad_list[i] then
          insert := 0;
        end_if;
        if estore_nad_list[i] = 0 then
          full := 0;
        end_if;
      end_for;
    else
      insert := 0;
      full := 0;
    end_if;
    if insert then
      if !full then
        for i := 0 to 9 do
          if estore_nad_list[i] <= 0 then
            estore_nad_list[i] := socket_from;
            i := 9;
          end_if;
          if estore_nad_list[i] = 0 then
            full := 0;
          end_if;
        end_for;
      else
        estore_nad_txt[txt_i] := 32;
        estore_nad_txt[txt_i+1] := 43;
      end_if;
    end_if;
    if estore_nad_list_clr then
      for i := 0 to 9 do
        estore_nad_list[i] := 0;
      end_for;
    end_if;
    estore_nad_list_clr := 0;
    
    if socket_id = 3 and socket_from > 0 then
      insert := 1;
      full := 1;
      for i := 0 to 9 do
        if socket_from = hiq_home_nad_list[i] then
          insert := 0;
        end_if;
        if hiq_home_nad_list[i] = 0 then
          full := 0;
        end_if;
      end_for;
    else
      insert := 0;
      full := 0;
    end_if;
    if insert then
      if !full then
        for i := 0 to 9 do
          if hiq_home_nad_list[i] <= 0 then
            hiq_home_nad_list[i] := socket_from;
            i := 9;
          end_if;
        end_for;
      else
        hiq_home_nad_txt[txt_j] := 32;
        hiq_home_nad_txt[txt_j+1] := 43;
      end_if;
    end_if;
    if hiq_home_nad_list_clr then
      for i := 0 to 9 do
        hiq_home_nad_list[i] := 0;
      end_for;
    end_if;
    hiq_home_nad_list_clr := 0;
    
  end;
  function f_algorithms:int; language 'Structured Text';
    function f_modbus:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      lm_o: int;
      modbus_step_return: int;
      modbus_step_next: int;
      address: int;
      index: int;
      step: int;
      pm_i: int;
      lm_i: int;
      s_i: int;
      timeout: int;
      cpm_i: int;
      pm_refresh_req_old: bool;
    var_end;

    var retain
      load_manager_set_old: ARRAY[0..29] OF bool;
      nok_data_valid: ARRAY[0..25] OF bool;
      r_cnt: int;
      r_i: int;
      b_i: int;
      nok_nd_valid: bool;
      load_manager_set_timeout: ARRAY[0..17] OF int;
    var_end;

    var
      exp: int;
    var_end;

      function f_modbus_read(com_port,slave_address,function_code,data_address,count:int):void; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        mb_crc: int;
        mb_step: int;
      var_end;

      var
        length: int;
      var_end;

        function f_crc(count:int; tx_rx:bit):int; language 'Structured Text';
        begin
          
          //Calaculate CRC
          
          result:=16#FFFF;
          
          for i:=0 to count do
            if !tx_rx then
              result := result xor tx_bufrd(i);
            else
              result := result xor rx_bufrd(i);
            end_if;
            for j := 1 to 8 do
              if (result and 1) <> 0 then
                result := ((result shr 1) and 16#7FFF) xor 16#A001;
              else
                result := (result shr 1) and 16#7FFF;
              end_if;
            end_for;
          end_for;
          
          
        end;
        function hi_byte(value:int):int; language 'Structured Text';
        begin
          
          //result := int(ulong(value) shr 8);
          result := value shr 8;
          
        end;
        function lo_byte(value:int):int; language 'Structured Text';
        begin
          
          result := value and 16#00FF;
        end;
        function roundup(val:real):int; language 'Structured Text';
        begin
          
          result := int(val);
          
          if val > result then
            result := result+1;
          end_if;
        end;
      begin
        /*
        
          f_modbus_req(com_port, slave_address, function_code, data_address, count)
        
          output:
            modbus_status        int 0=idle, 1=reading, 2=red OK, 3= read error
            modbus_data[0..255]  int reded data
        
        */
        
        modbus_status := 1; // reading
        
        com_select(com_port);
        
        case mb_step of
          0: // prepare and send request
            // wait for com
            if not (rx_active() or tx_active()) then
              // prepare data
              dprnc(0,0,0,slave_address);             // slave address
              dprnc(0,1,0,function_code);             // function code
              dprnc(0,2,0,hi_byte(data_address));     // data address hi
              dprnc(0,3,0,lo_byte(data_address));     // data address lo
              dprnc(0,4,0,hi_byte(count));            // number of bytes hi
              dprnc(0,5,0,lo_byte(count));            // number of bytes lo
              mb_crc := f_crc(5,0);                   // calculate crc
              dprnc(0,6,0,lo_byte(mb_crc));           // crc lo
              dprnc(0,7,0,hi_byte(mb_crc));           // crc hi
              // transmit
              tx_start(8);
              // start receiving
              rx_start(0,0,count*4+5,modbus_msg_tout,modbus_char_tout);
              // next step
              mb_step := mb_step+1;
            end_if;
        
          1: // clear data
            for i := 0 to 255 do
              modbus_data[i] := 0;
            end_for;
            mb_step := 2;
        
          2: // test if received data OK
            if not (rx_active() or tx_active()) then
              case function_code of
                1: // read coil status
                  length := roundup(real(count)/8) + 5;
                2: //
                  length := roundup(real(count)/8) + 5;
              else
                length := count * 2 + 5;
              end_case;
              if rx_count() = length then             // length OK
                if rx_bufrd(0) = slave_address and    // slave address OK
                   rx_bufrd(1) = function_code        // function code OK
                then
                  // read to modbus_data[]
                  for i := 0 to count*2 do
                    modbus_data[i]:=rx_bufrd(i+3);
                  end_for;
                  modbus_status := 2; // read ok
                else
                  // set status to error
                  modbus_status := 3; // rec message format error
                end_if;
              else
                // set status to error
                modbus_status := 4; // rec message lenght error
              end_if;
              mb_step := 0;
            end_if;
        
        end_case;
      end;
      function f_modbus_write(com_port,slave_address,function_code,data_address:int; data:long):void; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        mb_crc: int;
        mb_step: int;
      var_end;

        function f_crc(count:int; tx_rx:bit):int; language 'Structured Text';
        begin
          
          //Calaculate CRC
          
          result:=16#FFFF;
          
          for i:=0 to count do
            if !tx_rx then
              result := result xor tx_bufrd(i);
            else
              result := result xor rx_bufrd(i);
            end_if;
            for j := 1 to 8 do
              if (result and 1) <> 0 then
                result := ((result shr 1) and 16#7FFF) xor 16#A001;
              else
                result := (result shr 1) and 16#7FFF;
              end_if;
            end_for;
          end_for;
          
          
        end;
        function hi_byte(value:int):int; language 'Structured Text';
        begin
          
          result := int(ulong(value) shr 8);
        end;
        function lo_byte(value:int):int; language 'Structured Text';
        begin
          
          result := int(ulong(value) and 16#00FF);
        end;
        function roundup(val:real):int; language 'Structured Text';
        begin
          
          result := int(val);
          
          if val > result then
            result := result+1;
          end_if;
        end;
      begin
        /*
        
          f_modbus_req(com_port, slave_address, function_code, data_address, data)
        
          output:
            modbus_status        int 0=idle, 1=reading, 2=red OK, 3= read error
            modbus_data[0..255]  int reded data
        
        */
        
        modbus_status := 1; // writing
        
        com_select(com_port);
        
        case mb_step of
          0: // prepare and send request
            // wait for com
            if not (rx_active() or tx_active()) then
              // prepare data
              dprnc(0,0,0,slave_address);                   // slave address
              dprnc(0,1,0,function_code);                   // function code
              dprnc(0,2,0,hi_byte(data_address));           // data address hi
              dprnc(0,3,0,lo_byte(data_address));           // data address lo
              case function_code of
                05:
                  if data = 0 then
                    dprnc(0,4,0,16#00);                     // data off
                  else
                    dprnc(0,4,0,16#FF);                     // data on
                  end_if;
                  dprnc(0,5,0,16#00);                       // data lo
                  mb_crc := f_crc(5,0);                     // calculate crc
                  dprnc(0,6,0,lo_byte(mb_crc));             // crc lo
                  dprnc(0,7,0,hi_byte(mb_crc));             // crc hi
                  // transmit
                  tx_start(8);
                  // start receiving
                  rx_start(0,0,8,modbus_msg_tout,modbus_char_tout);
                06:
                  dprnc(0,4,0,hi_byte(int(data)));          // data hi
                  dprnc(0,5,0,lo_byte(int(data)));          // data lo
                  mb_crc := f_crc(5,0);                     // calculate crc
                  dprnc(0,6,0,lo_byte(mb_crc));             // crc lo
                  dprnc(0,7,0,hi_byte(mb_crc));             // crc hi
                  // transmit
                  tx_start(8);
                  // start receiving
                  rx_start(0,0,8,modbus_msg_tout,modbus_char_tout);
                16:
                  dprnc(0,4,0,0);                               // quantity of register hi
                  dprnc(0,5,0,2);                               // quantity of register lo
                  dprnc(0,6,0,4);                               // byte count
                  dprnc(0,7,0,hi_byte(int(data shr 16)));       // data hi-hi
                  dprnc(0,8,0,lo_byte(int(data shr 16)));       // data hi-lo
                  dprnc(0,9,0,hi_byte(int(data and 16#FFFF)));  // data lo-hi
                  dprnc(0,10,0,lo_byte(int(data and 16#FFFF))); // data lo-lo
                  mb_crc := f_crc(10,0);                        // calculate crc
                  dprnc(0,11,0,lo_byte(mb_crc));                // crc lo
                  dprnc(0,12,0,hi_byte(mb_crc));                // crc hi
                  // transmit
                  tx_start(13);
                  // start receiving
                  rx_start(0,0,8,modbus_msg_tout,modbus_char_tout);
              end_case;
              // next step
              mb_step := mb_step+1;
            end_if;
        
          1: // clear data
            for i := 0 to 255 do
              modbus_data[i] := 0;
            end_for;
            mb_step := 2;
        
          2: // test if sent OK
            if not (rx_active() or tx_active()) then
              if rx_count() = 8 then                  // length OK
                if rx_bufrd(0) = slave_address and    // slave address OK
                   rx_bufrd(1) = function_code        // function code OK
                then
                  modbus_status := 2; // read ok
                else
                  // set status to error
                  modbus_status := 3; // rec message format error
                end_if;
              else
                // set status to error
                modbus_status := 4; // rec message lenght error
              end_if;
              mb_step := 0;
            end_if;
        
        end_case;
      end;
      function f_read_int(idx:int):int; language 'Structured Text';
      begin
        
        result := 256 * modbus_data[idx*2] + modbus_data[idx*2 + 1];
      end;
      function f_read_bit(idx:int):bit; language 'Structured Text';
      begin
        
        result := bit((modbus_data[(idx/8)] shr (idx % 8)) and 1);
      end;
      function f_read_float(idx,factor:int):long; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        value: long;
      var_end;

      begin
        
        value := (ulong(modbus_data[idx+0]) shl 24) or
                 (ulong(modbus_data[idx+1]) shl 16) or
                 (ulong(modbus_data[idx+2]) shl 08) or
                 (ulong(modbus_data[idx+3]) shl 00);
        
        result := long(breal(value)*factor);
        
        
      end;
      function f_read_t6(idx:int):long; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        exponent: int;
        value: long;
        value_r: real;
      var_end;

      begin
        /*
        
          read T6 - signed measurment 32 bit
        
          bits 31..24 = exponent (signed 8 bit)
          bits 23..00 = binary signed value (24 bit)
        
          -123456*10-3 = FDFE1DC0h
        
        */
        
        // test exponent for negative
        if modbus_data[idx] >= 16#80 then
          exponent := modbus_data[idx] or 16#FF00;
        else
          exponent := modbus_data[idx];
        end_if;
        
        if modbus_data[idx+1] >= 16#80 then
          value := 16#FFFFFF00;
          value := value shl 16 or
                   (long(modbus_data[idx+1]) shl 16) or
                   (long(modbus_data[idx+2]) shl 08) or
                   (long(modbus_data[idx+3]) shl 00);
        else
          value := (long(modbus_data[idx+1]) shl 16) or
                   (long(modbus_data[idx+2]) shl 08) or
                   (long(modbus_data[idx+3]) shl 00);
        end_if;
        
        value_r := value;
        if exponent = 0 then
          result := long(value_r);
        elsif exponent > 0 then
          for i := 1 to exponent do
            value_r := value_r * 10;
          end_for;
          result := long(value_r);
        else
          for i := 1 to -exponent do
            value_r := value_r / 10;
          end_for;
          result := long(value_r);
        end_if;
      end;
      function f_read_t2(idx:int):int; language 'Structured Text';
      begin
        /*
        
          read T2 - signed 16 bit value
        
          -12345 = CFC7h
        
        */
        
        result := (modbus_data[idx] shl 8) or
                   modbus_data[idx+1];
      end;
      function f_read_t3(idx:int):long; language 'Structured Text';
      begin
        /*
        
          read T3 - signed 32 bit value
        
          -123456789 = 07BCD15h
        
        */
        
        result := (long(modbus_data[idx+0]) shl 24) or
                  (long(modbus_data[idx+1]) shl 16) or
                  (long(modbus_data[idx+2]) shl 08) or
                  (long(modbus_data[idx+3]) shl 00);
      end;
      function f_read_test(idx,val1,val2,val3:int):bit; language 'Structured Text';
      begin
        
        result := modbus_data[idx+0] = val1 and
                  modbus_data[idx+1] = val2 and
                  modbus_data[idx+2] = val3;
      end;
    begin
      
      case modbus_step of
      
      // ****************************************************************************
      // CMD ?
      // ****************************************************************************
      
        0 : // command?
          case modbus_command of
            1 : // Address PM
              modbus_step := 200;
            2 : // Init NOK_GW
              modbus_step := 220;
            3 : // Rebuild NOK_GW
              nok_network_status := 4; // destroying network
              modbus_step := 240;
            4 : // Clear NOK_D
              nok_network_status := 8; // emtying slot
              modbus_step := 260;
            5 : // Add NOK_D
              nok_network_status := 3; // open network
              modbus_step := 280;
            9 : // Close NOK_GW
              modbus_step := 220;
          else
            // main loop
            for i := 0 to 2 do
              nok_button_selected[i] := 0;
            end_for;
            for i := 0 to 17 do
              load_manager_selected[i] := 0;
              sensor_selected[i] := 0;
            end_for;
            modbus_step := 10; // write NOK_LM
          end_case;
          modbus_command := 0;
      
      // ****************************************************************************
      // Write NOK_LM
      // ****************************************************************************
      
        10 : // select load manager
          if load_manager_status[lm_o] = 1 then
            // status OK
            modbus_step := modbus_step + 1;
          else
            // no or err
            load_manager_signal[lm_o] := 0;
            load_manager_power[lm_o] := 0;
            modbus_step := 13; // next lm_o
          end_if;
      
        11 : // check if out state changed
          if load_manager_set[lm_o] <> load_manager_set_old[lm_o] then
            // value changed
            modbus_step := modbus_step + 1;
            load_manager_set_timeout[lm_o] := 2000;
            load_manager_set_old[lm_o] := load_manager_set[lm_o];
          else
            // no change
            modbus_step := 13; // next lm_o
          end_if;
      
        12 : // send on or off
          f_modbus_write(1,20+lm_o,5,2-load_manager_set[lm_o],1);
          if modbus_status = 2 then
            // write OK
            modbus_step := 13; //  next lm_o
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 13; //  next lm_o
            modbus_step := 900; // timeout & retry device
          end_if;
      
        13 : // next lm_o
          lm_o := lm_o + 1;
          if lm_o <= 17 then
            modbus_step := 10;
          else
            lm_o := 0;
            modbus_step := 20; // Set step & index
          end_if;
      
      
      // ****************************************************************************
      // Set step & index
      // ****************************************************************************
      
        20 : // Set step & index
          if pm_refresh_req and !pm_refresh_req_old then
            cpm_i := 0;
            step := 5;
          end_if;
          pm_refresh_req_old := pm_refresh_req;
          case step of
            0 : // Check NOK_GW
              address := 0;
              index := 0;
              modbus_step := 100;
              step := step + 1;
            1 : // Check NOK_LM
              if !nok_general_error then
                address := 0;
                index := 0;
                modbus_step := 110;
              end_if;
              step := step + 1;
            2 : // Check NOK_S
              if !nok_general_error then
                address := 0;
                index := 0;
                modbus_step := 120;
              end_if;
              step := step + 1;
            3 : // Check NOK_R
              if !nok_general_error then
                address := 0;
                index := 0;
                modbus_step := 130;
              end_if;
              step := step + 1;
            4 : // Check NOK_D
              if !nok_general_error then
                address := 0;
                index := 0;
                modbus_step := 140;
              end_if;
              step := step + 1;
            5 : // Check PM
              address := cpm_i + 149;
              index := cpm_i;
              modbus_step := 150;
              cpm_i := cpm_i + 1;
              if cpm_i = 2 then cpm_i := 5; end_if;
              if pm_refresh_req then
                if cpm_i > 18 then
                  cpm_i := 0;
                  step := step + 1;
                  pm_refresh_req := 0;
                end_if;
              else
                if cpm_i > 18 then cpm_i := 0; end_if;
                step := step + 1;
              end_if;
            6 : // Read NOK_LM
              if !nok_general_error then
                if load_manager_status[10+lm_i] = 1 then
                  address := lm_i + 30;
                  index := 10+lm_i;
                  modbus_step := 160;
                end_if;
                lm_i := lm_i + 1;
                if lm_i > 7 then
                  lm_i := 0;
                  step := step + 1;
                end_if;
              else
                step := step + 1;
              end_if;
            7 : // Read NOK_S
              if !nok_general_error then
                if sensor_status[10+s_i] = 1 then
                  address := s_i + 60;
                  index := 10+s_i;
                  modbus_step := 170;
                end_if;
                s_i := s_i + 1;
                if s_i > 7 then
                  s_i := 0;
                  step := step + 1;
                end_if;
              else
                step := step + 1;
              end_if;
            8 : // Read NOK_R
              if !nok_general_error then
                index := r_i;
                modbus_step := 180;
              end_if;
              r_i := r_i + 1;
              if r_i > r_cnt or b_i > 3 then
                for i := b_i to 3 do
                  bridge_status[b_i] := 0; // none
                  bridge_signal[b_i] := 0;
                end_for;
                r_i := 0;
                b_i := 0;
              end_if;
              step := step + 1;
            9 : // Read PM
              if power_meter_type[pm_i] > 0 then
                address := pm_i + 150;
                index := pm_i;
                modbus_step := 190;
              end_if;
              pm_i := pm_i + 1;
              if pm_i = 2 then
                pm_i := 4;
              elsif pm_i > 17 then
                pm_i := 0;
                step := 0;
              end_if;
          end_case;
      
      // ****************************************************************************
      // Check NOK_GW
      // ****************************************************************************
      
        100 : // read NOK_GW device type
          f_modbus_read(1,1,4,0,1);  // request device type
          if modbus_status = 2 then
            // response OK
            if f_read_int(0) = 112 then
              // device type OK
              modbus_step := modbus_step + 1;
            else
              // wrong device type
              nok_general_error := 1;
              nok_network_status := 0; // no gw
              modbus_step := 0; // next device
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        101 : // request NOK_GW network state & network opened / closed
          f_modbus_read(1,1,2,0,2);
          if modbus_status = 2 then
            // response OK
            if f_read_bit(0) then
              // connected
              if f_read_bit(1) then
                // opened
                nok_general_error := 1;
                nok_network_status := 3; // network open
                modbus_step := 0;
              else
                // closed
                modbus_step := modbus_step+1; // check network opened / closed
              end_if;
            else
              // disconnected
              nok_general_error := 1;
              nok_network_status := 1; // no network
              modbus_step := modbus_step + 1;
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        102 : // check NOK_GW parameters
          f_modbus_read(1,1,3,3,10);
          if modbus_status = 2 then
            // response OK
            if f_read_int(0)=17 and
               f_read_int(8)=149 and
               f_read_int(9)=175
            then
              // parameters OK
              nok_general_error := 0;
              nok_network_status := 2; // normal (network closed)
            else
              // parameters error
              nok_general_error := 1;
              nok_network_status := 12; // parameters error
            end_if;
            modbus_step := 0;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Check NOK_LM
      // ****************************************************************************
      
        110 : // read nok load manager devices data valid
          f_modbus_read(1,1,2,132,25);
          if modbus_status = 2 then
            // response OK
            for i := 0 to 17 do
              nok_data_valid[i] := f_read_bit(i);
            end_for;
            modbus_step := modbus_step + 1; // read nok devices data valid
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
        111: // read nok load manager devices presence
          f_modbus_read(1,1,2,20,25);
          if modbus_status = 2 then
            // response OK
            for i := 0 to 17 do
              if f_read_bit(i) <> nok_data_valid[i] then
                load_manager_status[i] := 2; // error
              else
                load_manager_status[i] := nok_data_valid[i];
              end_if;
            end_for;
            modbus_step := 0;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Check NOK_S
      // ****************************************************************************
      
        120 : // read nok sensor devices data valid
          f_modbus_read(1,1,2,162,25);
          if modbus_status = 2 then
            // response OK
            for i := 0 to 17 do
              nok_data_valid[i] := f_read_bit(i);
            end_for;
            modbus_step := modbus_step + 1; // read nok devices data valid
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
        121: // read nok load manager devices presence
          f_modbus_read(1,1,2,50,25);
          if modbus_status = 2 then
            // response OK
            for i := 0 to 17 do
              if f_read_bit(i) <> nok_data_valid[i] then
                sensor_status[i] := 2; // error
              else
                sensor_status[i] := nok_data_valid[i];
              end_if;
              if sensor_status[i] <> 1 then
                sensor_signal[i] := 0;
              end_if;
            end_for;
            modbus_step := 0;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Check NOK_R
      // ****************************************************************************
      
        130: // read routers count
          f_modbus_read(1,1,4,21,1);
          if modbus_status = 2 then
            // response OK
            r_cnt := f_read_int(0);
            modbus_step := 0;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      
      // ****************************************************************************
      // Check new NOK_D
      // ****************************************************************************
      
        140 : //  read new device data valid
          f_modbus_read(1,1,2,239,1);
          if modbus_status = 2 then
            // response OK
            nok_nd_valid := f_read_bit(0);
            modbus_step := modbus_step + 1; // read nok devices data valid
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
        141: // read new device presence
          f_modbus_read(1,1,2,239,1);
          if modbus_status = 2 then
            // response OK
            if nok_nd_valid <> f_read_bit(0) then
              nok_new_device_status := 2; // error
            else
              nok_new_device_status := nok_nd_valid;
            end_if;
            modbus_step := modbus_step + 1; // clear device
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
        142: // clear new device slot if occupied
          if nok_new_device_status <> 0 then
            modbus_argument := 127;
            modbus_command := 4;
          end_if;
          modbus_step := 0;
      
      // ****************************************************************************
      // check PM
      // ****************************************************************************
      
        150: // read new power-meter
          f_modbus_read(1, address, 4, 0, 4);
          if modbus_status = 2 then
            // read OK
            if f_read_test(2,16#57,16#4D,16#33) then
              // ISKRA
              pm_type[index] := 3;
              modbus_step := 0;
            else
              // EASTRON
              pm_type[index] := 1;
              modbus_step := 0;
            end_if;
          elsif modbus_status >=3 then
            // no response
            pm_type[index] := 0;
            modbus_step := 0;
          end_if;
          if index = 0 then
            power_meter_new := pm_type[index];
            power_meter_old_address := 149;
            power_meter_new_type := power_meter_new;
          end_if;
      
      // ****************************************************************************
      // read NOK_LM
      // ****************************************************************************
      
        160: // read out state
          if load_manager_set_timeout[index] > 0 then // value was written
            modbus_step := modbus_step + 1; // read power & energy
          else
            f_modbus_read(1,address,2,0,1);
            if modbus_status = 2 then
              // response OK
              load_manager_set[index] := f_read_bit(0);
              load_manager_set_old[index] := load_manager_set[index];
              modbus_step := modbus_step + 1; // read power & energy
            elsif modbus_status >=3 then
              // no response
              if modbus_retry_count = modbus_retry then
                nok_general_error := 1;
                nok_network_status := 0; // no gw
              end_if;
              modbus_step_return := modbus_step;
              modbus_step_next := 0; // next device
              modbus_step := 900; // retry device
            end_if;
          end_if;
      
        161: // read power & energy
          f_modbus_read(1,address,4,5,3);
          if modbus_status = 2 then
            // response OK
            load_manager_power[index] := f_read_int(0);
            load_manager_energy[index] := ulong(f_read_int(1)) + ulong(f_read_int(2))*65536;
            modbus_step := modbus_step + 1; // read message cnt and signal
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next device
            modbus_step := 900; // retry device
          end_if;
      
        162: // read message cnt and signal
          f_modbus_read(1,address,4,2,2);
          if modbus_status = 2 then
            // response OK
            load_manager_message_cnt[index] := f_read_int(0);
            load_manager_signal[index] := f_read_int(1);
            modbus_step := 0; // next device
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next device
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Read NOK_S
      // ****************************************************************************
      
        170: // check device type
          f_modbus_read(1,address,4,0,1);
          if modbus_status = 2 then
            // response OK
            if f_read_int(0) = 2 or f_read_int(0) = 18 then
              // -TID-
              modbus_step := 171; // read TID temperatures
            else
              // -THI-
              modbus_step := 173; // read THI temperatures
            end_if;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next sensor
            modbus_step := 900; // retry device
          end_if;
      
        171: // read TID temperatures
          f_modbus_read(1,address,4,6,2);
          if modbus_status = 2 then
            // response OK
            sensor_temperature_1[index] := f_read_int(0);
            sensor_temperature_2[index] := f_read_int(1);
            sensor_humidity[index] := 0;
            modbus_step := modbus_step + 1; // read nok devices data valid
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next sensor
            modbus_step := 900; // retry device
          end_if;
      
        172: // read TID inputs
          f_modbus_read(1,address,2,4,2);
          if modbus_status = 2 then
            // response OK
            sensor_ix00[index] := f_read_bit(0);
            sensor_ix01[index] := f_read_bit(1);
            modbus_step := 174; // read message cnt & signal
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next sensor
            modbus_step := 900; // retry device
          end_if;
      
        173: // read THI temperature and humidity
          f_modbus_read(1,address,4,6,3);
          if modbus_status = 2 then
            // response OK
            sensor_temperature_1[index] := f_read_int(0);
            sensor_temperature_2[index] := 0;
            sensor_humidity[index] := f_read_int(2);
            sensor_ix00[index] := 0;
            sensor_ix01[index] := 0;
            modbus_step := 174; // read message cnt & signal
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next sensor
            modbus_step := 900; // retry device
          end_if;
      
        174: // read message cnt and signal
          f_modbus_read(1,address,4,2,2);
          if modbus_status = 2 then
            // response OK
            sensor_message_cnt[index] := f_read_int(0);
            sensor_signal[index] :=  f_read_int(1);
            modbus_step := 0; // next sensor
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next sensor
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Read NOK_R
      // ****************************************************************************
      
        180: // read router data
          f_modbus_read(1,1,4,1000+r_i*12,11);
          if modbus_status = 2 then
            // response OK
            if f_read_int(1) = 101 then
              // bridge detected
              bridge_status[b_i] := 1; // status OK
              bridge_signal[b_i] := f_read_int(7);
              b_i := b_i + 1;
            end_if;
            modbus_step := 0; // next device
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Read PM
      // ****************************************************************************
      
        190: // select power meter
          if power_meter_type[index] = 1 then
            // read eastron
            modbus_step := 191; // read eastron power
          elsif power_meter_type[index] = 2 then
            // read iskra
            modbus_step := 194; // read iskra power
          else
            // no power meter
            power_meter_status[index] := 0;
            modbus_step := 0; // next
          end_if;
      
        191: // verify if eastron
          f_modbus_read(1, address, 4, 1, 2);
          if modbus_status = 2 then
            // read OK
            if f_read_test(0,16#57,16#4D,16#33) then
              // ISKRA
              power_meter_status[index] := 2; // error
              modbus_step := 0; // next power meter
            else
              // EASTRON
              modbus_step := modbus_step + 1;
            end_if;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        192: // read eastron power
          f_modbus_read(1, address, 4, 12, 2);
          if modbus_status = 2 then
            // read OK
            power_meter_power[index] := int(f_read_float(0,1));
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        193: // read eastron energy
          f_modbus_read(1, address, 4, 72, 8);
          if modbus_status = 2 then
            // read OK
            power_meter_energy_imported[index] := f_read_float(0,1000);
            power_meter_energy_exported[index] := f_read_float(4,1000);
            power_meter_status[index] := 1; // ok
            modbus_step := 0;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
      
        194: // verify if iskra PM3
          f_modbus_read(1, address, 4, 1, 2);
          if modbus_status = 2 then
            // read OK
            if f_read_test(0,16#57,16#4D,16#33) then
              // ISKRA
              modbus_step := modbus_step + 1;
            else
              // EASTRON
              power_meter_status[index] := 2; // error
              modbus_step := 0; // next power meter
            end_if;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        195: // read iskra power
          f_modbus_read(1, address, 4, 140, 2);
          if modbus_status = 2 then
            // read OK
            power_meter_power[index] := int(f_read_t6(0));
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        196: // read iskra energy
          f_modbus_read(1, address, 4, 414, 24);
          if modbus_status = 2 then
            // read OK
            power_meter_energy_imported[index] := f_read_t3(40);
            exp := f_read_t2(0)-3;
            if exp > 1 then
              for i := 1 to exp do
                power_meter_energy_imported[index] := power_meter_energy_imported[index] * 10;
              end_for;
            elsif exp < 0 then
              for i := 1 to -exp do
                power_meter_energy_imported[index] := power_meter_energy_imported[index] / 10;
              end_for;
            elsif exp = 0 then
              power_meter_energy_imported[index] := 1;
            end_if;
            power_meter_energy_exported[index] := f_read_t3(44);
            exp := f_read_t2(2)-3;
            if exp > 1 then
              for i := 1 to exp do
                power_meter_energy_exported[index] := power_meter_energy_exported[index] * 10;
              end_for;
            elsif exp < 0 then
              for i := 1 to -exp do
                power_meter_energy_exported[index] := power_meter_energy_exported[index] / 10;
              end_for;
            elsif exp = 0 then
              power_meter_energy_exported[index] := 1;
            end_if;
            power_meter_status[index] := 1; // ok
            modbus_step := 0; // next power meter
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_status[index] := 2; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Address PM
      // ****************************************************************************
      
        200: // type??
          if power_meter_new_address < 149 or
             power_meter_new_address = 151 or
             power_meter_new_address = 152 or
             power_meter_new_address = 153 or
             power_meter_new_address = 159 or
             power_meter_new_address > 167
          then
            // wrong parameter
            power_meter_new_msg := 3;
            timeout := 2000;
            modbus_step := 205;
          else
            if power_meter_new_type = 1 then
              // eastron
              modbus_step := 201;
            elsif power_meter_new_type = 3 then
              // iskra
              modbus_step := 202;
            else
              // no new
              power_meter_new_msg := 1;
              timeout := 2000;
              modbus_step := 205;
            end_if;
          end_if;
      
        201 : // set eastron address
          f_modbus_write(1,power_meter_old_address,16,20,blong(breal(power_meter_new_address)));
          if modbus_status = 2 then
            // response OK
            power_meter_new_msg := 2;
            timeout := 2000;
            modbus_step := 205;
            pm_refresh_req := 1;
          elsif modbus_status >=3 then
            // no response
            power_meter_new_msg := 3;
            timeout := 2000;
            modbus_step := 205;
          end_if;
      
        202 : // set iskra address
          f_modbus_write(1,power_meter_old_address,6,202,power_meter_new_address);
          if modbus_status = 2 then
            // response OK
            timeout := 5000;
            modbus_step := modbus_step+1;
          elsif modbus_status >=3 then
            // no response
            power_meter_new_msg := 3;
            timeout := 2000;
            modbus_step := 205;
          end_if;
      
        203 : // wait -> save settings
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step+1;
          end_if;
      
        204 : // save iskra settings
          f_modbus_write(1,power_meter_new_address,6,12,1);
          if modbus_status = 2 then
            // response OK
            power_meter_new_msg := 2;
            timeout := 2000;
            modbus_step := 205;
            pm_refresh_req := 1;
          elsif modbus_status >=3 then
            // no response
            power_meter_new_msg := 3;
            timeout := 2000;
            modbus_step := 205;
          end_if;
      
        205 : // wait -> exit
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            power_meter_new_msg := 0;
            power_meter_new_address := 0;
            power_meter_old_address := 0;
            power_meter_new := 0;
            power_meter_new_type := 0;
            modbus_step := 0;
          end_if;
      
      // ****************************************************************************
      // Init NOK_GW
      // ****************************************************************************
      
        220: // request 4NOKS GW device type
          f_modbus_read(1,1,4,0,1);  // request device type
          if modbus_status = 2 then
            // response OK
            if f_read_int(0) = 112 then
              // device type OK
              nok_general_error := 0;
              modbus_step := modbus_step + 1; //
            else
              // wrong device type
              nok_general_error := 1;
              nok_network_status := 0; // no gw
              modbus_step := 0; // next device
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        221 : // request 4NOKS GW network state
          f_modbus_read(1,1,2,0,1);
          if modbus_status = 2 then
            // response OK
            if f_read_bit(0) then
              // device connected to network
              nok_network_status := 2; // normal (network closed)
              modbus_step := 225; // check network opened / closed
            else
              // disconnected
              nok_network_status := 1; // no network
              modbus_step := modbus_step + 1;
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        222 : // chose network
          f_modbus_write(1,1,6,0,8195);
          if modbus_status = 2 then
            // write OK
            nok_network_status := 6; // creating network
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        223 : // command request
          f_modbus_write(1,1,5,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 25000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        224 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := 221; // re-request network state
          end_if;
        225 : // check network opened / closed
          f_modbus_read(1,1,2,1,1);
          if modbus_status = 2 then
            // response OK
            if f_read_bit(0) then
              // network open
              nok_network_status := 3; // network open
              modbus_step := modbus_step + 1; // close network
            else
              // network close
              nok_network_status := 2; // normal (network closed)
              modbus_step := 229; // configure gw working mode
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        226 : // close network
          f_modbus_write(1,1,06,0,5267);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        227 : // command request
          f_modbus_write(1,1,05,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 2000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        228 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := 225; // re-check network opened / closed
          end_if;
        229 : // set GW working mode to 17 (to passthrough modbus)
          f_modbus_write(1,1,06,3,17);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        230 : // set min passthroug address
          f_modbus_write(1,1,06,11,149);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        231 : // set max passthroug address
          f_modbus_write(1,1,06,12,175);
          if modbus_status = 2 then
            // response OK
            modbus_step := 0;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // Rebuild NOK_GW
      // ****************************************************************************
      
        240: // Disassociates Gateway
          f_modbus_write(1,1,06,0,6515);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        241 : // command request
          f_modbus_write(1,1,05,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 7000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        242 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := 220; // INIT
          end_if;
      
      // ****************************************************************************
      // Clear NOK_D
      // ****************************************************************************
      
        260: // device present and OK? => Device disassociation
          if modbus_argument >=20 and modbus_argument <= 37 then
            // load manager device
            if load_manager_status[modbus_argument-20] = 1 then
              // device OK
              timeout := 2000;
              nok_network_status := 9; // device present
              modbus_step := 264; // wait -> exit
            elsif load_manager_status[modbus_argument-20] = 2 then
              // device error
              modbus_step := modbus_step + 1; // clear device slot
            else
              // slot empty
              timeout := 2000;
              nok_network_status := 11; // slot already empty
              modbus_step := 264; // wait -> exit
            end_if;
          elsif modbus_argument >=50 and modbus_argument <= 67 then
            // sensor device
            if sensor_status[modbus_argument-50] = 1 then
              // device OK
              timeout := 2000;
              nok_network_status := 9; // device present
              modbus_step := 264; // wait -> exit
            elsif sensor_status[modbus_argument-50] = 2 then
              // device error
              modbus_step := modbus_step + 1; // clear device slot
            else
              // slot empty
              timeout := 2000;
              nok_network_status := 11; // slot already empty
              modbus_step := 264; // wait -> exit
            end_if;
          elsif modbus_argument =127 then
            // new device
            if nok_new_device_status = 0 then
              // slot empty
              timeout := 2000;
              nok_network_status := 11; // slot already empty
              modbus_step := 264; // wait -> exit
            else
              // device present or error
              modbus_step := modbus_step + 1; // clear device slot
            end_if;
          else
            // bad argument
            timeout := 2000;
            nok_network_status := 10; // wrong argument
            modbus_step := 264; // wait -> exit
          end_if;
        261 : // claear agent slot
          f_modbus_write(1,1,06,0,12545);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        262 : // claear agent slot - index
          f_modbus_write(1,1,06,1,modbus_argument);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        263 : // command request
          f_modbus_write(1,1,05,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 2000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        264 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            nok_network_status := 2; // NORMAL - NETWORK ACTIVE
            modbus_step := 0;
          end_if;
      
      
      // ****************************************************************************
      // Add NOK_D
      // ****************************************************************************
      
        280: // verify argument
          if modbus_argument = 0 then
            // just open network
            nok_network_status := 3; // open network
            modbus_step := modbus_step + 1; // open network
          elsif modbus_argument >=20 and modbus_argument <= 37 then
            // load manager device
            if load_manager_status[modbus_argument-20] = 0 then
              // empty slot
              modbus_step := modbus_step + 1; // open network
            else
              // slot occupied
              timeout := 2000;
              nok_network_status := 15; // slot occupied
              modbus_step := 294; // wait -> close
            end_if;
          elsif modbus_argument >=50 and modbus_argument <= 67 then
            // sensor device
            if sensor_status[modbus_argument-50] = 0 then
              // empty slot
              modbus_step := modbus_step + 1; // open network
            else
              // slot occupied
              timeout := 2000;
              nok_network_status := 15; // slot occupied
              modbus_step := 294; // wait -> close
            end_if;
          else
            // bad argument
            timeout := 2000;
            nok_network_status := 17; // wrong address
            modbus_step := 294; // wait -> close
          end_if;
      
        281 : // open network
          f_modbus_write(1,1,06,0,5266);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        282 : // command request
          f_modbus_write(1,1,05,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 1000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        283 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step + 1;
          end_if;
          if modbus_command = 9 then
            modbus_command := 0;
            // close network
            nok_network_status := 5; // closing network
            modbus_step := 294;
          end_if;
        284 : // verify if opened
          f_modbus_read(1,1,2,1,1);
          if modbus_status = 2 then
            // response OK
            if f_read_bit(0) then
              // network open
              modbus_step := modbus_step + 1;
            else
              // network close
              modbus_step := 281; // re-open network
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        285 : // check for new device and verify type device
          if modbus_argument = 0 then
            // just leave network opened
            modbus_step := 293; // wait network close command
          elsif modbus_argument >=50 and modbus_argument <= 67 then
            // sensor device
            nok_network_status := 13; // waiting device
            modbus_step := 290; // verify device read from new address
          else
            // load manager device
            nok_network_status := 13; // waiting device
            f_modbus_read(1,127,4,0,1);
            if modbus_status = 2 then
              // response OK
              if modbus_argument >=20 and modbus_argument <= 37 then
                // load manager device
                if f_read_int(0)=38 or f_read_int(0)=39 or f_read_int(0)=42 then
                  // device type OK
                  nok_network_status := 14; // configuring device
                  modbus_step := modbus_step + 1;
                else
                  // wrong device type
                  timeout := 2000;
                  nok_network_status := 16; // wrong device type
                  modbus_step := 294; // wait -> close
                end_if;
              end_if;
            elsif modbus_status >=3 then
              // no response
              timeout := 100;
              modbus_step := 292; // wait -> recheck
            end_if;
          end_if;
        286 : // set device address
          f_modbus_write(1,127,6,2,modbus_argument);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            timeout := 2000;
            nok_network_status := 18; // addressing error
            modbus_step := 294; // wait -> close
          end_if;
        287 : // set device command new address
          f_modbus_write(1,127,6,0,6521);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            timeout := 2000;
            nok_network_status := 18; // addressing error
            modbus_step := 294; // wait -> close
          end_if;
        288 : // set command req
          f_modbus_write(1,127,5,0,1);
          if modbus_status = 2 then
            // response OK
            timeout := 1000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            timeout := 2000;
            nok_network_status := 18; // addressing error
            modbus_step := 294; // wait -> close
          end_if;
        289 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step + 1;
          end_if;
          if modbus_command = 9 then
            modbus_command := 0;
            // close network
            nok_network_status := 5; // closing network
            modbus_step := 294;
          end_if;
        290 : // verify device read from new address
          f_modbus_read(1,modbus_argument,4,0,1);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1; // set transmission time to 1
          elsif modbus_status >=3 then
            // no response
            timeout := 2000;
            modbus_step := 289; // pause -> re-verify device read from new address
          end_if;
        291 : // set transmission time to 1
          f_modbus_write(1,modbus_argument,6,1,1);
          if modbus_status = 2 then
            // response OK
            nok_network_status := 5; // closing network
            modbus_step := 294;
          elsif modbus_status >=3 then
            // no response
            timeout := 2000;
            nok_network_status := 18; // addressing error
            modbus_step := 294; // wait -> close
          end_if;
      
        292 : // wait -> recheck
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := 285; // re-check device
          end_if;
          if modbus_command = 9 then
            modbus_command := 0;
            // close network
            nok_network_status := 5; // closing network
            modbus_step := 294;
          end_if;
      
        293 : // wait -> recheck
          if modbus_command = 9 then
            modbus_command := 0;
            // close network
            nok_network_status := 5; // closing network
            modbus_step := 294;
          end_if;
      
        294 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step + 1;
          end_if;
        295 : // close network
          f_modbus_write(1,1,06,0,5267);
          if modbus_status = 2 then
            // response OK
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        296 : // command request
          f_modbus_write(1,1,05,0,1);
          if modbus_status = 2 then
            // write OK
            timeout := 1000;
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
        297 : // wait
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step + 1;
          end_if;
        298 : // check network opened / closed
          f_modbus_read(1,1,2,1,1);
          if modbus_status = 2 then
            // response OK
            if f_read_bit(0) then
              // network open
              modbus_step := 294; // re-close network
            else
              // network close
              nok_network_status := 2; // normal (network closed)
              modbus_step := 0; //
            end_if;
          elsif modbus_status >=3 then
            if modbus_retry_count = modbus_retry then
              // no response
              nok_general_error := 1;
              nok_network_status := 0; // no gw
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0;
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // timeout and retry
      // ****************************************************************************
      
        900: // next device
          timeout := 100;
          modbus_retry_count := modbus_retry_count + 1;
          modbus_step := modbus_step + 1;
      
        901: // wait and retry
          if (modbus_retry_count <= modbus_retry) then
            timeout := timeout - scan_time;
            if (timeout <= 0) then
              modbus_step := modbus_step_return;
            end_if;
          else
            modbus_step := modbus_step_next;
            modbus_retry_count := 0;
          end_if;
      
      end_case; // modbus_step
      
      
      // ****************************************************************************
      // On NOK_GW error clear all NOK devices
      // ****************************************************************************
      
      if nok_general_error then
        for i := 0 to 17 do
          // NOK_LM
          load_manager_status[i] := 0;
          load_manager_power[i] := 0;
          load_manager_signal[i] := 0;
          load_manager_set[i] := 0;
          // NOK_S
          sensor_status[i] := 0;
          sensor_humidity[i] := 0;
          sensor_ix00[i] := 0;
          sensor_ix01[i] := 0;
          sensor_temperature_1[i] := 0;
          sensor_temperature_2[i] := 0;
          sensor_signal[s_i] := 0;
          // NOK_R
          bridge_status[i] := 0;
          bridge_signal[i] := 0;
        end_for;
      end_if;
      
      //
      if modbus_status = 2 then
        modbus_retry_count := 0;
      end_if;
      
      for i := 0 to 17 do
        load_manager_set_timeout[i] := load_manager_set_timeout[i] - scan_time;
        if load_manager_set_timeout[i] < 0 then
          load_manager_set_timeout[i] := 0;
        end_if;
      end_for;
    end;
    function f_enocean:void; language 'Structured Text';
    begin
      eno_msg := 0; // idle
      
      for i := 10 to 17 do
        case eno_status[i] of
          1 : // OK
            if eno00_command = eno_mem_0[i] then
              load_set[i] := 0;
            elsif eno00_command = eno_mem_1[i] then
              load_set[i] := 1;
            end_if;
            if eno_mem_0[i] <> 0 and eno_mem_1[i] <> 0 then
              eno_status[i] := 1;
            else
              eno_status[i] := 0;
            end_if;
          2 : // wait 0
            eno_msg := 1; // press 0
            if eno00_command <> 0 then
              eno_mem_0[i] := eno00_command;
              eno_status[i] := 3;
            end_if;
          3 : // wait release 0
            eno_msg := 2; // release 0
            if eno00_command <> 0 then
              eno_status[i] := 4;
            end_if;
          4 : // wait 1
            eno_msg := 3; // press 1
            if eno00_command <> 0 then
              eno_mem_1[i] := eno00_command;
              eno_status[i] := 5;
            end_if;
          5 : // wait release 1
            eno_msg := 4; // release 1
            if eno00_command <> 0 then
              eno_status[i] := 1;
            end_if;
          6 : // cancel, del stored
            eno_msg := 0; // idle
            eno_mem_0[i] := 0;
            eno_mem_1[i] := 0;
            eno_status[i] := 0;
        end_case;
      
      end_for;
      
      eno00_command := 0;
    end;
    function f_read_source:void; language 'Structured Text';
    // AllocGroupList="source", "User Variables"
    var retain
      source_timeout: ARRAY[0..8] OF int; // {AllocGroup="source"}
    var_end;

    var
      d_e: long;
    var_end;

    begin
      
      // energy price
      buyout_energy_price := tariff_energy_price[tariff];
      current_energy_price := tariff_energy_price[tariff] * source_power[tariff]>0;
      
      power_meter_type[1] := 0;
      power_meter_type[2] := 0;
      power_meter_type[3] := 0;
      power_meter_type[9] := 0;
      
      // SOURCES
      
      for i := 0 to 8 do
      
        source_timeout[i] := source_timeout[i] - scan_time;
      
        case consumer_type[i] of
      
          1 : // 3 PH power meter
            power_meter_type[i] := 2;
            consumer_address[i] := 150+i;
            source_status[i] := 2 - (power_meter_status[i] = 1);
            consumer_status[i] := source_status[i];
            if power_meter_power[i] > 0 then
              source_power[i] := power_meter_power[i];
              consumer_power[i] := 0;
            else
              source_power[i] := 0;
              consumer_power[i] := -power_meter_power[i];
            end_if;
            source_energy_abs[i] := power_meter_energy_imported[i];
            consumer_energy_abs[i] := power_meter_energy_exported[i];
      
          2 : // 1 PH power meter
            power_meter_type[i] := 1;
            consumer_address[i] := 150+i;
            source_status[i] := 2 - (power_meter_status[i] = 1);
            consumer_status[i] := source_status[i];
            if power_meter_power[i] > 0 then
              source_power[i] := power_meter_power[i];
              consumer_power[i] := 0;
            else
              source_power[i] := 0;
              consumer_power[i] := -power_meter_power[i];
            end_if;
            source_energy_abs[i] := power_meter_energy_imported[i];
            consumer_energy_abs[i] := power_meter_energy_exported[i];
      
          3 : // eStore
            power_meter_type[i] := 0;
            if socket_id = 2 and socket_from = consumer_address[i] then
              source_timeout[i] := 10000;
              source_status[i] := 1;
              consumer_status[i] := 1;
              if i > 6 then
                // storage
                source_power[i] := estore_power_from_battery;
                source_energy_abs[i] := estore_energy_from_battery;
                consumer_power[i] := estore_power_to_battery;
                consumer_energy_abs[i] := estore_energy_to_battery;
                source_power_nominal[i] := estore_discharge_power;
                consumer_power_nominal[i] := -estore_charge_power;
                battery_soc[i-7] := estore_soc;
              elsif i > 3 then
                // plant
                source_power[i] := estore_power_production;
                source_energy_abs[i] := estore_energy_production;
                consumer_power[i] := 0;
                consumer_energy_abs[i] := 0;
              end_if;
            elsif source_timeout[i] <= 0 then
              source_status[i] := 2;
              consumer_status[i] := 2;
              source_power_nominal[i] := 0;
              consumer_power_nominal[i] := 0;
              source_power[i] := 0;
              consumer_power[i] := 0;
              source_timeout[i] := 0;
            end_if;
      
          4 : // HIQ Home power meter
            power_meter_type[i] := 0;
            if socket_id = 3 and socket_from = consumer_address[i] then
              source_status[i] := 1;
              consumer_status[i] := 1;
              source_timeout[i] := 10000;
              source_power[i] := hiq_home_pm_power;
              source_energy_abs[i] := hiq_home_pm_energy;
              consumer_power[i] := 0;
              consumer_energy_abs[i] := 0;
            elsif source_timeout[i] <= 0 then
              source_status[i] := 2;
              source_power[i] := 0;
              consumer_status[i] := 2;
              consumer_power[i] := 0;
              source_timeout[i] := 0;
            end_if;
      
        else
            power_meter_type[i] := 0;
            consumer_address[i] := 0;
            source_power[i] := 0;
            source_status[i] := 0;
            consumer_status[i] := 0;
            source_timeout[i] := 0;
      
        end_case;
      
        // grid power
        if i = 0 and tariff <> i then
          source_power[tariff] := source_power[i];
          source_power[i] := 0;
        end_if;
      
        // abs energies (direct from pm) to incremental
        // sources
        d_e := source_energy_abs[i] - source_energy_abs_old[i];
        if i = 0 then
          // grid energy -> depending on tariff
          if d_e > 0 and d_e < 1000 then
            source_energy[tariff] := source_energy[tariff] + d_e;
          end_if;
        else
          if d_e > 0 and d_e < 1000 then
            source_energy[i] := source_energy[i] + d_e;
          end_if;
        end_if;
        // consumers
        d_e := consumer_energy_abs[i] - consumer_energy_abs_old[i];
        if d_e > 0 and d_e < 1000 then
          consumer_energy[i] := consumer_energy[i] + d_e;
        end_if;
        source_energy_abs_old[i] := source_energy_abs[i];
        consumer_energy_abs_old[i] := consumer_energy_abs[i];
      
        // skip virtual sources
        if i = 0 then i := 3; end_if;
      
      end_for;
      
      source_status[1] := source_status[0];
      source_status[2] := source_status[0];
      source_status[3] := source_status[0];
      source_status[9] := 1;
      consumer_status[1] := consumer_status[0];
      consumer_status[2] := consumer_status[0];
      consumer_status[3] := consumer_status[0];
      consumer_status[9] := 1;
      
    end;
    function f_read_consumer:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var retain
      consumer_timeout: ARRAY[0..17] OF int;
    var_end;

    var
      d_e: long;
    var_end;

    begin
      
      for i := 10 to 17 do
      
        consumer_timeout[i] := consumer_timeout[i] - scan_time;
      
        case consumer_type[i] of
      
          1 : // 3 PH power meter
            power_meter_type[i] := 2;
            consumer_address[i] := 150+i;
            consumer_status[i] := 2 - (power_meter_status[i] = 1);
            consumer_power[i] := power_meter_power[i];
            consumer_energy_abs[i] := power_meter_energy_imported[i];
      
          2 : // 1 PH power meter
            power_meter_type[i] := 1;
            consumer_address[i] := 150+i;
            consumer_status[i] := 2 - (power_meter_status[i] = 1);
            consumer_power[i] := power_meter_power[i];
            consumer_energy_abs[i] := power_meter_energy_imported[i];
      
          4 : // HIQ Home power meter
            power_meter_type[i] := 0;
            if socket_id = 3 and socket_from = consumer_address[i] then
              consumer_status[i] := 1;
              consumer_timeout[i] := 10000;
              consumer_power[i] := 0;
              consumer_energy_abs[i] := 0;
            elsif consumer_timeout[i] <= 0 then
              consumer_status[i] := 2;
              consumer_power[i] := 0;
              consumer_timeout[i] := 0;
            end_if;
      
          5 : // HIQ Home out
            power_meter_type[i] := 0;
            if socket_id = 3 and socket_from = consumer_address[i] then
              consumer_status[i] := 1;
              consumer_timeout[i] := 10000;
              consumer_power[i] := hiq_home_out_power[consumer_index[i]];
              consumer_energy_abs[i] := hiq_home_out_energy[consumer_index[i]];
            elsif consumer_timeout[i] <= 0 then
              consumer_status[i] := 2;
              consumer_power[i] := 0;
              consumer_timeout[i] := 0;
            end_if;
      
          6 : // HIQ Home dim
            power_meter_type[i] := 0;
            if socket_id = 3 and socket_from = consumer_address[i] then
              consumer_status[i] := 1;
              consumer_timeout[i] := 10000;
              consumer_power[i] := hiq_home_dim_power[consumer_index[i]];
              consumer_energy_abs[i] := hiq_home_dim_energy[consumer_index[i]];
            elsif consumer_timeout[i] <= 0 then
              consumer_status[i] := 2;
              consumer_power[i] := 0;
              consumer_timeout[i] := 0;
            end_if;
      
          7 : // LM
            power_meter_type[i] := 0;
            consumer_address[i] := i;
            consumer_status[i] := 2 - (load_manager_status[i] = 1 or load_manager_status[i] = 3 or load_manager_status[i] = 4);
            consumer_power[i] := load_manager_power[i];
            consumer_energy_abs[i] := load_manager_energy[i];
      
        else
            power_meter_type[i] := 0;
            consumer_status[i] := 0;
            consumer_power[i] := 0;
      
        end_case;
      
        d_e := consumer_energy_abs[i] - consumer_energy_abs_old[i];
        if d_e > 0 and  d_e < 1000  then
          consumer_energy[i] := consumer_energy[i] + d_e;
        end_if;
        consumer_energy_abs_old[i] := consumer_energy_abs[i];
      
      end_for;
    end;
    function f_managed_load:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var retain
      load_set_old: ARRAY[0..17] OF bool;
      load_override_timer: ARRAY[0..17] OF long;
      load_old: ARRAY[0..17] OF bool;
      load_status_timeout: ARRAY[0..17] OF int;
    var_end;

      function min_max(val,v_min,v_max:int):int; language 'Structured Text';
      begin
        
        // function min_max(val, min, max:int):int;
        //
        // limit val to min - max
        
        if val > v_max then
          result := v_max;
        elsif val < v_min then
          result := v_min;
        else
          result := val;
        end_if;
      end;
    begin
      
      for i := 10 to 17 do
      
        // manual override
        if load_set[i] <> load_old[i] then
          load_override_timer[i] := long(load_override_preset[i]) * 1000 * 60;
          timetable_set[i] := load_set[i];
        end_if;
        load_override_timer[i] := load_override_timer[i] - scan_time;
        if load_override_timer[i] <= 0 then
          load_override_timer[i] := 0;
          load_set[i] := timetable_set[i];
        end_if;
        load_old[i] := load_set[i];
      
        // load status timeout
        load_status_timeout[i] := load_status_timeout[i] - scan_time;
        if load_status_timeout[i] < 0 then load_status_timeout[i] := 0; end_if;
      
        // inverted output
        if load_inverted[i] then
          load_out[i] := !load_set[i];
        else
          load_out[i] := load_set[i];
        end_if;
      
        case load_type[i] of
          0: // none
            load_status[i] := 0;
            load_address[i] := 0;
            load_index[i] := 0;
            load_set[i] := 0;
            load_set_old[i] := load_set[i];
            load_inverted[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          1: // HEMS DO
            load_status[i] := load_set[i]+3;
            load_address[i] := i-10;
            load_index[i] := 0;
            load_set_old[i] := load_set[i];
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          2: // HEMS LM
            if load_manager_status[i] = 1 then
              if load_set[i] <> load_set_old[i] then
                load_manager_set[i] := load_out[i];
              else
                load_out[i] := load_manager_set[i];
                if load_inverted[i] then
                  load_set[i] := !load_out[i];
                else
                  load_set[i] := load_out[i];
                end_if;
              end_if;
              load_status[i] := load_set[i]+3;
            else
              load_status[i] := 2;
            end_if;
            load_set_old[i] := load_set[i];
            load_address[i] := i-10;
            load_index[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          3: // HIQ DO
            load_index[i] := min_max(load_index[i],0,39);
            if load_set[i] <> load_set_old[i]  and !socket_request then
              // send to HIQ
              socket_request := 1;
              socket_from := int(get_nad());
              socket_to := load_address[i];
              socket_command := 2; // set output
              socket_argument_0 := load_index[i];
              socket_argument_1 := load_set[i];
              load_set_old[i] := load_set[i];
              hiq_home_out[load_index[i]] := load_set[i];
              load_status[i] := load_set[i]+3;
            elsif socket_id = 4 and socket_from = load_address[i] then
              load_set[i] := hiq_home_out[load_index[i]];
              load_set_old[i] := load_set[i];
              load_status[i] := load_set[i]+3;
              load_status_timeout[i] := 10000;
            elsif load_status_timeout[i] <= 0 then
              load_status[i] := 2;
              load_set[i] := 0;
            end_if;
            load_inverted[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          4: // HIQ dimm
            load_index[i] := min_max(load_index[i],0,15);
            if load_set[i] <> load_set_old[i]  and !socket_request then
              // send to HIQ
              socket_request := 1;
              socket_from := int(get_nad());
              socket_to := load_address[i];
              socket_command := 2; // set output
              socket_argument_0 := load_index[i] + 40;
              socket_argument_1 := load_set[i] * 100;
              load_set_old[i] := load_set[i];
              hiq_home_out[load_index[i] + 40] := load_set[i];
              load_status[i] := load_set[i]+3;
            elsif socket_id = 4 and socket_from = load_address[i] then
              load_set[i] := hiq_home_out[load_index[i] + 40];
              load_set_old[i] := load_set[i];
              load_status[i] := load_set[i]+3;
              load_status_timeout[i] := 10000;
            elsif load_status_timeout[i] <= 0 then
              load_status[i] := 2;
              load_set[i] := 0;
            end_if;
            load_inverted[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          5: // HIQ TH
            load_index[i] := min_max(load_index[i],0,4);
            if load_set[i] <> load_set_old[i]  and !socket_request then
              // send to HIQ
              socket_request := 1;
              socket_from := int(get_nad());
              socket_to := load_address[i];
              socket_command := 3; // set th
              socket_argument_0 := load_index[i];
              socket_argument_1 := load_set[i];
              load_set_old[i] := load_set[i];
              hiq_home_out[load_index[i]+56] := load_set[i];
              load_status[i] := load_set[i]+3;
            elsif socket_id = 4 and socket_from = load_address[i] then
              load_set[i] := hiq_home_out[load_index[i] + 56];
              load_set_old[i] := load_set[i];
              load_status[i] := load_set[i]+3;
              load_status_timeout[i] := 10000;
            elsif load_status_timeout[i] <= 0 then
              load_status[i] := 2;
              load_set[i] := 0;
            end_if;
            load_inverted[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          6: // HIQ scene
            load_index[i] := min_max(load_index[i],0,31);
            if load_set[i] <> load_set_old[i]  and !socket_request then
              // send to HIQ
              socket_request := 1;
              socket_from := int(get_nad());
              socket_to := load_address[i];
              socket_command := 4; // set scene
              socket_argument_0 := load_index[i];
              load_set_old[i] := load_set[i];
              hiq_home_out[load_index[i]+61] := load_set[i];
              load_status[i] := load_set[i]+3;
            elsif socket_id = 4 and socket_from = load_address[i] then
              load_set[i] := hiq_home_out[load_index[i] + 61];
              load_set_old[i] := load_set[i];
              load_status[i] := load_set[i]+3;
              load_status_timeout[i] := 10000;
            elsif load_status_timeout[i] <= 0 then
              load_status[i] := 2;
              load_set[i] := 0;
            end_if;
            load_inverted[i] := 0;
            timetable_cloud_analog[i] := 0;
            analog_out[i] := 0;
      
          7: // HEMS AO 0..10V
            load_status[i] := (analog_out[i] > 0) + 3;
            load_address[i] := i-10;
            load_index[i] := 0;
            load_set[i] := 0;
            load_set_old[i] := load_set[i];
      
          8: // HEMS DO + AO 0..10V
            load_status[i] := load_set[i]+3;
            load_address[i] := i-10;
            load_index[i] := 0;
            load_set_old[i] := load_set[i];
      
          9: // HEMS AO PWM
            load_status[i] := (analog_out[i] > 0) + 3;
            load_address[i] := i-10;
            load_index[i] := 0;
            load_set[i] := 0;
            load_set_old[i] := load_set[i];
      
          10: // HEMS DO + PWM
            load_status[i] := load_set[i]+3;
            load_address[i] := i-10;
            load_index[i] := 0;
            load_set_old[i] := load_set[i];
      
        end_case;
      
      end_for;
      
      
      
    end;
    function f_partials:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      c_i: int;
      s_i: int;
      t_i: int;
    var_end;

    var retain
      consumer_partial_energy_mwh: ARRAY[0..179] OF long;
      consumer_energy_old: ARRAY[0..17] OF long;
    var_end;

    var
      d_energy: long;
      balance_energy: long;
    var_end;

      function round(val:real):long; language 'Structured Text';
      begin
        
        // function round(val:real):int;
        //
        // rounds val(real) to integer
        
        
        if (val-int(val)) >= 0.5 then
          result := long(val)+1;
        else
          result := long(val);
        end_if;
      end;
    begin
      // ****************************************************************************
      // reset all energies
      // ****************************************************************************
      
      if energy_reset_req then
        // sources
        for i := 0 to 9 do
          source_energy[i] := 0;
        end_for;
        for i := 0 to 17 do
          consumer_energy[i] := 0;
        end_for;
        for i := 0 to 179 do
          consumer_partial_energy[i] := 0;
          consumer_partial_energy_mwh[i] := 0;
        end_for;
        energy_reset_year := rtc_year;
        energy_reset_month := rtc_month;
        energy_reset_date := rtc_date;
        energy_reset_weekday := rtc_weekday;
        energy_reset_hour := rtc_hour;
        energy_reset_min := rtc_min;
        energy_reset_sec := rtc_sec;
      end_if;
      energy_reset_req := 0;
      
      // ****************************************************************************
      // power totals
      // ****************************************************************************
      
      total_source_power[0] := 0;
      total_source_power[1] := 0;
      total_source_power[2] := 0;
      total_source_power[3] := 0;
      total_consumer_power[0] := 0;
      total_consumer_power[1] := 0;
      total_consumer_power[2] := 0;
      total_consumer_power[3] := 0;
      total_consumer_power[4] := 0;
      for i := 0 to 3 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[1] := total_source_power[1] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[1] := total_consumer_power[1] + consumer_power[i];
      end_for;
      for i := 4 to 6 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[2] := total_source_power[2] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[2] := total_consumer_power[2] + consumer_power[i];
      end_for;
      for i := 7 to 8 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[3] := total_source_power[3] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[3] := total_consumer_power[3] + consumer_power[i];
      end_for;
      for i := 10 to 17 do
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[4] := total_consumer_power[4] + consumer_power[i];
      end_for;
      
      // unknown source / unmanaged consumers power calculation
      
      if total_consumer_power[0] > total_source_power[0] then
        source_power[9] := total_consumer_power[0] - total_source_power[0];
        total_source_power[0] := total_source_power[0] + source_power[9];
        consumer_power[9] := 0;
      elsif total_consumer_power[0] < total_source_power[0] then
        source_power[9] := 0;
        consumer_power[9] := total_source_power[0] - total_consumer_power[0];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[9];
      else
        source_power[9] := 0;
        consumer_power[9] := 0;
      end_if;
      
      // ****************************************************************************
      // divide
      // ****************************************************************************
      
      // divide power
      for c_i := 0 to 17 do
        for s_i := 0 to 9 do
          consumer_partial_power[c_i*10+s_i] := round(real(source_power[s_i]) * consumer_power[c_i] / total_source_power[0]);
        end_for;
      end_for;
      
      // divide energy
      for c_i := 0 to 17 do
        if c_i <> 9 then // skip unmanaged
          d_energy := consumer_energy[c_i] - consumer_energy_old[c_i];
          consumer_energy_old[c_i] := consumer_energy[c_i];
          if d_energy > 0 and d_energy <= 1000 then // normal delta => divide per power
            // divide
            for s_i := 0 to 9 do
              consumer_partial_energy_mwh[c_i*10+s_i] := consumer_partial_energy_mwh[c_i*10+s_i] + long(real(d_energy)*1000/consumer_power[c_i]*consumer_partial_power[c_i*10+s_i]);
              consumer_partial_energy[c_i*10+s_i] := consumer_partial_energy[c_i*10+s_i] + (consumer_partial_energy_mwh[c_i*10+s_i] / 1000);
              consumer_partial_energy_mwh[c_i*10+s_i] := consumer_partial_energy_mwh[c_i*10+s_i] % 1000;
            end_for;
          end_if;
        end_if;
      end_for;
      
      // ****************************************************************************
      // calculated energy
      // ****************************************************************************
      
      // unmanaged partials
      for s_i := 0 to 8 do
        consumer_partial_energy[90+s_i] := source_energy[s_i];
        for c_i := 0 to 17 do
          if c_i <> 9 then
            consumer_partial_energy[90+s_i] := consumer_partial_energy[90+s_i] - consumer_partial_energy[10*c_i+s_i];
          end_if;
        end_for;
      end_for;
      // total unmanaged
      consumer_energy[9] := 0;
      for s_i := 0 to 9 do
        consumer_energy[9] := consumer_energy[9] + consumer_partial_energy[90+s_i];
      end_for;
      
      // total unknown energy
      source_energy[9] := 0;
      for c_i := 0 to 17 do
        consumer_partial_energy[c_i*10+9] := consumer_energy[c_i];
        for s_i := 0 to 8 do
          consumer_partial_energy[c_i*10+9] := consumer_partial_energy[c_i*10+9] - consumer_partial_energy[c_i*10+s_i];
        end_for;
        source_energy[9] := source_energy[9] + consumer_partial_energy[c_i*10+9];
      end_for;
      
      
      // ****************************************************************************
      // energy totals
      // ****************************************************************************
      
      // total sources
      total_source_energy[0] := 0;
      total_source_energy[1] := 0;
      total_source_energy[2] := 0;
      total_source_energy[3] := 0;
      total_consumer_energy[0] := 0;
      total_consumer_energy[1] := 0;
      total_consumer_energy[2] := 0;
      total_consumer_energy[3] := 0;
      total_consumer_energy[4] := 0;
      for i := 0 to 3 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[1] := total_source_energy[1] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[1] := total_consumer_energy[1] + consumer_energy[i];
      end_for;
      for i := 4 to 6 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[2] := total_source_energy[2] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[2] := total_consumer_energy[2] + consumer_energy[i];
      end_for;
      for i := 7 to 8 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[3] := total_source_energy[3] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[3] := total_consumer_energy[3] + consumer_energy[i];
      end_for;
      for i := 9 to 17 do
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[4] := total_consumer_energy[4] + consumer_energy[i];
      end_for;
      total_source_energy[0] := total_source_energy[0] + source_energy[9];
      total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[9];
      
      // ****************************************************************************
      // partial energy totals
      // ****************************************************************************
      
      // production -> grid
      t_i := 0;
      total_energy[t_i] := 0;
      for c_i := 0 to 0 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // storage -> grid
      t_i := 1;
      total_energy[t_i] := 0;
      for c_i := 0 to 0 do
        for s_i := 7 to 8 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // grid -> storage
      t_i := 2;
      total_energy[t_i] := 0;
      for c_i := 7 to 8 do
        for s_i := 0 to 3 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // production -> storage
      t_i := 3;
      total_energy[t_i] := 0;
      for c_i := 7 to 8 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // storage -> consumption
      t_i := 4;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 7 to 8 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // grid -> consumption
      t_i := 5;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 0 to 3 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // production -> consumption
      t_i := 6;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      
      
    end;
    function f_timetable:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      i0: int;
      i1: int;
      tt_s_h: int;
      tt_s_m: int;
      tt_s_w: int;
      tt_i: int;
      tt_s: int;
      cmd_i: int;
      load_type_old: ARRAY[0..17] OF int;
    var_end;

    var retain
      i0_old: int;
      timetable_battery_default_old: int;
    var_end;

    var
      set_value: bool;
      set_mask: int;
    var_end;

      function min_max(val,v_min,v_max:int):int; language 'Structured Text';
      begin
        
        // function min_max(val, min, max:int):int;
        //
        // limit val to min - max
        
        if val > v_max then
          result := v_max;
        elsif val < v_min then
          result := v_min;
        else
          result := val;
        end_if;
      end;
    begin
      
      i0:=96*((rtc_weekday+6)%7)+4*rtc_hour+(rtc_min/15); // current timetable index
      i1 := i0-1;
      if i1 < 0 then i1 := 671; end_if;
      
      //*****************************************************************************
      // managed load timetables
      //*****************************************************************************
      
      for i := 0 to 7 do
      
        if i0 <> i0_old and timetable_enable[i] then
      
          // delete previous once
          timetable[i*672+i1] := timetable[i*672+i1] and 2#0011;
      
          if (timetable[i*672+i0] and 2#1100) = 2#0100 then
            // OFF
            timetable_set[i+10] := 0;
          elsif (timetable[i*672+i0] and 2#1100) = 2#1000 then
            // ON
            timetable_set[i+10] := 1;
          elsif (timetable[i*672+i0] and 2#1100) = 0 then
            // no once action => accept recurring actions
            if (timetable[i*672+i0] and 2#0011) = 2#0001 then
              // OFF
              timetable_set[i+10] := 0;
            elsif (timetable[i*672+i0] and 2#0011) = 2#0010 then
              // ON
              timetable_set[i+10] := 1;
            end_if;
          end_if;
      
          // analog timetable
          if timetable_analog[i*672+i0] <> -1 then
            analog_out[i] := timetable_analog[i*672+i0];
          end_if;
      
        end_if;
      
        // disable analog
        if load_type[10+i] < 7 or load_type[10+i] > 10 then
          analog_out[i] := 0;
          timetable_cloud_analog[i] := 0;
        end_if;
      
      end_for;
      
      //*****************************************************************************
      // tariff timetable
      //*****************************************************************************
      
      tariff := timetable_tariff[i0];
      
      if i0 <> i0_old then
         // clear previous critical peak
        timetable_tariff[i1] := timetable_tariff[i1] and 2#01;
      end_if;
      
      //*****************************************************************************
      // battery timetable
      //*****************************************************************************
      
      estore_setpoint := timetable_battery[i0];
      
      if i0 <> i0_old then
        // clear previous battery
        if timetable_battery_default=0 then
          timetable_battery[i1] := 0;
        else
          timetable_battery[i1] := -32768;
        end_if;
      end_if;
      
      i0_old := i0;
      
      // ****************************************************************************
      // edit managed load timetables
      // ****************************************************************************
      
      if timetable_e_cmd > 0 then
        for i := 0 to 671 do
          if timetable_e[i] then
            case timetable_e_cmd of
              1  : // once off
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;   // clear once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0100;   // set once off
              2  : // once on
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;   // clear once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#1000;   // set once on
              3  : // once disable
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#1100;   // set once disable
              4  : // delete once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;  // clear once
              5  : // recurring off
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0001;   // set recurring off
              6  : // recurring on
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0010;   // set recurring on
              7 : // delete recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
            end_case;
            timetable_e[i] := 0;
          end_if;
        end_for;
        timetable_e_cmd := 0;
      end_if;
      
      //*****************************************************************************
      // edit tariff timetable
      //*****************************************************************************
      
      case tariff_cmd of
        1 : // set LO
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := 0;
              timetable_e[i] := 0;
            end_if;
          end_for;
        2 : // set HI
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := 1;
              timetable_e[i] := 0;
            end_if;
          end_for;
        3 : // set CP
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := timetable_tariff[i] + 2;
              timetable_e[i] := 0;
            end_if;
          end_for;
        4 : // delete CP
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := timetable_tariff[i] and 2#01;
              timetable_e[i] := 0;
            end_if;
          end_for;
      end_case;
      tariff_cmd := 0;
      
      //*****************************************************************************
      // edit analog timetable
      //*****************************************************************************
      
      for i := 0 to 3 do
        // when disabling analog clear all
        if load_type[10+i] < 7 and load_type_old[10+i] >= 7
        then
          timetable_analog_cmd[i] := 2;
        end_if;
        load_type_old[10+i] := load_type[10+i];
      
        if timetable_analog_cmd[i] > 0 then
          for j := 0 to 671 do
            // write selected
            if timetable_e[j] and timetable_analog_cmd[i] = 1 then
              timetable_analog[i * 672 + j] := timetable_analog_val;
              timetable_e[j] := 0;
            elsif timetable_analog_cmd[i] = 2 then // claear all
              timetable_analog[i * 672 + j] := -1;
            end_if;
          end_for;
          timetable_analog_val := 0;
          timetable_analog_cmd[i] := 0;
        end_if;
      end_for;
      
      //*****************************************************************************
      // edit battery timetable
      //*****************************************************************************
      
      if timetable_battery_cmd then
        for i := 0 to 671 do
          if timetable_battery_val = 32767 then
            // clear all
            timetable_battery[i] := timetable_battery_default*(-32768);
            timetable_e[i] := 0;
          else
            // write selected
            if timetable_e[i] then
              timetable_battery[i] := timetable_battery_val;
              timetable_e[i] := 0;
            end_if;
          end_if;
        end_for;
        timetable_battery_val := 0;
        timetable_battery_cmd := 0;
      end_if;
      
      if timetable_battery_default <> timetable_battery_default_old then
        for i := 0 to 671 do
          if timetable_battery_default=1 then
            if timetable_battery[i] = 0 then
              timetable_battery[i] := -32768;
            end_if;
          else
            if timetable_battery[i] = -32768 then
              timetable_battery[i] := 0;
            end_if;
          end_if;
        end_for;
      end_if;
      timetable_battery_default_old := timetable_battery_default;
      
      //*****************************************************************************
      // cloud edit timetables
      //*****************************************************************************
      
      for cmd_i := 0 to 50 do
      
        if optimization_command[cmd_i] > 0 then
      
          tt_s_h := optimization_start[cmd_i] / 1000;
          tt_s_h := min_max(tt_s_h, 0, 23);
          tt_s_m := (optimization_start[cmd_i] % 1000) / 10;
          tt_s_m := min_max(tt_s_m, 0, 59);
          tt_s_w := optimization_start[cmd_i] % 10;
          tt_s_w := min_max(tt_s_w, 1, 7);
          optimization_time[cmd_i] := min_max(optimization_time[cmd_i], 0, 600);
          if optimization_index[cmd_i] = 0 then
            for tt_i := 0 to 7 do
              tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
              case optimization_command[cmd_i] of
                1 : // set once
                  if timetable_cloud_once[tt_i] then
                    case optimization_value[cmd_i] of
                     -1 : // clear once
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      0 : // set once off
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                      1 : // set once on
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                    end_case;
                    if optimization_time[cmd_i] > 15 then
                      for i := 1 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(tt_i)*672+(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        if optimization_value[cmd_i] = -1 then
                          timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        elsif optimization_value[cmd_i] = 0 or optimization_value[cmd_i] = 1 then
                          timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                        end_if;
                      end_for;
                    end_if;
                  end_if;
                2 : // set recurring
                  if timetable_cloud_recurring[tt_i] then
                    case optimization_value[cmd_i] of
                     -1 : // clear recurring
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                      0 : // set recurring off
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                        timetable[tt_s] := timetable[tt_s] or  2#0001; // set recurring off
                      1 : // set recurring on
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                        timetable[tt_s] := timetable[tt_s] or  2#0010; // set recurring on
                    end_case;
                  end_if;
                3 : // set tariff
                  if optimization_time[cmd_i] > 0 then
                    for i := 0 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                      if optimization_value[cmd_i] = 0 then
                          timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#10; // set lo
                      elsif optimization_value[cmd_i] = 1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#01; // set hi
                      elsif optimization_value[cmd_i] = 2 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#10; // set critical peak
                      elsif optimization_value[cmd_i] = -1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#01; // delete critical peak
                      end_if;
                    end_for;
                  end_if;
                4: // set mask
                  if timetable_cloud_once[tt_i] and optimization_time[cmd_i] >= 15 then
                    set_mask := optimization_value[cmd_i];
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
                    set_value := (set_mask and 1) > 0;
                    timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                    if set_value then
                      timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                    else
                      timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                    end_if;
                    for i := 1 to (set_mask/15) do
                      set_mask := set_mask shr 1;
                      tt_s := (tt_s + 1)%672;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if set_value <> bit(set_mask and 1) then
                        set_value := (set_mask and 1) > 0;
                        if set_value then
                          timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                        else
                          timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                        end_if;
                      else
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
              5: // set analog
                if timetable_cloud_analog[tt_i] then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                    optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-1,100);
                    timetable_analog[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
              6: // set setpoint
                if optimization_time[cmd_i] > 0 then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                    if optimization_value[cmd_i] <> -31768 then
                      optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-100,100);
                    end_if;
                    timetable_battery[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
              end_case;
            end_for;
          elsif optimization_index[cmd_i] > 0 and optimization_index[cmd_i] <= 8 then
            tt_i := optimization_index[cmd_i]-1;
            tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
            case optimization_command[cmd_i] of
              1 : // set once
                if timetable_cloud_once[tt_i] then
                  case optimization_value[cmd_i] of
                   -1 : // clear once
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                    0 : // set once off
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                    1 : // set once on
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                  end_case;
                  if optimization_time[cmd_i] > 15 then
                    for i := 1 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(tt_i)*672+(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if optimization_value[cmd_i] = -1 then
                          timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      elsif optimization_value[cmd_i] = 0 or optimization_value[cmd_i] = 1 then
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
                end_if;
              2 : // set recurring
                if timetable_cloud_recurring[tt_i] then
                  case optimization_value[cmd_i] of
                   -1 : // clear recurring
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                    0 : // set recurring off
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                      timetable[tt_s] := timetable[tt_s] or  2#0001; // set recurring off
                    1 : // set recurring on
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                      timetable[tt_s] := timetable[tt_s] or  2#0010; // set recurring on
                  end_case;
                end_if;
              3 : // set tariff
                  if optimization_time[cmd_i] > 0 then
                    for i := 0 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                      if optimization_value[cmd_i] = 0 then
                          timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#10; // set lo
                      elsif optimization_value[cmd_i] = 1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#01; // set hi
                      elsif optimization_value[cmd_i] = 2 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#10; // set critical peak
                      elsif optimization_value[cmd_i] = -1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#01; // delete critical peak
                      end_if;
                    end_for;
                  end_if;
              4: // set mask
                if timetable_cloud_once[tt_i] and optimization_time[cmd_i] >= 15 then
                  set_mask := optimization_value[cmd_i];
                  tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
                  set_value := (set_mask and 1) > 0;
                  timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                  if set_value then
                    timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                  else
                    timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                  end_if;
                  if optimization_time[cmd_i] >= 30 then
                    for i := 1 to (optimization_time[cmd_i]/15)-1 do
                      set_mask := set_mask shr 1;
                      tt_s := (tt_s + 1);
                      if tt_s > (tt_i)*672+671 then
                        tt_s := tt_i*672;
                      end_if;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if set_value <> bit(set_mask and 1) then
                        set_value := (set_mask and 1) > 0;
                        if set_value then
                          timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                        else
                          timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                        end_if;
                      else
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
                end_if;
              5: // set analog
                if timetable_cloud_analog[tt_i] then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                    optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-1,100);
                    timetable_analog[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
              6: // set setpoint
                if optimization_time[cmd_i] > 0 then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                    if optimization_value[cmd_i] <> -31768 then
                      optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-100,100);
                    end_if;
                    timetable_battery[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
            end_case;
          end_if;
        end_if;
      
        optimization_command[cmd_i] := 0;
      
      end_for;
      
    end;
    function f_forecast:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      i0: int;
      i1: int;
    var_end;

    var
      state: bool;
      cmd: int;
    var_end;

    begin
      
      for i := 0 to 7 do
        // b0 = actual value
        state := load_set[10+i];
        forecast_state[i] := state;
      
        // go through timetable and ...
        i0:=96*((rtc_weekday+6)%7)+4*rtc_hour+(rtc_min/15); // current timetable index
      
        for j := 1 to 15 do
          // new now
          i0 := i0+1;
          if i0 > 671 then i0 := 0; end_if;
      
          if timetable_enable[i] then
            if (timetable[i*672+i0] and 2#1100) = 2#0100 then
              // OFF
              state := 0;
            elsif (timetable[i*672+i0] and 2#1100) = 2#1000 then
              // ON
              state := 1;
            elsif (timetable[i*672+i0] and 2#1100) = 0 then
              // no once action => accept recurring actions
              if (timetable[i*672+i0] and 2#0011) = 2#0001 then
                // OFF
                state := 0;
              elsif (timetable[i*672+i0] and 2#0011) = 2#0010 then
                // ON
                state := 1;
              end_if;
            end_if;
          end_if;
      
          forecast_state[i] := forecast_state[i] or (int(state) shl j);
      
        end_for;
      
      end_for;
    end;
    function f_battery:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      battery_send_req: ARRAY[0..1] OF bool;
      i0: int;
    var_end;

    begin
      
      if fp(clock_1min) then
        battery_send_req[0] := 1;
        battery_send_req[1] := 1;
      end_if;
      
      for i := 0 to 1 do
        if battery_send_req[i] and !socket_request then
          if consumer_type[i+7] = 3 then // is eStore
            socket_request := 1;
            socket_from := int(get_nad());
            socket_to := consumer_address[i+7];
            socket_command := 5; // set setpoint
            if estore_setpoint = -32768 then
              socket_argument_0 := 0;                                // remote controll enable
            else
              socket_argument_0 := 1;                                // remote controll enable
              socket_argument_1 := 0;                                // maximizing selfconsumption enabled
              socket_argument_2 := estore_setpoint;                  // remote setpoint
            end_if;
          end_if;
          battery_send_req[i] := 0;
        end_if;
      end_for;
      
      // Forecast
      
      i0:=96*((rtc_weekday+6)%7)+4*rtc_hour+(rtc_min/15); // current timetable index
      
      battery_forecast[0] := estore_setpoint;
      
      for i := 1 to 16 do
        // next period
        i0 := i0+1;
        if i0 > 671 then i0 := 0; end_if;
        battery_forecast[i] := timetable_battery[i0];
      end_for;
    end;
  begin
    
    f_modbus();
    
    f_enocean();
    
    f_read_source();
    
    f_read_consumer();
    
    f_managed_load();
    
    for i := 0 to 9 do
      device_enabled[i] := (source_status[i] + consumer_status[i] + load_status[i]) > 0;
    end_for;
    for i := 10 to 17 do
      device_enabled[i] := (consumer_status[i] + load_status[i]) > 0;
    end_for;
    
    f_partials();
    
    f_timetable();
    
    f_forecast();
    
    f_battery();
    
    
  end;
  function f_clear_socket_variables:void; language 'Structured Text';
  begin
    
    // eStore
    
    if socket_id = 2 then
      socket_id := 0;
    end_if;
    
    // HIQ Home power
    if socket_id = 3 then
      socket_id := 0;
    end_if;
    
    
  end;
begin
  
  // ****************************************************************************
  // Application ID
  // yypppnnn => yy  2 digits year
  //             ppp 3 digits project number
  //             nnn 3 digits application SN within project
  //                yypppnnn
  application_id := 16040001;
  // Version number
  version_major   := 1; // major changes: added functionality, changed main HW components, ...
  version_minor   := 0; // cosmetic changes: added variables, updated functionalities, ...
  version_release := 0; // bug & issues fixes, ...
  // Version state
  // 0=alfa, 1=beta, 2=release candidate, 3=release
  version_state   := 2;
  // CyBro kernel version
  kernel_major   := 3;
  kernel_minor   := 0;
  kernel_release := 2;
  
  // ****************************************************************************
  
  if !ee_read_req then
  
    f_parameters();
  
    f_system();
  
    f_io_mux();
  
    if parameters_ok then
  
      f_algorithms();
  
    else
  
      // all off!
      for i := 0 to 17 do
        load_out[i] := 0;
        analog_out[i] := 0;
      end_for;
  
    end_if;
  
    f_clear_socket_variables();
  
  end_if;
end;
#CODE_END

#DESCRIPTION_BEGIN
  103 : // read nok sensor devices data valid
    f_modbus_read(1,1,2,162,14);
    if modbus_status = 2 then
      // response OK
      for i := 0 to 13 do
        nok_data_valid[i] := f_read_bit(i);
      end_for;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  104: // read nok load manager devices presence
    f_modbus_read(1,1,2,50,14);
    if modbus_status = 2 then
      // response OK
      for i := 0 to 13 do
        if f_read_bit(i) <> nok_data_valid[i] then
          sensor_status[i] := 2; // error
        else
          sensor_status[i] := nok_data_valid[i];
        end_if;
      end_for;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  105: // read new device data valid
    f_modbus_read(1,1,2,239,1);
    if modbus_status = 2 then
      // response OK
      nok_nd_valid := f_read_bit(0);
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  106: // read new device presence
    f_modbus_read(1,1,2,239,1);
    if modbus_status = 2 then
      // response OK
      if nok_nd_valid <> f_read_bit(0) then
        nok_new_device_status := 2; // error
      else
        nok_new_device_status := nok_nd_valid;
      end_if;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  107: // clear new device slot if occupied
    if nok_new_device_status <> 0 then
      nok00_argument := 127;
      nok00_command := 4;
      modbus_step := 100;
    else
      modbus_step := modbus_step + 1;
    end_if;

  108:
    modbus_step := 200;
#DESCRIPTION_END

##PROGRAM_END_1

