##PROJECT_GLOBAL_BEGIN
[Programs]
Count=1

[Misc Info]
Author=
Company=
Version=1.0
EditTime=32992
CyProVersion=3.0.3

[Protection]
Level=0
Password=
##PROJECT_GLOBAL_END

##PROGRAM_BEGIN_1
#PROJECT_OPTIONS_BEGIN
[Program]
Name=HEMS G2

[VCP]
I2CPriority=5
SendSource=1
SendAlloc=1
ProtectWithPasswd=0
Password=
ScanOverrunStopsProgram=1
OutputRetentive=0
AutoStart=1
Com1Mode=3
Com1Baudrate=2
Com1Data=1
Com2Mode=1
Com2Baudrate=3
Com2Data=0
EthAbusEnable=1
EthModbusEnable=0
WANUrl=
PushEvent=0
PushUrl=89.212.244.21
ModbusDelay=20
ModbusDeviceAddress=1
ModbusPLCDataModel=2
ModbusAddress=0
ModbusRegisterCount=1
ModbusCoilsArrayVar=
ModbusRegistersArrayVar=
PLCCoilVars=
PLCRegisterVars=
ModbusCoilAddresses=
ModbusRegisterAddresses=

[Misc Info]
MonitorHistorySpeed=10

[Hardware]
CPUUnit=11
VarAreaTyp0.7.0=0
VarAreaTyp0.7.1=0
VarAreaTyp0.7.2=0
VarAreaTyp0.7.3=0
VarAreaTyp0.7.4=0
VarAreaTyp0.7.5=0

[Socket00]
ID=1
SocketType=4
Descr=IQ-to-IQ sync
Var00=socket_request
Var01=socket_from
Var02=socket_to
Var03=socket_command
Var04=socket_argument_0
Var05=socket_argument_1
Var06=socket_argument_2
Var07=socket_argument_3

[Socket01]
ID=2
SocketType=0
Descr=Power and energy values from eStore machine
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=estore_soc
Var04=estore_power_to_grid
Var05=estore_power_from_grid
Var06=estore_power_production
Var07=estore_power_to_battery
Var08=estore_power_from_battery
Var09=estore_power_consumption
Var10=estore_energy_to_grid
Var11=estore_energy_from_grid
Var12=estore_energy_production
Var13=estore_energy_to_battery
Var14=estore_energy_from_battery
Var15=estore_energy_consumption
Var16=estore_charge_power
Var17=estore_discharge_power

[Socket02]
ID=3
SocketType=0
Descr=HIQ Home
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=hiq_home_pm_power
Var04=hiq_home_out_power[0]
Var05=hiq_home_out_power[1]
Var06=hiq_home_out_power[2]
Var07=hiq_home_out_power[3]
Var08=hiq_home_out_power[4]
Var09=hiq_home_out_power[5]
Var10=hiq_home_out_power[6]
Var11=hiq_home_out_power[7]
Var12=hiq_home_out_power[8]
Var13=hiq_home_out_power[9]
Var14=hiq_home_out_power[10]
Var15=hiq_home_out_power[11]
Var16=hiq_home_out_power[12]
Var17=hiq_home_out_power[13]
Var18=hiq_home_out_power[14]
Var19=hiq_home_out_power[15]
Var20=hiq_home_out_power[16]
Var21=hiq_home_out_power[17]
Var22=hiq_home_out_power[18]
Var23=hiq_home_out_power[19]
Var24=hiq_home_out_power[20]
Var25=hiq_home_out_power[21]
Var26=hiq_home_out_power[22]
Var27=hiq_home_out_power[23]
Var28=hiq_home_out_power[24]
Var29=hiq_home_out_power[25]
Var30=hiq_home_out_power[26]
Var31=hiq_home_out_power[27]
Var32=hiq_home_out_power[28]
Var33=hiq_home_out_power[29]
Var34=hiq_home_out_power[30]
Var35=hiq_home_out_power[31]
Var36=hiq_home_out_power[32]
Var37=hiq_home_out_power[33]
Var38=hiq_home_out_power[34]
Var39=hiq_home_out_power[35]
Var40=hiq_home_out_power[36]
Var41=hiq_home_out_power[37]
Var42=hiq_home_out_power[38]
Var43=hiq_home_out_power[39]
Var44=hiq_home_dim_power[0]
Var45=hiq_home_dim_power[1]
Var46=hiq_home_dim_power[2]
Var47=hiq_home_dim_power[3]
Var48=hiq_home_dim_power[4]
Var49=hiq_home_dim_power[5]
Var50=hiq_home_dim_power[6]
Var51=hiq_home_dim_power[7]
Var52=hiq_home_dim_power[8]
Var53=hiq_home_dim_power[9]
Var54=hiq_home_dim_power[10]
Var55=hiq_home_dim_power[11]
Var56=hiq_home_dim_power[12]
Var57=hiq_home_dim_power[13]
Var58=hiq_home_dim_power[14]
Var59=hiq_home_dim_power[15]
Var60=hiq_home_pm_energy
Var61=hiq_home_out_energy[0]
Var62=hiq_home_out_energy[1]
Var63=hiq_home_out_energy[2]
Var64=hiq_home_out_energy[3]
Var65=hiq_home_out_energy[4]
Var66=hiq_home_out_energy[5]
Var67=hiq_home_out_energy[6]
Var68=hiq_home_out_energy[7]
Var69=hiq_home_out_energy[8]
Var70=hiq_home_out_energy[9]
Var71=hiq_home_out_energy[10]
Var72=hiq_home_out_energy[11]
Var73=hiq_home_out_energy[12]
Var74=hiq_home_out_energy[13]
Var75=hiq_home_out_energy[14]
Var76=hiq_home_out_energy[15]
Var77=hiq_home_out_energy[16]
Var78=hiq_home_out_energy[17]
Var79=hiq_home_out_energy[18]
Var80=hiq_home_out_energy[19]
Var81=hiq_home_out_energy[20]
Var82=hiq_home_out_energy[21]
Var83=hiq_home_out_energy[22]
Var84=hiq_home_out_energy[23]
Var85=hiq_home_out_energy[24]
Var86=hiq_home_out_energy[25]
Var87=hiq_home_out_energy[26]
Var88=hiq_home_out_energy[27]
Var89=hiq_home_out_energy[28]
Var90=hiq_home_out_energy[29]
Var91=hiq_home_out_energy[30]
Var92=hiq_home_out_energy[31]
Var93=hiq_home_out_energy[32]
Var94=hiq_home_out_energy[33]
Var95=hiq_home_out_energy[34]
Var96=hiq_home_out_energy[35]
Var97=hiq_home_out_energy[36]
Var98=hiq_home_out_energy[37]
Var99=hiq_home_out_energy[38]
Var100=hiq_home_out_energy[39]
Var101=hiq_home_dim_energy[0]
Var102=hiq_home_dim_energy[1]
Var103=hiq_home_dim_energy[2]
Var104=hiq_home_dim_energy[3]
Var105=hiq_home_dim_energy[4]
Var106=hiq_home_dim_energy[5]
Var107=hiq_home_dim_energy[6]
Var108=hiq_home_dim_energy[7]
Var109=hiq_home_dim_energy[8]
Var110=hiq_home_dim_energy[9]
Var111=hiq_home_dim_energy[10]
Var112=hiq_home_dim_energy[11]
Var113=hiq_home_dim_energy[12]
Var114=hiq_home_dim_energy[13]
Var115=hiq_home_dim_energy[14]
Var116=hiq_home_dim_energy[15]

[Socket03]
ID=4
SocketType=0
Descr=HIQ Home
Var00=socket_id
Var01=socket_from
Var02=socket_to
Var03=hiq_home_out[0]
Var04=hiq_home_out[1]
Var05=hiq_home_out[2]
Var06=hiq_home_out[3]
Var07=hiq_home_out[4]
Var08=hiq_home_out[5]
Var09=hiq_home_out[6]
Var10=hiq_home_out[7]
Var11=hiq_home_out[8]
Var12=hiq_home_out[9]
Var13=hiq_home_out[10]
Var14=hiq_home_out[11]
Var15=hiq_home_out[12]
Var16=hiq_home_out[13]
Var17=hiq_home_out[14]
Var18=hiq_home_out[15]
Var19=hiq_home_out[16]
Var20=hiq_home_out[17]
Var21=hiq_home_out[18]
Var22=hiq_home_out[19]
Var23=hiq_home_out[20]
Var24=hiq_home_out[21]
Var25=hiq_home_out[22]
Var26=hiq_home_out[23]
Var27=hiq_home_out[24]
Var28=hiq_home_out[25]
Var29=hiq_home_out[26]
Var30=hiq_home_out[27]
Var31=hiq_home_out[28]
Var32=hiq_home_out[29]
Var33=hiq_home_out[30]
Var34=hiq_home_out[31]
Var35=hiq_home_out[32]
Var36=hiq_home_out[33]
Var37=hiq_home_out[34]
Var38=hiq_home_out[35]
Var39=hiq_home_out[36]
Var40=hiq_home_out[37]
Var41=hiq_home_out[38]
Var42=hiq_home_out[39]
Var43=hiq_home_out[40]
Var44=hiq_home_out[41]
Var45=hiq_home_out[42]
Var46=hiq_home_out[43]
Var47=hiq_home_out[44]
Var48=hiq_home_out[45]
Var49=hiq_home_out[46]
Var50=hiq_home_out[47]
Var51=hiq_home_out[48]
Var52=hiq_home_out[49]
Var53=hiq_home_out[50]
Var54=hiq_home_out[51]
Var55=hiq_home_out[52]
Var56=hiq_home_out[53]
Var57=hiq_home_out[54]
Var58=hiq_home_out[55]
Var59=hiq_home_out[56]
Var60=hiq_home_out[57]
Var61=hiq_home_out[58]
Var62=hiq_home_out[59]
Var63=hiq_home_out[60]
Var64=hiq_home_out[61]
Var65=hiq_home_out[62]
Var66=hiq_home_out[63]
Var67=hiq_home_out[64]
Var68=hiq_home_out[65]
Var69=hiq_home_out[66]
Var70=hiq_home_out[67]
Var71=hiq_home_out[68]
Var72=hiq_home_out[69]
Var73=hiq_home_out[70]
Var74=hiq_home_out[71]
Var75=hiq_home_out[72]
Var76=hiq_home_out[73]
Var77=hiq_home_out[74]
Var78=hiq_home_out[75]
Var79=hiq_home_out[76]
Var80=hiq_home_out[77]
Var81=hiq_home_out[78]
Var82=hiq_home_out[79]
Var83=hiq_home_out[80]
Var84=hiq_home_out[81]
Var85=hiq_home_out[82]
Var86=hiq_home_out[83]
Var87=hiq_home_out[84]
Var88=hiq_home_out[85]
Var89=hiq_home_out[86]
Var90=hiq_home_out[87]
Var91=hiq_home_out[88]
Var92=hiq_home_out[89]
Var93=hiq_home_out[90]
Var94=hiq_home_out[91]
Var95=hiq_home_out[92]

[Net]
CurrentNAD=-1

[Monitor01]
VarCount=4
VarName1=cybro_ip0
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=cybro_ip1
VarBase2=1
VarValue2=0
VarColor2=0
VarIndex2=1
VarName3=cybro_ip2
VarBase3=1
VarValue3=0
VarColor3=0
VarIndex3=2
VarName4=cybro_ip3
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
#PROJECT_OPTIONS_END

#DMVARSLIST_BEGIN
#DMVARSLIST_END

#MASKS_BEGIN
#MASKS_END

#CODE_BEGIN
// AllocGroupList="User Variables", "I/O Variables", "Constants", "system", "push", "modbus", "power meter", "source + consumers", "load", "estore", "hiq home", "socket", "timetable", "parameters", "datetime", "web gui", "gui totals", "gui", "temperature"
var retain
  application_id: long; // yypppnnn => yy = 2 digits year; ppp = 3 digits project number;         nnn = 3 digits application SN within project {AllocGroup="system"}
  version_major: int; // PLC application major version: increments with functionality changes (functionality redefined, changed main HW components,...) {AllocGroup="system"}
  version_minor: int; // PLC application minor version: increments with cosmetic changes (added variables, updated functionalities, ...) {AllocGroup="system"}
  version_release: int; // PLC application release version: increments with bug & issues fixes {AllocGroup="system"}
  version_state: int; // PLC application major version state: 0=alfa, 1=beta, 2=release candidate, 3=release {AllocGroup="system"}
  kernel_major: int; // kernel major version {AllocGroup="system"}
  kernel_minor: int; // kernel minor version {AllocGroup="system"}
  push_req_counter: long; // Number of push messages sent. Program is configured to send push periodically, once a minute. {AllocGroup="push"}
  push_ack_counter: long; // Number of received acknowledges. Acknowledge confirms that connection to server work in both directions. {AllocGroup="push"}
  consumer_state: ARRAY[0..17] OF int; // consumer power-meter state: 0=none, 1=none-PM1 detected, 2=none-PM3 detected, 3=ok, 4=war-PM1 detected, 5=war-PM3 detected, 6=err-PM1 detected, 7=err-PM3 detected, 8=err-no PM. {AllocGroup="source + consumers"}
  consumer_power: ARRAY[0..17] OF long; // consumer power in W {AllocGroup="source + consumers"}
  consumer_energy: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="source + consumers"}
  consumer_status_timer: ARRAY[0..17] OF int; // consumer status timer in ms {AllocGroup="source + consumers"}
  estore_enabled: bool; // estore enabled {AllocGroup="estore"}
  timetable: ARRAY[0..5375] OF int; // 8 x timetable; 15 min resolution; bit coded: b0=local recurring off, b1=local recurring on, b2=local once off, b3=local once on, b4=cloud override, b5=cloud recurring off, b6=cloud recurring on, b7=cloud once off, b8=cloud once on {AllocGroup="timetable"}
  hiq_home_nad: int; // HIQ Home NAD {AllocGroup="hiq home"}
  consumer_partial_power: ARRAY[0..179] OF long; // consumer power per source index=xxy, xx=consumer index, y=source index {AllocGroup="source + consumers"}
  timetable_analog: ARRAY[0..5375] OF int; // analog timetable: 0..100=setpoint in %, -1=disabled {AllocGroup="timetable"}
  timetable_tariff: ARRAY[0..671] OF int; // tarif system timetable; 15 min resolution 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="timetable"}
  timetable_set: ARRAY[0..17] OF bool; // Timetable set command {AllocGroup="timetable"}
  timetable_cloud_once: ARRAY[0..7] OF bool; // enabled cloud optimization {AllocGroup="timetable"}
  timetable_cloud_recurring: ARRAY[0..7] OF bool; // enabled cloud optimization {AllocGroup="timetable"}
  timetable_cloud_analog: ARRAY[0..7] OF bool; // timetable cloud optimization enabled {AllocGroup="timetable"}
  analog_out: ARRAY[0..17] OF int; // analog output 0..100 {AllocGroup="load"}
  power_meter_type: ARRAY[0..17] OF int; // power meter type: 0=none, 1=1ph (Eastron SDM120), 2=3ph (Iskra WM3-8) {AllocGroup="power meter"}
  power_meter_new: int; // new power meter detected: 0=none, 1=eastron, 3=iskra {AllocGroup="power meter"}
  power_meter_energy_imported: ARRAY[0..17] OF long; // power meter energy imported in Wh {AllocGroup="power meter"}
  general_status: int; // general status 0=unknown, 1=ok, 2=error {AllocGroup="system"}
  reset_counter: int; // Total number of controller resets. {AllocGroup="system"}
  operating_hours: long; // Total number of operating hours [h]. {AllocGroup="system"}
  push_enable: bool; // Allow controller to send periodical push messages to server: 0-off, 1-on. {AllocGroup="push"}
  timetable_enable: ARRAY[0..7] OF bool; // timetable enabled {AllocGroup="timetable"}
  load_override_preset: ARRAY[0..17] OF int; // manual set override timer in min; 0=no manual override {AllocGroup="load"}
  consumer_partial_energy: ARRAY[0..179] OF long; // consumer energy per source index=xxy, xx=consumer index, y=source index {AllocGroup="source + consumers"}
  load_inverted: ARRAY[0..17] OF bool; // load output inverted {AllocGroup="load"}
  modbus_retry: int; // modbus retry {AllocGroup="modbus"}
  parameters_crc_tmp: long; // real-time parameters CRC32 {AllocGroup="parameters"}
  parameters_crc32: long; // delayed parameters CRC32 {AllocGroup="parameters"}
  parameters_autosave: bool; // parameters autosave enabled {AllocGroup="parameters"}
  parameters_crc_preset: int; default=15; // preset time for parameters CRC32 update in minutes {AllocGroup="parameters"}
  total_energy: ARRAY[0..6] OF long; // {AllocGroup="web gui"}
  consumer_icon: ARRAY[0..18] OF int; // consumer icon: see consumer icon.txt {AllocGroup="source + consumers"}
  consumer_name: ARRAY[0..294] OF int; // consumer name {AllocGroup="source + consumers"}
  power_meter_energy_exported: ARRAY[0..17] OF long; // power meter energy exported in Wh {AllocGroup="power meter"}
  load_out: ARRAY[0..17] OF bool; // load output 0=off, 1=off {AllocGroup="load"}
  load_set: ARRAY[0..17] OF bool; // load state 0=off, 1=off {AllocGroup="load"}
  kernel_release: int; // kernel release version {AllocGroup="system"}
  power_meter_address_type: int; // power meter addressing type: 0=none, 1=eastron, 3=iskra {AllocGroup="power meter"}
  power_meter_address_new: int; // power meter addressing new address:149-158 {AllocGroup="power meter"}
  power_meter_address_old: int; // power meter addressing old address:149-158 {AllocGroup="power meter"}
  tariff_energy_price: ARRAY[0..3] OF long; // grid energy price in cents per MWh, index: 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="gui totals"}
  consumer_override_preset: ARRAY[0..17] OF int; // manual set override timer in min; 0=no manual override {AllocGroup="source + consumers"}
  consumer_type: ARRAY[0..17] OF int; // consumer type: 0=disabled, 1=3 ph power meter, 2=1 ph power meter, 3=eStore, 4= HIQ home power meter {AllocGroup="source + consumers"}
  consumer_power_nominal: ARRAY[0..17] OF long; // consumer nominal power in W {AllocGroup="source + consumers"}
  consumer_energy_abs: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="source + consumers"}
  consumer_energy_abs_old: ARRAY[0..17] OF long; // consumer energy in 0.1 kWh {AllocGroup="source + consumers"}
  consumer_cmd: ARRAY[0..17] OF int; // consumer command: 1=add, 2=del {AllocGroup="source + consumers"}
  source_power: ARRAY[0..17] OF long; // source power in W {AllocGroup="source + consumers"}
  source_energy: ARRAY[0..17] OF long; // source energy in 0.1 kWh {AllocGroup="source + consumers"}
  source_status_timer: ARRAY[0..17] OF int; // timer for calculating status in ms {AllocGroup="source + consumers"}
  source_power_nominal: ARRAY[0..17] OF long; // source nominal power in W {AllocGroup="source + consumers"}
  source_energy_abs: ARRAY[0..17] OF long; // source energy in 0.1 kWh {AllocGroup="source + consumers"}
  source_energy_abs_old: ARRAY[0..17] OF long; // source energy in 0.1 kWh {AllocGroup="source + consumers"}
  total_source_power: ARRAY[0..3] OF long; // totals for source powers in W; index: 0=all sources, 1=grid, 2=plant, 3=storage {AllocGroup="source + consumers"}
  total_source_energy: ARRAY[0..3] OF long; // totals for source energies in 0.1 kWh; index: 0=all sources, 1=grid, 2=plant, 3=storage {AllocGroup="source + consumers"}
  total_consumer_power: ARRAY[0..4] OF long; // total consumers power in W; index 0=all, 1=grid, 2=plants, 3=storages {AllocGroup="source + consumers"}
  total_consumer_energy: ARRAY[0..4] OF long; // total consumers power in W; index 0=all, 1=grid, 2=plants, 3=storages {AllocGroup="source + consumers"}
  energy_reset_year: int; // energy reset date {AllocGroup="source + consumers"}
  energy_reset_month: int; // energy reset date {AllocGroup="source + consumers"}
  energy_reset_date: int; // energy reset date {AllocGroup="source + consumers"}
  energy_reset_hour: int; // energy reset date {AllocGroup="source + consumers"}
  energy_reset_min: int; // energy reset date {AllocGroup="source + consumers"}
  energy_reset_sec: int; // energy reset date {AllocGroup="source + consumers"}
  estore_nad: int; // eStore NAD {AllocGroup="estore"}
  energy_reset_weekday: int; // energy reset date {AllocGroup="source + consumers"}
  timetable_crc32: ARRAY[0..7] OF long; // {AllocGroup="timetable"}
  timetable_analog_crc32: ARRAY[0..7] OF long; // {AllocGroup="timetable"}
  timetable_tariff_crc32: long; // {AllocGroup="timetable"}
  chr_tout: int; default=1000; // {AllocGroup="modbus"}
  msg_tout: int; default=1000; // {AllocGroup="modbus"}
  consumer_status: ARRAY[0..17] OF int; // consumer power-meter state: 0=none, 1=ok, 2=err. {AllocGroup="source + consumers"}
var_end;

var permanent
  ee_parameters: ARRAY[0..999] OF long; // {AllocGroup="parameters"}
var_end;

var
  energy_reset_req: bool; // reset all energies to 0 {AllocGroup="source + consumers"}
  i: int;
  j: int;
  test_i: int;
  push_timer: int; // Timer for periodically sending push message [s]. {AllocGroup="push"}
  push_req: bool; // Set to send push message and start timer. {AllocGroup="push"}
  push_status: int; // Push status: 0-idle, 1-waiting, 2-ok, 3-error. {AllocGroup="push"}
  push_roundtrip: int; // Time from sending push message to receiving acknowledge [ms]. {AllocGroup="push"}
  hiq_home_status: int; // HIQ Home  status: 0=none, 1=ok, 2=err {AllocGroup="hiq home"}
  hiq_home_pm_power: long; // Measured power consumption [W]. {AllocGroup="hiq home"}
  hiq_home_pm_energy: long; // Energy consumption total [kWh]. {AllocGroup="hiq home"}
  estore_soc: int; // State of charge in 0.1% {AllocGroup="estore"}
  estore_power_to_grid: long; // Power delivered to power grid in W {AllocGroup="estore"}
  estore_power_from_grid: long; // Power from power grid in W {AllocGroup="estore"}
  estore_power_production: long; // Power plant production in W (+ = produced) {AllocGroup="estore"}
  estore_power_to_battery: long; // Power stored to battery in W {AllocGroup="estore"}
  estore_power_from_battery: long; // Power feeded from battery in W {AllocGroup="estore"}
  estore_power_consumption: long; // Total power consumption in W (- = consumed) {AllocGroup="estore"}
  estore_energy_to_grid: long; // Total energy exported to grid in Wh {AllocGroup="estore"}
  estore_energy_from_grid: long; // Total energy imported from grid in Wh {AllocGroup="estore"}
  estore_energy_production: long; // Total produced energy in Wh {AllocGroup="estore"}
  estore_energy_to_battery: long; // Total energy to battery in Wh {AllocGroup="estore"}
  estore_energy_from_battery: long; // Total energy from battery in Wh {AllocGroup="estore"}
  estore_energy_consumption: long; // Total consumed energy in Wh {AllocGroup="estore"}
  socket_request: bool; // socket 1 request {AllocGroup="socket"}
  socket_id: int; // socket id: 0= none, 2=eStore socket, 3=HIQ Home powers and energyes, 4=HIQ Home output states {AllocGroup="socket"}
  socket_from: int; // socket sender NAD {AllocGroup="socket"}
  socket_to: int; // socket destination NAD; 0=broadcast {AllocGroup="socket"}
  socket_command: int; // socket 1 command {AllocGroup="socket"}
  socket_argument_0: int; // socket 1 1st argument {AllocGroup="socket"}
  socket_argument_1: int; // socket 1 2nd argument {AllocGroup="socket"}
  socket_argument_2: int; // socket 1 3rd argument {AllocGroup="socket"}
  socket_argument_3: int; // socket 1 4th argument {AllocGroup="socket"}
  timetable_e_cmd: int; // editing timetable command {AllocGroup="timetable"}
  timetable_e_idx: int; // editing timetable index {AllocGroup="timetable"}
  tariff: int; // active grid tariff: 0=LO, 1=HI, 2=D-LO, 3=D-HI {AllocGroup="timetable"}
  tariff_cmd: int; // editing tariff timetable command {AllocGroup="timetable"}
  optimization_index: ARRAY[0..50] OF int; // timetable oprimization index (0=broadcast) {AllocGroup="timetable"}
  test_l: long;
  optimization_start: ARRAY[0..50] OF int; // timetable optimization start time (hhmmw; hh=hour, mm=minute, w=weekday-1=monday) {AllocGroup="timetable"}
  estore_status: int; // eStore status: 0=none, 1=ok, 2=err {AllocGroup="estore"}
  optimization_time: ARRAY[0..50] OF int; // timetable optimization period in min {AllocGroup="timetable"}
  estore_setpoint: int; // Setpoint_ -100..100= setpoint, -32768=auto {AllocGroup="estore"}
  estore_charge_power: int; // Alowed charging power in -W {AllocGroup="estore"}
  modbus_data: ARRAY[0..999] OF int; // modbus data bytes {AllocGroup="modbus"}
  modbus_status: int; // modbus status: 0=idle, 1=reading data, 2=read OK, 3=read error {AllocGroup="modbus"}
  modbus_read_timer: long; // modbus device retry ms timer {AllocGroup="modbus"}
  modbus_step: int; // modbus state machine step {AllocGroup="modbus"}
  modbus_retry_count: int; // modbus retry count {AllocGroup="modbus"}
  modbus_command: int; // Execute: 0=no operation, 1=Address PM, 2=Init NOK_GW, 3=Rebuild NOK_GW, 4=Clear new NOK_D, 5=Add NOK_D {AllocGroup="modbus"}
  modbus_argument: int; // modbus_command argument {AllocGroup="modbus"}
  power_meter_power: ARRAY[0..17] OF int; // power meter power in W (+=import, -=export) {AllocGroup="power meter"}
  power_msg: int; // new power meter addressing message: 0="", 1=no new device, 2=address changed, 3=addressing error {AllocGroup="power meter"}
  optimization_command: ARRAY[0..50] OF int; // timetable optimization command: 1= set once action, 2= set recurring action, 3=set critical peak tariff, 4=set mask, 5=set setpoint {AllocGroup="timetable"}
  optimization_value: ARRAY[0..50] OF int; // timetable optimization value , depends of command command (-1=clear/clear critical peak tariff, 0=set off/lo tariff, 1= set on/hi tariff, 2=set critical peak tariff, -100..100 set setpoint, -32768=auto) {AllocGroup="timetable"}
  timetable_analog_cmd: ARRAY[0..3] OF int; // timetable command: 1= vrite value to timetable {AllocGroup="timetable"}
  timetable_analog_val: int; // timetable value to write: 0..100= set setpoint, -1=auto {AllocGroup="timetable"}
  timetable_e: ARRAY[0..671] OF bool; // temporary timetable for editing purpose {AllocGroup="timetable"}
  start: bool; default=0; // {AllocGroup="system"}
  edit_year: int; // {AllocGroup="datetime"}
  edit_month: int; // {AllocGroup="datetime"}
  edit_date: int; // {AllocGroup="datetime"}
  edit_weekday: int; // {AllocGroup="datetime"}
  edit_hour: int; // {AllocGroup="datetime"}
  edit_min: int; // {AllocGroup="datetime"}
  edit_sec: int; // {AllocGroup="datetime"}
  datetime_cmd: int; // {AllocGroup="datetime"}
  edit_datetime: bool; // {AllocGroup="datetime"}
  cybro_uptime: long; // Number of operating hours since power-on [h]. {AllocGroup="system"}
  day_min: int; // minute of the day {AllocGroup="datetime"}
  parameters_cmd: int; // parameters manipulation command: 1=init, 2=save, 3=read; auto returns to 0 {AllocGroup="parameters"}
  ee_parameters_error: bool; // ee parameters values not within min-max {AllocGroup="parameters"}
  ee_parameters_ok: bool; // ee parameters values within min-max {AllocGroup="parameters"}
  parameters_error: bool; // parameters values not within min-max {AllocGroup="parameters"}
  parameters_error_idx: int; // index of first error parameter {AllocGroup="parameters"}
  parameters_ok: bool; // parameters values within min-max {AllocGroup="parameters"}
  parameters_saved: bool; // parameters equals to ee {AllocGroup="parameters"}
  ee_save_req: bool; // save ee_par to eeprom {AllocGroup="parameters"}
  parameters_status: int; // parameters status (bit coded:b2=EE OK, b2=par OK, b0=saved) {AllocGroup="parameters"}
  parameters_unsaved_idx: int; // index of first unsaved parameter {AllocGroup="parameters"}
  parameters_crc_timer: long; // parameters CRC32 timer in ms {AllocGroup="parameters"}
  power_meter_address_msg: int; // power meter addressing message: 0=/, {AllocGroup="power meter"}
  buyout_energy_price: long; // current grid energy price in cents per MWh {AllocGroup="gui totals"}
  current_energy_price: long; // current energy price in cents per MWh {AllocGroup="gui totals"}
  power_meter_cmd: ARRAY[0..17] OF int; // power meter command: 1=add, 2=del {AllocGroup="power meter"}
  estore_discharge_power: int; // Alowed discharging power in W {AllocGroup="estore"}
  hiq_home_enabled: bool; // HIQ Home enabled (read grid) {AllocGroup="hiq home"}
  estore_timeout: int; // estore timeout {AllocGroup="estore"}
  battery_soc: int; // battery soc - only read from eStore {AllocGroup="source + consumers"}
  hiq_home_timeout: int; // HIQ Home timeout {AllocGroup="hiq home"}
  config_idx: int; // configuration message index {AllocGroup="gui"}
  config_msg: int; // configuration message {AllocGroup="gui"}
  config_msg_tout: long; // configuring message timeout {AllocGroup="gui"}
  hiq_home_out_power: ARRAY[0..39] OF long; // Power currently used by a single output [W]. {AllocGroup="hiq home"}
  hiq_home_out_energy: ARRAY[0..39] OF long; // Total energy consumption per output [kWh]. {AllocGroup="hiq home"}
  hiq_home_dim_power: ARRAY[0..15] OF long; // Power currently used by a single dimmer [W]. {AllocGroup="hiq home"}
  hiq_home_dim_energy: ARRAY[0..15] OF long; // Total energy consumption per dimmer [kWh]. {AllocGroup="hiq home"}
  hiq_home_out: ARRAY[0..92] OF bool; // HIQ Home output state {AllocGroup="hiq home"}
  timetable_d: ARRAY[0..671] OF int; // temporary timetable for editing purpose {AllocGroup="timetable"}
  timetable_a: ARRAY[0..671] OF int; // temporary timetable for editing purpose {AllocGroup="timetable"}
  timetable_refresh: bool; // {AllocGroup="timetable"}
  timetable_cloud_o: bool; // {AllocGroup="timetable"}
  timetable_cloud_r: bool; // {AllocGroup="timetable"}
  timetable_cloud_a: bool; // {AllocGroup="timetable"}
  timetable_en: bool; // {AllocGroup="timetable"}
  test_b: bool;
  test_i_a: ARRAY[0..999] OF int;
  temperature: int; // temperature in 0.1 C {AllocGroup="temperature"}
  push_period: int; // Period in which push message is sent to server [s]. {AllocGroup="push"}
  cybro_serial: int; // Unique cybro serial number. {AllocGroup="system"}
  cybro_nad: int; // Current cybro A-bus address. {AllocGroup="system"}
  cybro_ip0: int; // Current cybro IP address, 1st byte. {AllocGroup="system"}
  cybro_ip1: int; // Current cybro IP address, 2nd byte. {AllocGroup="system"}
  cybro_ip2: int; // Current cybro IP address, 3rd byte. {AllocGroup="system"}
  cybro_ip3: int; // Current cybro IP address, 4th byte. {AllocGroup="system"}
var_end;

function main:void; language 'Structured Text';
  function f_parameters:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var retain
    retentive_magic: int;
    parameters_crc_tmp_old: long;
  var_end;

    function f_parameters_manage(idx:int; val,def,min,max:long):long; language 'Structured Text';
    begin
      //*****************************************************************************
      // f_parameters_manage(ee_array_index, value, default_value, min_value, max_value, command)
      //*****************************************************************************
      
      // test ee
      if ee_parameters[idx] < min or ee_parameters[idx] > max then
        ee_parameters_error := 1;
      end_if;
      
      // test parameter
      if val < min or val > max then
        parameters_error := 1;
        if parameters_error_idx = -1 then
          parameters_error_idx := idx;
        end_if;
      end_if;
      
      // execute command
      case parameters_cmd of
        1 : // init
          result := def;
          ee_parameters[idx] := def;
          ee_save_req := 1;
        2 : // save
          result := val;
          ee_parameters[idx] := val;
          ee_save_req := 1;
        3 : // load
          result := ee_parameters[idx];
      else
        result := val;
      end_case;
      
      // test if saved
      if result <> ee_parameters[idx] then
        parameters_saved := 0;
        parameters_unsaved_idx := idx;
      end_if;
      
      // crc 32 calc
      parameters_crc_tmp := f_crc_32_update(parameters_crc_tmp,result);
    end;
    function f_crc_32_update(crc,val:long):long; language 'Structured Text';
    begin
      
      
      result := crc xor val;
      for j := 1 to 8 do
        if (result and 1) <> 0 then
          result := (result shr 1) xor 16#EDB88320;
        else
          result := (result shr 1);
        end_if;
      end_for;
      
    end;
  begin
    
    if !ee_read_req and !ee_write_req then
    
      // init general parameters statuses
      parameters_saved := 1;
      parameters_error_idx := -1;
      parameters_unsaved_idx := -1;
      parameters_error := 0;
      ee_parameters_error := 0;
    
      // if retentive fail then read from ee
      if retentive_magic <> 31415 and ee_parameters_ok then
        parameters_cmd := 3; // read from ee
        retentive_magic := 31415;
      end_if;
    
      // don't read if ee parameters are not ok
      if !ee_parameters_ok and parameters_cmd = 3 then
        parameters_cmd := 0;
      end_if;
      // don't save if parameters are not ok
      if !parameters_ok and parameters_cmd = 2 then
        parameters_cmd := 0;
      end_if;
    
      // init parameters when EE is empty (only new controllers)
      if parameters_crc32 = 650399394 then
        parameters_cmd := 1;
      end_if;
    
      //*********************************************************************************************************************
    
      // CRC32 init
      parameters_crc_tmp := 16#FFFFFFFF;
    
      // system [0..9]
      push_enable := bit(f_parameters_manage( 0,push_enable,1,0,1));
      push_period := int(f_parameters_manage( 1,push_period,30,0,300));
    
      modbus_retry := int(f_parameters_manage( 2,modbus_retry,5,0,10));
      parameters_autosave := bit(f_parameters_manage( 3,parameters_autosave,1,0,1));
      estore_enabled := bit(f_parameters_manage( 4,estore_enabled,0,0,1));
      hiq_home_enabled := bit(f_parameters_manage( 5,hiq_home_enabled,0,0,1));
    
      // sources [10..27]
      for i := 0 to 17 do
        if consumer_type[i] <> 3 then
          source_power_nominal[i] := (f_parameters_manage(10+i,source_power_nominal[i],0,0,999999));
        end_if;
      end_for;
    
      // consumers [30..48]
      consumer_icon[0] := int(f_parameters_manage(30,consumer_icon[0],1,0,39));  //grid
      for i := 1 to 3 do
        consumer_icon[i] := consumer_icon[0];  //grid
      end_for;
      for i := 4 to 18 do
        consumer_icon[i] := int(f_parameters_manage(30+i,consumer_icon[i],0,0,39));  //other consumers
      end_for;
    
      // [50..67, 70..87, 90..107]
      for i := 0 to 17 do
        consumer_override_preset[i] := int(f_parameters_manage(50+i,consumer_override_preset[i],0,0,32767));
        consumer_type[i] := int(f_parameters_manage(70+i,consumer_type[i],0,0,7));
        if consumer_type[i] <> 3 then
          consumer_power_nominal[i] := (f_parameters_manage(90+i,consumer_power_nominal[i],0,0,999999));
        end_if;
      end_for;
      // [110..404]
      for i := 0 to 294 do
        consumer_name[i] := int(f_parameters_manage(110+i,consumer_name[i],0,0,32767));
      end_for;
    
      // loads [410..427, 430..447]
      for i := 0 to 17 do
        load_override_preset[i] := int(f_parameters_manage(410+i,load_override_preset[i],0,0,32767));
        load_inverted[i] := bit(f_parameters_manage(430+i,load_inverted[i],0,0,1));
      end_for;
    
      // timetable [450..457]
      for i := 0 to 7 do
        timetable_enable[i] := bit(f_parameters_manage(450+i,timetable_enable[i],0,0,1));
      end_for;
    
      // cloud optimization [460..467, 470..477, 480..487]
      for i := 0 to 7 do
        timetable_cloud_once[i] := bit(f_parameters_manage(460+i,timetable_cloud_once[i],1,0,1));
        timetable_cloud_recurring[i] := bit(f_parameters_manage(470+i,timetable_cloud_recurring[i],1,0,1));
        timetable_cloud_analog[i] := bit(f_parameters_manage(480+i,timetable_cloud_analog[i],1,0,1));
      end_for;
    
    
      // finish crc 32 calc
      parameters_crc_tmp := !parameters_crc_tmp;
    
      //*********************************************************************************************************************
    
      // OK if no errors
      ee_parameters_ok := !ee_parameters_error;
      parameters_ok := !parameters_error;
    
      // save ee_par
      if ee_save_req then
        ee_write_magic := 31415;
        ee_write_req := 1;
      end_if;
      ee_save_req := 0;
    
      // init non ee parameters
      if parameters_cmd = 1 then
        // timetables
        for i := 0 to 5375 do
          timetable[i] := 0;
          timetable_analog[i] := -1;
        end_for;
        // tariff timetable
        for i := 0 to 671 do
          timetable_tariff[i] := 0;
        end_for;
        // battery timetable
    
        modbus_step := 0; // restart modbus comm
    
      end_if;
    
      if parameters_cmd <> 0 then
        parameters_crc32 := parameters_crc_tmp;
      end_if;
    
      // clear command
      parameters_cmd := 0;
    
      // status
      parameters_status := 4*ee_parameters_ok + 2*parameters_ok + parameters_saved;
    
    end_if;
    
    // parameters crc32 calculations
    
    if parameters_crc_tmp = parameters_crc_tmp_old and parameters_crc_tmp <> parameters_crc32 then
      parameters_crc_timer := parameters_crc_timer + scan_time;
    else
      parameters_crc_timer := 0;
    end_if;
    parameters_crc_tmp_old := parameters_crc_tmp;
    
    if parameters_crc_timer >= (long(parameters_crc_preset)*60*1000) or parameters_crc_tmp = 650399394 then
      parameters_crc32 := parameters_crc_tmp;
      if parameters_autosave then
        parameters_cmd := 2;
      end_if;
    end_if;
    
    
  end;
  function f_system:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var
    ip: long; // Temporary IP address for calculations.
  var_end;

    function f_time:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      edit_year_old: int;
      edit_month_old: int;
      edit_date_old: int;
      edit_weekday_old: int;
      edit_hour_old: int;
      edit_min_old: int;
      edit_sec_old: int;
      time: long;
    var_end;

    begin
      // ****************************************************************************
      // rtc
      // ****************************************************************************
      
      day_min := rtc_hour*60+rtc_min;
      
      // ****************************************************************************
      // edit date time
      // ****************************************************************************
      
      if edit_year <> edit_year_old or
         edit_month <> edit_month_old or
         edit_date <> edit_date_old or
         edit_weekday <> edit_weekday_old or
         edit_hour <> edit_hour_old or
         edit_min <> edit_min_old or
         edit_sec <> edit_sec_old
      then
        edit_datetime := 1;
      end_if;
      
      if !edit_datetime then
        datetime_cmd := 0;
      end_if;
      
      case datetime_cmd of // set datetime
        1: // set datetime
          rtc_year := edit_year;
          rtc_month := edit_month;
          rtc_date := edit_date;
          rtc_weekday := edit_weekday;
          rtc_hour := edit_hour;
          rtc_min := edit_min;
          rtc_sec := edit_sec;
          rtc_write_req := 1;
          edit_datetime := 0;
        2:  // cancel
          edit_year := rtc_year;
          edit_month := rtc_month;
          edit_date := rtc_date;
          edit_weekday := rtc_weekday;
          edit_hour := rtc_hour;
          edit_min := rtc_min;
          edit_sec := rtc_sec;
          edit_year_old := edit_year;
          edit_month_old := edit_month;
          edit_date_old := edit_date;
          edit_weekday_old := edit_weekday;
          edit_hour_old := edit_hour;
          edit_min_old := edit_min;
          edit_sec_old := edit_sec;
          edit_datetime := 0;
      end_case;
      datetime_cmd := 0;
      
      if !edit_datetime then
        edit_year := rtc_year;
        edit_month := rtc_month;
        edit_date := rtc_date;
        edit_weekday := rtc_weekday;
        edit_hour := rtc_hour;
        edit_min := rtc_min;
        edit_sec := rtc_sec;
        edit_year_old := edit_year;
        edit_month_old := edit_month;
        edit_date_old := edit_date;
        edit_weekday_old := edit_weekday;
        edit_hour_old := edit_hour;
        edit_min_old := edit_min;
        edit_sec_old := edit_sec;
      end_if;
      
    end;
    function f_push:void; language 'Structured Text';
    begin
      /*
      
        Push communication with WEB server
      
      */
      
      if fp(clock_1s) then // generate periodic push message
        if push_enable then
          if push_timer>0 then
            push_timer:=push_timer-1;
          else
            push_req:=1;
            push_timer:=push_period-1; // push period [s]
          end_if;
        else
          push_timer:=0;
          push_status:=0; // disabled
        end_if;
      end_if;
      
      if push_req then // new push cycle
        push_req:=0;
        push_status:=1; // waiting
        push_roundtrip:=0;
        push_message_req:=1; // send push message
        push_req_counter:=push_req_counter+1; // transmitted messages
      end_if;
      
      if push_message_ack then // acknowledge received
        push_message_ack:=0;
        push_status:=2; // ok
        push_ack_counter:=push_ack_counter+1; // received messages
      end_if;
      
      if push_status==1 then // waiting for answer
        push_roundtrip:=push_roundtrip+scan_time; // elapsed milliseconds
        if push_roundtrip>=5000 then // server timeout [ms]
          push_roundtrip:=0;
          push_status:=3; // error
        end_if;
      end_if;
      
    end;
    function f_general_status:void; language 'Structured Text';
    begin
      
      general_status := 1; // OK
      
      for i := 0 to 17 do
        if consumer_state[i] = 2 then
          general_status := 2; // ERR
        end_if;
      end_for;
      
      if parameters_status <> 2#0111 then
        general_status := 2; // ERR
      end_if;
      
      
    end;
  begin
    
    if !start then
      reset_counter:=reset_counter+1;
      datetime_cmd := 2; // cancel
      start := 1;
    end_if;
    
    // once per hour increment cybro uptime and operating hours
    
    if fp(rtc_min==0) then
      cybro_uptime:=cybro_uptime+1;
      operating_hours:=operating_hours+1;
    end_if;
    
    f_time();
    
    f_push();
    
    f_general_status();
    
    // nad and serial number
    
    cybro_nad:=int(get_nad());
    cybro_serial:=int(get_serial());
    
    // ip address
    
    if fp(clock_1s) then
      ip:=get_ip();
      if ip>=0 then
        cybro_ip0:=int(ip/16#1000000);
      else
        ip:=ip+16#80000000;
        cybro_ip0:=int(ip/16#1000000)+128;
      end_if;
      cybro_ip1:=int(long(ulong(ip/65536))%256);
      cybro_ip2:=int(long(ulong(ip%65536))/256);
      cybro_ip3:=int(long(ulong(ip%65536))%256);
    end_if;
    
  end;
  function f_io_mux:void; language 'Structured Text';
    function min_max(val,v_min,v_max:int):int; language 'Structured Text';
    begin
      
      // function min_max(val, min, max:int):int;
      //
      // limit val to min - max
      
      if val > v_max then
        result := v_max;
      elsif val < v_min then
        result := v_min;
      else
        result := val;
      end_if;
    end;
    function f_analog(button:bit; idx:int):int; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      dt: int;
      button_old: bool;
    var_end;

    var retain
      button_timer: int;
      direction: bool;
      button_timeout: int;
    var_end;

    begin
      
      if !button and button_old then
        if button_timer > 200 then
          direction := !direction;
        else
          load_set[idx] := !load_set[idx];
        end_if;
      end_if;
      button_old := button;
      
      if button then
        button_timer := button_timer + scan_time;
        button_timeout := 0;
      else
        button_timer := 0;
        if button_timeout < 5000 then
          button_timeout := button_timeout + scan_time;
        end_if;
      end_if;
      
      if button_timer > 200 then
        // longpress detected
        dt := dt + scan_time;
        if dt >= 5000/100 then
          if direction then
            analog_out[idx] := analog_out[idx] + 1;
          else
            analog_out[idx] := analog_out[idx] - 1;
          end_if;
          analog_out[idx] := min_max(analog_out[idx],0,100);
          dt := 0;
        end_if;
      else
        dt := 0;
      end_if;
      
      if !button then
        if analog_out[idx] >= 100 then
          direction := 0;
        elsif analog_out[idx] <= 0 or button_timeout >= 5000 then
          direction := 1;
        end_if;
      end_if;
    end;
  begin
    // ****************************************************************************
    //
    // ****************************************************************************
    
    f_analog(cybro_ix00,10);
    cybro_qx00 := load_out[10];
    cybro_io14_mode := 5;
    cybro_qw14 := analog_out[10];
    cybro_io15_mode := 11; // PWM
    pulse_train_frequency := 1000; // PWM f=1kHz
    cybro_qw15 := analog_out[10];
    
    if fp(cybro_ix01) then
      load_out[11] := ! load_out[11];
    end_if;
    cybro_qx01 := load_out[11];
    
    if fp(cybro_ix02) then
      load_out[12] := ! load_out[12];
    end_if;
    cybro_qx02 := load_out[12];
    
    cybro_io12_mode := 1; // digital input
    if fp(cybro_ix12) then
      load_out[13] := ! load_out[13];
    end_if;
    cybro_qx03 := load_out[13];
    
    // temperature
    cybro_io13_mode := 6; // temperature sensor
    temperature := cybro_iw13;
    
  end;
  function f_algorithms:int; language 'Structured Text';
    function f_modbus:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      address: int;
      pm_i: int;
      cpm_i: int;
      modbus_step_return: int;
      modbus_step_next: int;
      timeout: int;
    var_end;

    var
      exp: int;
    var_end;

      function f_modbus_comm(com_port,slave_address,function_code,data_address,data_count:int):void; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        mb_crc: int;
        mb_step: int;
        mb_data: ARRAY[0..999] OF int;
        mb_last: int;
        mb_rx_len: int;
      var_end;

      var
        length: int;
        mb_echo: bool;
      var_end;

        function f_crc(count:int):int; language 'Structured Text';
        begin
          
          //Calaculate CRC
          
          result:=16#FFFF;
          
          for i := 0 to count do
            result := result xor mb_data[i];
            for j := 1 to 8 do
              if (result and 1) <> 0 then
                result := ((result shr 1) and 16#7FFF) xor 16#A001;
              else
                result := (result shr 1) and 16#7FFF;
              end_if;
            end_for;
          end_for;
          
          
        end;
        function hi_byte(value:int):int; language 'Structured Text';
        begin
          
          result := int(ulong(value) shr 8);
          
        end;
        function lo_byte(value:int):int; language 'Structured Text';
        begin
          
          result := value and 16#00FF;
        end;
        function roundup(val:real):int; language 'Structured Text';
        begin
          
          result := int(val);
          
          if val > result then
            result := result+1;
          end_if;
        end;
        function bit_set(val,bit_i:int; data:bit):int; language 'Structured Text';
        // AllocGroupList="User Variables"
        var
          tmp: int;
        var_end;

        begin
          
          result := val;
          
          tmp := 16#0001 shl bit_i;
          
          if data = 0 then
            result := result and !tmp;
          else
            result := result or tmp;
          end_if;
        end;
      begin
        /*
        
          f_modbus_comm(com_port, slave_address, function_code, data_address, data_count)
        
          inputs:
            modbus_data[0..255]  int  data to write
        
          output:
            modbus_status        int  0=idle, 1=reading, 2=red OK, 3= read error
            modbus_data[0..255]  int  read data
        
        */
        
        modbus_status := 1; // reading
        
        com_select(com_port);
        
        if com_port = 1 and              // com 1
           (cybro_hardware_id/1000) = 11  // CyBro3-H
        then
          mb_echo := 1;
        end_if;
        
        // prepare out message
        
        case mb_step of
        
          0: // prepare and send request
            // wait for com
            if not (rx_active() or tx_active()) then
              // prepare data
              mb_data[0] := slave_address;
              mb_data[1] := function_code;
              mb_data[2] := hi_byte(data_address);
              mb_data[3] := lo_byte(data_address);
        
              if function_code = 1 then
                // read coil status
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + 5 + roundup(real(data_count)/8);
              elsif function_code = 2 then
                // read input status
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + roundup(real(data_count)/8);
              elsif function_code = 3 then
                // read holding registers
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + 2 * data_count;
              elsif function_code = 4 then
                // read input registers
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + 5 + 2 * data_count;
              elsif function_code = 5 then
                // force single coil
                if modbus_data[0] > 0 then
                  mb_data[4] := 16#FF;
                  mb_data[5] := 16#00;
                else
                  mb_data[4] := 16#00;
                  mb_data[5] := 16#00;
                end_if;
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + 8;
              elsif function_code = 6 then
                // preset single register
                mb_data[4] := hi_byte(modbus_data[0]);
                mb_data[5] := lo_byte(modbus_data[0]);
                mb_crc := f_crc(5);
                mb_data[6] := lo_byte(mb_crc);
                mb_data[7] := hi_byte(mb_crc);
                mb_last := 7;
                mb_rx_len := mb_echo * (mb_last + 1) + 8;
              elsif function_code = 15 then
                // force multiple coils
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_data[6] := roundup(real(data_count)/8);
                for i := 0 to data_count-1 do
                  mb_data[i/8+7] := bit_set(mb_data[i/8+7], i%8, bit(modbus_data[i]));
                end_for;
                mb_crc := f_crc(data_count/8+7);
                mb_data[data_count/8+8] := lo_byte(mb_crc);
                mb_data[data_count/8+9] := hi_byte(mb_crc);
                mb_last := data_count/8+9;
                mb_rx_len := mb_echo * (mb_last + 1) + 8;
              elsif function_code = 16 then
                // preset multiple registers
                mb_data[4] := hi_byte(data_count);
                mb_data[5] := lo_byte(data_count);
                mb_data[6] := (data_count*2);
                for i := 0 to data_count-1 do
                  mb_data[2*i+7] := hi_byte(modbus_data[i]);
                  mb_data[2*i+8] := lo_byte(modbus_data[i]);
                end_for;
                mb_crc := f_crc(2*data_count+6);
                mb_data[2*data_count+7] := lo_byte(mb_crc);
                mb_data[2*data_count+8] := hi_byte(mb_crc);
                mb_last := 2*data_count+8;
                mb_rx_len := mb_echo * (mb_last + 1) + 8;
              else
                mb_last := 0;
              end_if;
              for i := 0 to mb_last do
                dprnc(0,i,0,mb_data[i]);
                mb_data[i] := 0;
              end_for;
              // clear buffers
              for i := 0 to 255 do
                modbus_data[i] := 0;
                mb_data[i] := 0;
                test_i_a[i] := 0;
              end_for;
              // transmit
              tx_start(mb_last+1);
              // start receiving
              rx_start(0,0,0,25,50);
              mb_step := mb_step+1;
            end_if;
        
          1: // test if received data OK
            if not (rx_active() or tx_active()) then
        
              test_i := rx_count(); // test
              for i := 0 to test_i do
                test_i_a[i] := rx_bufrd(i);
              end_for;
        
              if rx_count() = mb_rx_len then                    // length OK
                for i := 0 to (mb_rx_len-1-(mb_echo * (mb_last + 1))) do
                  mb_data[i] := rx_bufrd(i+(mb_echo * (mb_last + 1)));
                end_for;
                mb_crc := f_crc(mb_rx_len-(mb_echo * (mb_last + 1))-3);                   // calculate received message crc
                if mb_data[0] = slave_address and                                         // slave address OK
                   mb_data[1] = function_code and                                         // function code OK
                   mb_data[mb_rx_len-(mb_echo * (mb_last + 1))-2] = lo_byte(mb_crc) and   // function code OK
                   mb_data[mb_rx_len-(mb_echo * (mb_last + 1))-1] = hi_byte(mb_crc)       // function code OK
                then
                  // read to modbus_data[]
                  for i := 0 to data_count-1 do
                    if function_code < 3 then
                      modbus_data[i] := (mb_data[i/8+3] and (1 rol (i%8))) > 0;
                    else
                      modbus_data[i] := 256 * mb_data[2*i+3] + mb_data[2*i+4];
                    end_if;
                  end_for;
                  modbus_status := 2; // read ok
                else
                  // set status to error
                  modbus_status := 3; // rec message format error
                end_if;
              else
                // set status to error
                modbus_status := 4; // rec message lenght error
              end_if;
              mb_step := 0;
            end_if;
        
        end_case;
      end;
      function f_test(idx,val1,val2,val3:int):bit; language 'Structured Text';
      begin
        
        result := modbus_data[idx+0] = val1 and
                  modbus_data[idx+1] = val2 and
                  modbus_data[idx+2] = val3;
      end;
      function f_read_float(idx,factor:int):long; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        value: long;
      var_end;

      begin
        
        value := (ulong(modbus_data[idx+0]) shl 16) or
                 (ulong(modbus_data[idx+1]) shl 00);
        
        result := long(breal(value)*factor);
        
        
      end;
      function f_read_t6(idx:int):long; language 'Structured Text';
      // AllocGroupList="User Variables"
      var static
        exponent: int;
        value: long;
        value_r: real;
      var_end;

      begin
        /*
        
          read T6 - signed measurment 32 bit
        
          bits 31..24 = exponent (signed 8 bit)
          bits 23..00 = binary signed value (24 bit)
        
          -123456*10-3 = FDFE1DC0h
        
        */
        
        // test exponent for negative
        exponent := modbus_data[idx] shr 8;
        if exponent >= 16#80 then
          // if negative
          exponent := exponent or 16#FF00;
        end_if;
        
        value := (ulong(modbus_data[idx] and 16#00FF) shl 16) + modbus_data[idx+1];
        
        value_r := value;
        if exponent = 0 then
          result := long(value_r);
        elsif exponent > 0 then
          for i := 1 to exponent do
            value_r := value_r * 10;
          end_for;
          result := long(value_r);
        else
          for i := 1 to -exponent do
            value_r := value_r / 10;
          end_for;
          result := long(value_r);
        end_if;
      end;
      function f_read_t2(idx:int):int; language 'Structured Text';
      begin
        /*
        
          read T2 - signed 16 bit value
        
          -12345 = CFC7h
        
        */
        
        result := modbus_data[idx];
      end;
      function f_read_t3(idx:int):long; language 'Structured Text';
      begin
        /*
        
          read T3 - signed 32 bit value
        
          -123456789 = 07BCD15h
        
        */
        
        result := (long(modbus_data[idx+0]) shl 16) or
                  (long(modbus_data[idx+1]) shl 00);
      end;
    begin
      
      for i := 0 to 17 do
        case power_meter_cmd[i] of
          1 : // add
            if (power_meter_new = 1 or power_meter_new = 3) and
               power_meter_type[i] = 0
            then
              power_meter_address_type := power_meter_new;
              power_meter_address_old := 149;
              power_meter_address_new := 150 + i;
              modbus_command := 2;
            end_if;
          2 : // del
            if (power_meter_type[i] = 1 or power_meter_type[i] = 3) and
               power_meter_new = 0
            then
              power_meter_address_type := power_meter_type[i];
              power_meter_address_old := 150 + i;
              power_meter_address_new := 149;
              modbus_command := 2;
            end_if;
        end_case;
        power_meter_cmd[i] := 0;
      end_for;
      
      case modbus_step of
      
      // ****************************************************************************
      // CMD ?
      // ****************************************************************************
      
        0 : // command?
          case modbus_command of
            1 : // scan PM
              modbus_step := 40; // check all PM
            2 : // address PM
              modbus_step := 50; // address PM
          else
            // read PM
            modbus_step := 10; // read PM
          end_case;
      
      // ****************************************************************************
      // read PM
      // ****************************************************************************
      
        10 : // select PM
          pm_i := pm_i + 1;
          if pm_i > 0 and pm_i < 4 then pm_i := 4; end_if; // skip grid tariff 1,2,3
          if pm_i = 9 then pm_i := 10; end_if; // skip unknown
          if pm_i > 13 then pm_i := -1; end_if; // restart
          address := 150 + pm_i;
          modbus_step := modbus_step + 1;
      
        11 : // read PM type
          f_modbus_comm(1, address, 4, 1, 3);
          if modbus_status = 2 then
            // read OK
            if f_test(0,16#574D,16#332D,16#3620) then
              // ISKRA
              if pm_i = -1 then
                power_meter_new := 3;
              else
                power_meter_type[pm_i] := 3;
              end_if;
              modbus_step := 30; // read iskra power
            else
              // EASTRON
              if pm_i = -1 then
                power_meter_new := 1;
              else
                power_meter_type[pm_i] := 1;
              end_if;
              modbus_step := 20; // read eastron power
            end_if;
          elsif modbus_status >=3 then
            // no response
            if (modbus_retry_count >= modbus_retry) or
               (power_meter_type[pm_i] = 0) or         // do not retry if it was not configured before
               pm_i = -1
            then
              if pm_i = -1 then
                power_meter_new := 0;
              else
                power_meter_type[pm_i] := 0;
              end_if;
              modbus_step := 0; // restart
      //        modbus_step := 999; // test
            else
              modbus_step_return := modbus_step;
              modbus_step_next := 0; // next power meter
              modbus_step := 900; // retry device
            end_if;
          end_if;
      
      // read eastron
      
        20: // read eastron power
          f_modbus_comm(1, address, 4, 12, 2);
          if modbus_status = 2 then
            // read OK
            power_meter_power[pm_i] := int(f_read_float(0,1));
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_type[pm_i] := 0; // error
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        21 : // read eastron energy
          f_modbus_comm(1, address, 4, 72, 4);
          if modbus_status = 2 then
            // read OK
            power_meter_energy_imported[pm_i] := f_read_float(0,1000);
            power_meter_energy_exported[pm_i] := f_read_float(2,1000);
            modbus_step := 0;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_type[pm_i] := 0; // none
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
      
      // read iskra
      
        30 : // read iskra power
          f_modbus_comm(1, address, 4, 140, 2);
          if modbus_status = 2 then
            // read OK
            power_meter_power[pm_i] := int(f_read_t6(0));
            modbus_step := modbus_step + 1;
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_type[pm_i] := 0; // none
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
        31: // read iskra energy
          f_modbus_comm(1, address, 4, 414, 24);
          if modbus_status = 2 then
            // read OK
            power_meter_energy_imported[pm_i] := f_read_t3(20);
            exp := f_read_t2(0)-3;
            if exp > 1 then
              for i := 1 to exp do
                power_meter_energy_imported[pm_i] := power_meter_energy_imported[pm_i] * 10;
              end_for;
            elsif exp < 0 then
              for i := 1 to -exp do
                power_meter_energy_imported[pm_i] := power_meter_energy_imported[pm_i] / 10;
              end_for;
            elsif exp = 0 then
              power_meter_energy_imported[pm_i] := 1;
            end_if;
            power_meter_energy_exported[pm_i] := f_read_t3(22);
            exp := f_read_t2(1)-3;
            if exp > 1 then
              for i := 1 to exp do
                power_meter_energy_exported[pm_i] := power_meter_energy_exported[pm_i] * 10;
              end_for;
            elsif exp < 0 then
              for i := 1 to -exp do
                power_meter_energy_exported[pm_i] := power_meter_energy_exported[pm_i] / 10;
              end_for;
            elsif exp = 0 then
              power_meter_energy_exported[pm_i] := 1;
            end_if;
            modbus_step := 0; // next power meter
          elsif modbus_status >=3 then
            // no response
            if modbus_retry_count = modbus_retry then
              power_meter_type[pm_i] := 0; // none
            end_if;
            modbus_step_return := modbus_step;
            modbus_step_next := 0; // next power meter
            modbus_step := 900; // retry device
          end_if;
      
      // ****************************************************************************
      // scan PM
      // ****************************************************************************
      
        40 : // init
          cpm_i := -1; // new PM
          modbus_step := 42;
      
        41 : // select PM
          cpm_i := cpm_i + 1; // next PM
          if cpm_i > 0 and cpm_i < 4 then cpm_i := 4; end_if; // skip grid tariff 1,2,3
          if cpm_i = 9 then cpm_i := 10; end_if; // skip unknown
          if cpm_i > 13 then
            // end
            cpm_i := 0;
            modbus_command := 0;
            modbus_step := 0;
          else
            modbus_step := modbus_step + 1;
          end_if;
      
        42 : // select PM
          address := 150 + cpm_i;
          modbus_step := modbus_step + 1;
      
        43 : // read PM type
          f_modbus_comm(1, address, 4, 1, 3);
          if modbus_status = 2 then
            // read OK
            if f_test(0,16#574D,16#332D,16#3620) then
              // ISKRA
              if cpm_i = -1 then
                power_meter_new := 3;
              else
                power_meter_type[cpm_i] := 3;
              end_if;
              modbus_step := 41;
            else
              // EASTRON
              if cpm_i = -1 then
                power_meter_new := 1;
              else
                power_meter_type[cpm_i] := 1;
              end_if;
              modbus_step := 41;
            end_if;
          elsif modbus_status >=3 then
            // no response
            if cpm_i = -1 then
              power_meter_new := 0;
            else
              power_meter_type[cpm_i] := 0;
            end_if;
            modbus_step := 41;
          end_if;
      
      // ****************************************************************************
      // address PM
      // ****************************************************************************
      
        50 : // check type
          if power_meter_address_new < 149 or
             power_meter_address_new = 151 or
             power_meter_address_new = 152 or
             power_meter_address_new = 153 or
             power_meter_address_new = 159 or
             power_meter_address_new > 163
          then
            // wrong parameter
            power_meter_address_msg := 3;
            timeout := 2000;
            modbus_step := 80; // wait -> exit
          else
            if power_meter_address_type = 1 then
              // eastron
              modbus_step := 60;
            elsif power_meter_address_type = 3 then
              // iskra
              modbus_step := 70;
            else
              // no new
              power_meter_address_msg := 1;
              timeout := 2000;
              modbus_step := 80; // wait -> exit
            end_if;
          end_if;
      
        60 : // set eastron address
          modbus_data[0] := int(blong(breal(power_meter_address_new)) shr 16);
          modbus_data[1] := int(blong(breal(power_meter_address_new)) shr 00);
          f_modbus_comm(1,power_meter_address_old,16,20,2);
          if modbus_status = 2 then
            // response OK
            power_meter_address_msg := 2;
            timeout := 2000;
            modbus_step := 80; // wait -> exit
          elsif modbus_status >=3 then
            // no response
            power_meter_address_msg := 3;
            timeout := 2000;
            modbus_step := 80; // wait -> exit
          end_if;
      
        70 : // set iskra address
          modbus_data[0] := power_meter_address_new;
          f_modbus_comm(1,power_meter_address_old,6,202,1);
          if modbus_status = 2 then
            // response OK
            timeout := 5000;
            modbus_step := modbus_step+1;
          elsif modbus_status >=3 then
            // no response
            power_meter_address_msg := 3;
            timeout := 2000;
            modbus_step := 80; // wait -> exit
          end_if;
      
        71 : // wait -> save settings
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            modbus_step := modbus_step+1;
          end_if;
      
        72 : // save iskra settings
          modbus_data[0] := 1;
          f_modbus_comm(1,power_meter_address_new,6,12,1);
          if modbus_status = 2 then
            // response OK
            power_meter_address_msg := 2;
            timeout := 2000;
            modbus_step := 80;
            power_meter_address_msg := 1;
          elsif modbus_status >=3 then
            // no response
            power_meter_address_msg := 3;
            timeout := 2000;
            modbus_step := 80; // wait -> exit
          end_if;
      
        80 : // wait -> exit
          timeout := timeout - scan_time;
          if timeout <= 0 then
            timeout := 0;
            power_meter_address_msg := 0;
            power_meter_address_new := 0;
            power_meter_address_old := 0;
            power_meter_address_type := 0;
            modbus_step := 40; // scan PM
          end_if;
      
      // ****************************************************************************
      // timeout and retry
      // ****************************************************************************
      
        900: // next device
          timeout := 1000;
          modbus_retry_count := modbus_retry_count + 1;
          modbus_step := modbus_step + 1;
      //    modbus_step := 999; // test
      
        901: // wait and retry
          if (modbus_retry_count <= modbus_retry) then
            timeout := timeout - scan_time;
            if (timeout <= 0) then
              modbus_step := modbus_step_return;
            end_if;
          else
            modbus_step := modbus_step_next;
            modbus_retry_count := 0;
          end_if;
      
        999: // test
          if test_b then
              modbus_step := modbus_step_next;
            test_b := 0;
          end_if;
      
      end_case; // modbus_step
      
      //
      
      if modbus_status = 2 then
        modbus_retry_count := 0;
      end_if;
      
    end;
    function f_read_consumer_source:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var retain
      consumer_timeout: ARRAY[0..17] OF int;
    var_end;

    var
      d_e: long;
    var_end;

    begin
      
      // eStore
      if estore_nad = 0 then
        estore_enabled := 0;
        estore_status := 0; // none
        estore_timeout := 0;
      end_if;
      if estore_nad = 0 and socket_id=2 and socket_from > 0 then
        estore_nad := socket_from;
      end_if;
      
      if estore_enabled then
        consumer_type[0] := 3; // grid
        consumer_type[4] := 3; // plant 1
        consumer_type[7] := 3; // storage 1
      end_if;
      if fn(estore_enabled) then
        for i := 0 to 17 do
          if consumer_type[i] = 3 then
            consumer_type[i] := 0;
          end_if;
        end_for;
      end_if;
      
      if socket_id = 2 and socket_from = estore_nad then
        estore_timeout := 10000;
      end_if;
      if estore_timeout > 0 then
        estore_timeout := estore_timeout - scan_time;
        estore_status := 1; // ok
      else
        estore_timeout := 0;
        if estore_enabled then
          estore_status := 2; // err
        else
          estore_status := 0; // none
        end_if;
      end_if;
      
      // HIQ Home
      if hiq_home_nad = 0 then
        hiq_home_enabled := 0;
        hiq_home_status := 0; // none
        hiq_home_timeout := 0;
      end_if;
      if hiq_home_nad = 0 and socket_id=3 and socket_from > 0 then
        hiq_home_nad := socket_from;
      end_if;
      if hiq_home_enabled then
        consumer_type[0] := 4; // grid
      end_if;
      if fn(hiq_home_enabled) then
        for i := 0 to 17 do
          if consumer_type[i] = 4 then
            consumer_type[i] := 0;
          end_if;
        end_for;
      end_if;
      
      if socket_id = 3 and socket_from = hiq_home_nad then
        hiq_home_timeout := 10000;
      end_if;
      if hiq_home_timeout > 0 then
        hiq_home_timeout := hiq_home_timeout - scan_time;
        hiq_home_status := 1; // ok
      else
        hiq_home_timeout := 0;
        if hiq_home_enabled then
          hiq_home_status := 2; // err
        else
          hiq_home_status := 0; // none
        end_if;
      end_if;
      
      for i := 0 to 17 do
      
        consumer_timeout[i] := consumer_timeout[i] - scan_time;
      
        case consumer_type[i] of
      
          0 : // none
            if power_meter_type[i] = 1 then
              // PM1 detected
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 1; // none, PM1 detected
            elsif power_meter_type[i] = 3 then
              // PM3 detected
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 2; // none, PM3 detected
            else
              // no PM
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 0; // none
            end_if;
      
          1 : // 3 PH power meter
            if power_meter_type[i] = 3 then
              consumer_state[i] := 3; // OK
              battery_soc := 0;
              if i = 0 then
                if power_meter_power[i] > 0 then
                  source_power[i] := power_meter_power[i];
                  consumer_power[i] := 0;
                else
                  consumer_power[i] := -power_meter_power[i];
                  source_power[i] := 0;
                end_if;
                source_energy_abs[i] := power_meter_energy_imported[i];
                consumer_energy_abs[i] := power_meter_energy_exported[i];
              else
                if power_meter_power[i] < 0 then
                  source_power[i] := -power_meter_power[i];
                  consumer_power[i] := 0;
                else
                  consumer_power[i] := power_meter_power[i];
                  source_power[i] := 0;
                end_if;
                source_energy_abs[i] := power_meter_energy_exported[i];
                consumer_energy_abs[i] := power_meter_energy_imported[i];
              end_if;
            elsif power_meter_type[i] = 0 then
              // no PM
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 8; // ERR, no PM
            elsif power_meter_type[i] = 1 then
              // PM1 detected
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 6; // ERR, PM1 detected
            end_if;
      
          2 : // 1 PH power meter
            if power_meter_type[i] = 1 then
              consumer_state[i] := 3; // OK
              battery_soc := 0;
              if i = 0 then
                if power_meter_power[i] > 0 then
                  source_power[i] := power_meter_power[i];
                  consumer_power[i] := 0;
                else
                  consumer_power[i] := -power_meter_power[i];
                  source_power[i] := 0;
                end_if;
                source_energy_abs[i] := power_meter_energy_imported[i];
                consumer_energy_abs[i] := power_meter_energy_exported[i];
              else
                if power_meter_power[i] < 0 then
                  source_power[i] := -power_meter_power[i];
                  consumer_power[i] := 0;
                else
                  consumer_power[i] := power_meter_power[i];
                  source_power[i] := 0;
                end_if;
                source_energy_abs[i] := power_meter_energy_exported[i];
                consumer_energy_abs[i] := power_meter_energy_imported[i];
              end_if;
            elsif power_meter_type[i] = 0 then
              // no PM
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 8; // ERR, no PM
            elsif power_meter_type[i] = 3 then
              // PM3 detected
              source_power[i] := 0;
              consumer_power[i] := 0;
              battery_soc := 0;
              consumer_state[i] := 7; // ERR, PM3 detected
            end_if;
      
          3 : // eStore
            if estore_status = 1 then
              if i = 0 then
                // grid
                source_power[i] := estore_power_from_grid;
                source_energy_abs[i] := estore_energy_from_grid;
                consumer_power[i] := estore_power_to_grid;
                consumer_energy_abs[i] := estore_energy_to_grid;
              elsif i = 4 then
                // plant
                source_power[i] := estore_power_production;
                source_energy_abs[i] := estore_energy_production;
                consumer_power[i] := 0;
                consumer_energy_abs[i] := 0;
              elsif i = 7 then
                // storage
                source_power[i] := estore_power_from_battery;
                source_energy_abs[i] := estore_energy_from_battery;
                consumer_power[i] := estore_power_to_battery;
                consumer_energy_abs[i] := estore_energy_to_battery;
                source_power_nominal[i] := estore_discharge_power;
                consumer_power_nominal[i] := -estore_charge_power;
                battery_soc := estore_soc;
              end_if;
              case power_meter_type[i] of
                0 : // none
                  consumer_state[i] := 3; // OK
                1 : // PM1
                  consumer_state[i] := 4; // WARNING, PM1 detected
                3 : // PM3
                  consumer_state[i] := 5; // WARNING, PM3 detected
              end_case;
            else
              source_power[i] := 0;
              consumer_power[i] := 0;
              estore_timeout := 0;
              battery_soc := 0;
              consumer_state[i] := 9; // ERR, no eStore
            end_if;
      
          4 : // HIQ Home power meter
            if hiq_home_status = 1 then
              source_power[i] := hiq_home_pm_power;
              source_energy_abs[i] := hiq_home_pm_energy;
              consumer_power[i] := 0;
              consumer_energy_abs[i] := 0;
              case power_meter_type[i] of
                0 : // none
                  consumer_state[i] := 3; // OK
                1 : // PM1
                  consumer_state[i] := 4; // WARNING, PM1 detected
                3 : // PM3
                  consumer_state[i] := 5; // WARNING, PM3 detected
              end_case;
            else
              consumer_power[i] := 0;
              source_power[i] := 0;
              hiq_home_timeout := 0;
              consumer_state[i] := 10; // ERR, no HIQ Home
            end_if;
      
        else
            consumer_state[i] := 11;
            source_power[i] := 0;
            consumer_power[i] := 0;
            source_power_nominal[i] := 0;
            consumer_power_nominal[i] := 0;
            battery_soc := 0;
      
        end_case;
      
        // grid power
        if i = 0 then
          source_power[tariff] := source_power[i];
          case tariff of
            0:
              source_power[1] := 0;
              source_power[2] := 0;
              source_power[3] := 0;
            1:
              source_power[0] := 0;
              source_power[2] := 0;
              source_power[3] := 0;
            2:
              source_power[0] := 0;
              source_power[1] := 0;
              source_power[3] := 0;
            3:
              source_power[0] := 0;
              source_power[1] := 0;
              source_power[2] := 0;
          end_case;
        end_if;
      
        // abs energies (direct from pm) to incremental
        // sources
        d_e := source_energy_abs[i] - source_energy_abs_old[i];
        if i = 0 then
          // grid energy -> depending on tariff
          if d_e > 0 and d_e < 1000 then
            source_energy[tariff] := source_energy[tariff] + d_e;
          end_if;
        else
          if d_e > 0 and d_e < 1000 then
            source_energy[i] := source_energy[i] + d_e;
          end_if;
        end_if;
        // consumers
        d_e := consumer_energy_abs[i] - consumer_energy_abs_old[i];
        if d_e > 0 and d_e < 1000 then
          consumer_energy[i] := consumer_energy[i] + d_e;
        end_if;
        source_energy_abs_old[i] := source_energy_abs[i];
        consumer_energy_abs_old[i] := consumer_energy_abs[i];
      
        // consumer command
        case consumer_cmd[i] of
          1 : // add
            case consumer_state[i] of
              0 : // none
                if power_meter_new > 0 then
                  consumer_type[i] := (2 * int(power_meter_new = 1)) + (1 * int(power_meter_new = 3));
                  power_meter_cmd[i] := 1;
                  config_idx := i;
                  config_msg := 1;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 2;
                  config_msg_tout := 5000;
                end_if;
              1 : // none, PM1 detected
                consumer_type[i] := 2;
                config_idx := i;
                config_msg := 3;
                config_msg_tout := 5000;
              2 : // none, PM3 detected
                consumer_type[i] := 1;
                config_idx := i;
                config_msg := 4;
                config_msg_tout := 5000;
              3 : // OK
                config_idx := i;
                config_msg := 5;
                config_msg_tout := 5000;
              4 : // warning, PM1 detected
                config_idx := i;
                config_msg := 6;
                config_msg_tout := 5000;
              5 : // warning, PM3 detected
                config_idx := i;
                config_msg := 7;
                config_msg_tout := 5000;
              6 : // ERR, PM1 detected
                consumer_type[i] := 2;
                config_idx := i;
                config_msg := 8;
                config_msg_tout := 5000;
              7 : // ERR, PM3 detected
                consumer_type[i] := 1;
                config_idx := i;
                config_msg := 9;
                config_msg_tout := 5000;
              8 : // ERR, no PM
                if (consumer_type[i] = 2 and power_meter_new = 1) or
                   (consumer_type[i] = 1 and power_meter_new = 3)
                then
                  power_meter_cmd[i] := 1;
                  config_idx := i;
                  config_msg := 1;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 10;
                  config_msg_tout := 5000;
                end_if;
              9 : // ERR, no eStore
                config_idx := i;
                config_msg := 11;
                config_msg_tout := 5000;
              10: // ERR, no HIQ Home
                config_idx := i;
                config_msg := 12;
                config_msg_tout := 5000;
              11: // ERR, wrong config
                config_idx := i;
                config_msg := 13;
                config_msg_tout := 5000;
            end_case;
      
          2 : // del
            case consumer_state[i] of
              0 : // none
                config_idx := i;
                config_msg := 14;
                config_msg_tout := 5000;
              1 : // none, PM1 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              2 : // none, PM3 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              3 : // OK
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              4 : // warning, PM1 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              5 : // warning, PM3 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              6 : // ERR, PM1 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              7 : // ERR, PM3 detected
                if power_meter_new = 0 then
                  consumer_type[i] := 0;
                  power_meter_cmd[i] := 2;
                  config_idx := i;
                  config_msg := 15;
                  config_msg_tout := 9000;
                else
                  config_idx := i;
                  config_msg := 16;
                  config_msg_tout := 5000;
                end_if;
              8 : // ERR, no PM
                config_idx := i;
                consumer_type[i] := 0;
              9 : // ERR, no eStore
                estore_enabled := 0;
                config_idx := i;
                config_msg := 17;
                config_msg_tout := 5000;
              10: // ERR, no HIQ Home
                hiq_home_enabled := 0;
                config_idx := i;
                config_msg := 18;
                config_msg_tout := 5000;
              11: // ERR, wrong config
                config_idx := i;
                config_msg := 19;
                config_msg_tout := 5000;
                consumer_type[i] := 0;
            end_case;
      
        end_case;
        consumer_cmd[i] := 0;
      
        // skip virtual sources
        if i = 0 then i := 3; end_if;
        if i = 8 then i := 9; end_if;
      
      end_for;
      
      // virtual consumers
      consumer_state[1] := consumer_state[0];
      consumer_state[2] := consumer_state[0];
      consumer_state[3] := consumer_state[0];
      consumer_state[9] := 3; // always OK
      
      // config message
      if config_msg >= 20 then
        config_msg := 0;
      end_if;
      for i := 0 to 17 do
        if config_msg = 0 then
          case consumer_state[i] of
            0 : // none
              config_idx := -2;
              config_msg := 0;
            1 : // PM1 detected
              config_idx := i;
              config_msg := 20;
            2 : // PM3 detected
              config_idx := i;
              config_msg := 21;
            3 : // OK
              config_idx := -2;
              config_msg := 0;
            4 : // warning, PM1 detected
              config_idx := i;
              config_msg := 22;
            5 : // warning, PM3 detected
              config_idx := i;
              config_msg := 23;
            6 : // ERR, PM1 detected
              config_idx := i;
              config_msg := 24;
            7 : // ERR, PM3 detected
              config_idx := i;
              config_msg := 25;
            8 : // ERR, no PM
              config_idx := i;
              config_msg := 26;
            9 : // ERR, no eStore
              config_idx := i;
              config_msg := 27;
            10: // ERR, no HIQ Home
              config_idx := i;
              config_msg := 28;
            11: // ERR, wrong config
              config_idx := i;
              config_msg := 29;
          end_case;
        end_if;
      end_for;
      if config_msg = 0 then
        case power_meter_new of
          1 : // PM1
            config_idx := -1;
            config_msg := 30;
          3 : // PM3
            config_idx := -1;
            config_msg := 31;
        end_case;
      end_if;
      
      // config message timeout
      
      if config_msg_tout > 0 then
        config_msg_tout := config_msg_tout - scan_time;
      end_if;
      if fp(config_msg_tout <= 0) then
        config_idx := -2;
        config_msg := 0;
      end_if;
      
      
      // consumer_status
      for i:=0 to 17 do
        case consumer_state[i] of
        0: consumer_status[i]:=0;    // none
        1: consumer_status[i]:=0;    // none, PM1 detected
        2: consumer_status[i]:=0;    // none, PM3 detected
        3: consumer_status[i]:=1;    // OK
        4: consumer_status[i]:=2;    // warning, PM1 detected
        5: consumer_status[i]:=2;    // warning, PM3 detected
        6: consumer_status[i]:=2;    // error, PM1 detected
        7: consumer_status[i]:=2;    // error, PM3 detected
        8: consumer_status[i]:=2;    // error, no PM
        end_case;
      end_for;
      
    end;
    function f_managed_load:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var retain
      load_set_old: ARRAY[0..17] OF bool;
      load_override_timer: ARRAY[0..17] OF long;
      load_status_timeout: ARRAY[0..17] OF int;
    var_end;

      function min_max(val,v_min,v_max:int):int; language 'Structured Text';
      begin
        
        // function min_max(val, min, max:int):int;
        //
        // limit val to min - max
        
        if val > v_max then
          result := v_max;
        elsif val < v_min then
          result := v_min;
        else
          result := val;
        end_if;
      end;
    begin
      
      for i := 0 to 17 do
      
        // manual override
        if load_set[i] <> load_set_old[i] then
          load_override_timer[i] := long(load_override_preset[i]) * 1000 * 60;
          timetable_set[i] := load_set[i];
        end_if;
        load_set_old[i] := load_set[i];
        load_override_timer[i] := load_override_timer[i] - scan_time;
        if load_override_timer[i] <= 0 then
          load_override_timer[i] := 0;
          load_set[i] := timetable_set[i];
        end_if;
      
        // inverted output
        if load_inverted[i] then
          load_out[i] := !load_set[i];
        else
          load_out[i] := load_set[i];
        end_if;
      
        // clear nonexisting analog out
        if i <> 10 then
          analog_out[i] := 0;
        end_if;
      
      end_for;
      
      
      
    end;
    function f_partials:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      c_i: int;
      s_i: int;
      t_i: int;
    var_end;

    var retain
      consumer_partial_energy_mwh: ARRAY[0..179] OF long;
      consumer_energy_old: ARRAY[0..17] OF long;
    var_end;

    var
      d_energy: long;
      balance_energy: long;
    var_end;

      function round(val:real):long; language 'Structured Text';
      begin
        
        // function round(val:real):int;
        //
        // rounds val(real) to integer
        
        
        if (val-int(val)) >= 0.5 then
          result := long(val)+1;
        else
          result := long(val);
        end_if;
      end;
    begin
      
      // ****************************************************************************
      // reset all energies
      // ****************************************************************************
      
      if energy_reset_req then
        // sources
        for i := 0 to 9 do
          source_energy[i] := 0;
        end_for;
        for i := 0 to 17 do
          consumer_energy[i] := 0;
        end_for;
        for i := 0 to 179 do
          consumer_partial_energy[i] := 0;
          consumer_partial_energy_mwh[i] := 0;
        end_for;
        energy_reset_year := rtc_year;
        energy_reset_month := rtc_month;
        energy_reset_date := rtc_date;
        energy_reset_weekday := rtc_weekday;
        energy_reset_hour := rtc_hour;
        energy_reset_min := rtc_min;
        energy_reset_sec := rtc_sec;
      end_if;
      energy_reset_req := 0;
      
      // ****************************************************************************
      // power totals
      // ****************************************************************************
      
      total_source_power[0] := 0;
      total_source_power[1] := 0;
      total_source_power[2] := 0;
      total_source_power[3] := 0;
      total_consumer_power[0] := 0;
      total_consumer_power[1] := 0;
      total_consumer_power[2] := 0;
      total_consumer_power[3] := 0;
      total_consumer_power[4] := 0;
      for i := 0 to 3 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[1] := total_source_power[1] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[1] := total_consumer_power[1] + consumer_power[i];
      end_for;
      for i := 4 to 6 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[2] := total_source_power[2] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[2] := total_consumer_power[2] + consumer_power[i];
      end_for;
      for i := 7 to 8 do
        total_source_power[0] := total_source_power[0] + source_power[i];
        total_source_power[3] := total_source_power[3] + source_power[i];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[3] := total_consumer_power[3] + consumer_power[i];
      end_for;
      for i := 10 to 17 do
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[i];
        total_consumer_power[4] := total_consumer_power[4] + consumer_power[i];
      end_for;
      
      // unknown source / unmanaged consumers power calculation
      
      if total_consumer_power[0] > total_source_power[0] then
        source_power[9] := total_consumer_power[0] - total_source_power[0];
        total_source_power[0] := total_source_power[0] + source_power[9];
        consumer_power[9] := 0;
      elsif total_consumer_power[0] < total_source_power[0] then
        source_power[9] := 0;
        consumer_power[9] := total_source_power[0] - total_consumer_power[0];
        total_consumer_power[0] := total_consumer_power[0] + consumer_power[9];
      else
        source_power[9] := 0;
        consumer_power[9] := 0;
      end_if;
      
      // ****************************************************************************
      // divide
      // ****************************************************************************
      
      // divide power
      for c_i := 0 to 17 do
        for s_i := 0 to 9 do
          consumer_partial_power[c_i*10+s_i] := round(real(source_power[s_i]) * consumer_power[c_i] / total_source_power[0]);
        end_for;
      end_for;
      
      // divide energy
      for c_i := 0 to 17 do
        if c_i <> 9 then // skip unmanaged
          d_energy := consumer_energy[c_i] - consumer_energy_old[c_i];
          consumer_energy_old[c_i] := consumer_energy[c_i];
          if d_energy > 0 and d_energy <= 1000 then // normal delta => divide per power
            // divide
            for s_i := 0 to 9 do
              consumer_partial_energy_mwh[c_i*10+s_i] := consumer_partial_energy_mwh[c_i*10+s_i] + long(real(d_energy)*1000/consumer_power[c_i]*consumer_partial_power[c_i*10+s_i]);
              consumer_partial_energy[c_i*10+s_i] := consumer_partial_energy[c_i*10+s_i] + (consumer_partial_energy_mwh[c_i*10+s_i] / 1000);
              consumer_partial_energy_mwh[c_i*10+s_i] := consumer_partial_energy_mwh[c_i*10+s_i] % 1000;
            end_for;
          end_if;
        end_if;
      end_for;
      
      // ****************************************************************************
      // calculated energy
      // ****************************************************************************
      
      // unmanaged partials
      for s_i := 0 to 8 do
        consumer_partial_energy[90+s_i] := source_energy[s_i];
        for c_i := 0 to 17 do
          if c_i <> 9 then
            consumer_partial_energy[90+s_i] := consumer_partial_energy[90+s_i] - consumer_partial_energy[10*c_i+s_i];
          end_if;
        end_for;
      end_for;
      // total unmanaged
      consumer_energy[9] := 0;
      for s_i := 0 to 9 do
        consumer_energy[9] := consumer_energy[9] + consumer_partial_energy[90+s_i];
      end_for;
      
      // total unknown energy
      source_energy[9] := 0;
      for c_i := 0 to 17 do
        consumer_partial_energy[c_i*10+9] := consumer_energy[c_i];
        for s_i := 0 to 8 do
          consumer_partial_energy[c_i*10+9] := consumer_partial_energy[c_i*10+9] - consumer_partial_energy[c_i*10+s_i];
        end_for;
        source_energy[9] := source_energy[9] + consumer_partial_energy[c_i*10+9];
      end_for;
      
      
      // ****************************************************************************
      // energy totals
      // ****************************************************************************
      
      // total sources
      total_source_energy[0] := 0;
      total_source_energy[1] := 0;
      total_source_energy[2] := 0;
      total_source_energy[3] := 0;
      total_consumer_energy[0] := 0;
      total_consumer_energy[1] := 0;
      total_consumer_energy[2] := 0;
      total_consumer_energy[3] := 0;
      total_consumer_energy[4] := 0;
      for i := 0 to 3 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[1] := total_source_energy[1] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[1] := total_consumer_energy[1] + consumer_energy[i];
      end_for;
      for i := 4 to 6 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[2] := total_source_energy[2] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[2] := total_consumer_energy[2] + consumer_energy[i];
      end_for;
      for i := 7 to 8 do
        total_source_energy[0] := total_source_energy[0] + source_energy[i];
        total_source_energy[3] := total_source_energy[3] + source_energy[i];
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[3] := total_consumer_energy[3] + consumer_energy[i];
      end_for;
      for i := 9 to 17 do
        total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[i];
        total_consumer_energy[4] := total_consumer_energy[4] + consumer_energy[i];
      end_for;
      total_source_energy[0] := total_source_energy[0] + source_energy[9];
      total_consumer_energy[0] := total_consumer_energy[0] + consumer_energy[9];
      
      // ****************************************************************************
      // partial energy totals
      // ****************************************************************************
      
      // production -> grid
      t_i := 0;
      total_energy[t_i] := 0;
      for c_i := 0 to 0 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // storage -> grid
      t_i := 1;
      total_energy[t_i] := 0;
      for c_i := 0 to 0 do
        for s_i := 7 to 8 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // grid -> storage
      t_i := 2;
      total_energy[t_i] := 0;
      for c_i := 7 to 8 do
        for s_i := 0 to 3 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // production -> storage
      t_i := 3;
      total_energy[t_i] := 0;
      for c_i := 7 to 8 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // storage -> consumption
      t_i := 4;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 7 to 8 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // grid -> consumption
      t_i := 5;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 0 to 3 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      // production -> consumption
      t_i := 6;
      total_energy[t_i] := 0;
      for c_i := 9 to 17 do
        for s_i := 4 to 6 do
          total_energy[t_i] := total_energy[t_i] + consumer_partial_energy[c_i*10+s_i];
        end_for;
      end_for;
      
    end;
    function f_timetable:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      i0: int;
      i1: int;
      tt_s_h: int;
      tt_s_m: int;
      tt_s_w: int;
      tt_i: int;
      tt_s: int;
      cmd_i: int;
    var_end;

    var retain
      i0_old: int;
      timetable_battery_default_old: int;
      timetable_cloud_o_old: bool;
      timetable_cloud_r_old: bool;
      timetable_cloud_a_old: bool;
      timetable_en_old: bool;
    var_end;

    var
      set_value: bool;
      set_mask: int;
    var_end;

      function min_max(val,v_min,v_max:int):int; language 'Structured Text';
      begin
        
        // function min_max(val, min, max:int):int;
        //
        // limit val to min - max
        
        if val > v_max then
          result := v_max;
        elsif val < v_min then
          result := v_min;
        else
          result := val;
        end_if;
      end;
      function f_timetable_crc32:void; language 'Structured Text';
      // AllocGroupList="User Variables"
      var retain
        tti: int;
        ttj: int;
        tts: int;
        ttc: int;
        timetable_crc32_t: ARRAY[0..7] OF long;
        timetable_analog_crc32_t: ARRAY[0..7] OF long;
        timetable_tariff_crc32_t: long;
        timetable_crc32_timer: ARRAY[0..7] OF long;
        timetable_crc32_old: ARRAY[0..7] OF long;
        timetable_analog_crc32_timer: ARRAY[0..7] OF long;
        timetable_analog_crc32_old: ARRAY[0..7] OF long;
        timetable_tariff_crc32_old: long;
        timetable_tariff_crc32_timer: long;
        timetable_crc32_tmp: ARRAY[0..7] OF long;
        timetable_analog_crc32_tmp: ARRAY[0..7] OF long;
        timetable_tariff_crc32_tmp: long;
      var_end;

        function f_crc_32_update(crc,val:long):long; language 'Structured Text';
        // AllocGroupList="User Variables"
        var
          k: long;
        var_end;

        begin
          
          
          result := crc xor val;
          for k := 1 to 8 do
            if (result and 1) <> 0 then
              result := (result shr 1) xor 16#EDB88320;
            else
              result := (result shr 1);
            end_if;
          end_for;
          
        end;
      begin
        // **************************************************************************
        // timetables CRC32 calc
        // **************************************************************************
        
        case tts of
          0 : // init
            tti := 0;
            ttj := 0;
            timetable_crc32_t[tti] := 16#FFFFFFFF;
            timetable_analog_crc32_t[tti] := 16#FFFFFFFF;
            timetable_tariff_crc32_t := 16#FFFFFFFF;
            tts := tts+1;
        
          1 : // calculate timetable and timetable_analog CRC
            timetable_crc32_t[tti] := f_crc_32_update(timetable_crc32_t[tti],timetable[tti*672+ttj]);
            timetable_analog_crc32_t[tti] := f_crc_32_update(timetable_analog_crc32_t[tti],timetable_analog[tti*672+ttj]);
            if ttj < 671 then
              ttj := ttj + 1;
            else
              // next timetable
              ttj := 0;
              tti := tti + 1;
              timetable_crc32_t[tti] := 16#FFFFFFFF;
              timetable_analog_crc32_t[tti] := 16#FFFFFFFF;
              if tti > 7 then
                tti := 0;
                tts := tts + 1;
              end_if;
            end_if;
        
          2:  // calc timetable_tariff CRC
            timetable_tariff_crc32_t := f_crc_32_update(timetable_tariff_crc32_t,timetable_tariff[ttj]);
            if ttj < 671 then
              ttj := ttj + 1;
            else
              // next timetable
              ttj := 0;
              tts := tts + 1;
            end_if;
        
          3: //
            for tti := 0 to 7 do
              timetable_crc32_tmp[tti] := !timetable_crc32_t[tti];
              timetable_analog_crc32_tmp[tti] := !timetable_analog_crc32_t[tti];
            end_for;
            timetable_tariff_crc32_tmp := !timetable_tariff_crc32_t;
            tts := 0;
        
        end_case;
        
        for ttc := 0 to 7 do
          // timers
          if timetable_crc32_tmp[ttc] = timetable_crc32_old[ttc] and timetable_crc32_tmp[ttc] <> timetable_crc32[ttc] then
            timetable_crc32_timer[ttc] := timetable_crc32_timer[ttc] + scan_time;
          else
            timetable_crc32_timer[ttc] := 0;
          end_if;
          timetable_crc32_old[ttc] := timetable_crc32_tmp[ttc];
        
          if timetable_crc32_timer[ttc] >= (long(15)*60*1000) then // 15 min
            timetable_crc32[ttc] := timetable_crc32_tmp[ttc];
          end_if;
        
          if timetable_analog_crc32_tmp[ttc] = timetable_analog_crc32_old[ttc] and timetable_analog_crc32_tmp[ttc] <> timetable_analog_crc32[ttc] then
            timetable_analog_crc32_timer[ttc] := timetable_analog_crc32_timer[ttc] + scan_time;
          else
            timetable_analog_crc32_timer[ttc] := 0;
          end_if;
          timetable_analog_crc32_old[ttc] := timetable_analog_crc32_tmp[ttc];
        
          if timetable_analog_crc32_timer[ttc] >= (long(15)*60*1000) then // 15 min
            timetable_analog_crc32[ttc] := timetable_analog_crc32_tmp[ttc];
          end_if;
        end_for;
        
        // timer
        if timetable_tariff_crc32_tmp = timetable_tariff_crc32_old and timetable_tariff_crc32_tmp <> timetable_tariff_crc32 then
          timetable_tariff_crc32_timer := timetable_tariff_crc32_timer + scan_time;
        else
          timetable_tariff_crc32_timer := 0;
        end_if;
        timetable_tariff_crc32_old := timetable_tariff_crc32_tmp;
        
        if timetable_tariff_crc32_timer >= (long(15)*60*1000) then // 15 min
          timetable_tariff_crc32 := timetable_tariff_crc32_tmp;
        end_if;
        
      end;
    begin
      
      i0:=96*((rtc_weekday+6)%7)+4*rtc_hour+(rtc_min/15); // current timetable index
      i1 := i0-1;
      if i1 < 0 then i1 := 671; end_if;
      
      //*****************************************************************************
      // managed load timetables
      //*****************************************************************************
      
      for i := 0 to 7 do
      
        if i0 <> i0_old and timetable_enable[i] then
      
          // delete previous once
          timetable[i*672+i1] := timetable[i*672+i1] and 2#0011;
      
          if (timetable[i*672+i0] and 2#1100) = 2#0100 then
            // OFF
            timetable_set[i+10] := 0;
          elsif (timetable[i*672+i0] and 2#1100) = 2#1000 then
            // ON
            timetable_set[i+10] := 1;
          elsif (timetable[i*672+i0] and 2#1100) = 0 then
            // no once action => accept recurring actions
            if (timetable[i*672+i0] and 2#0011) = 2#0001 then
              // OFF
              timetable_set[i+10] := 0;
            elsif (timetable[i*672+i0] and 2#0011) = 2#0010 then
              // ON
              timetable_set[i+10] := 1;
            end_if;
          end_if;
      
          // analog timetable
          if timetable_analog[i*672+i0] <> -1 then
            analog_out[i] := timetable_analog[i*672+i0];
          end_if;
      
        end_if;
      
        // disable analog
        if i <> 0 then
          timetable_cloud_analog[i] := 0;
        end_if;
      
      end_for;
      
      //*****************************************************************************
      // tariff timetable
      //*****************************************************************************
      
      tariff := timetable_tariff[i0];
      
      if i0 <> i0_old then
         // clear previous critical peak
        timetable_tariff[i1] := timetable_tariff[i1] and 2#01;
      end_if;
      
      // ****************************************************************************
      // displayed timetable
      // ****************************************************************************
      
      for i := 0 to 671 do
        timetable_d[i] := timetable[timetable_e_idx*672 + i];
        if timetable_e_idx = 0 then
          timetable_a[i] := timetable_analog[timetable_e_idx*672 + i];
        else
          timetable_a[i] := -1;
        end_if;
      end_for;
      
      if timetable_cloud_o <> timetable_cloud_o_old then
        timetable_cloud_once[timetable_e_idx] := timetable_cloud_o;
      else
        timetable_cloud_o := timetable_cloud_once[timetable_e_idx];
      end_if;
      timetable_cloud_o_old := timetable_cloud_o;
      
      if timetable_cloud_r <> timetable_cloud_r_old then
        timetable_cloud_recurring[timetable_e_idx] := timetable_cloud_r;
      else
        timetable_cloud_r := timetable_cloud_recurring[timetable_e_idx];
      end_if;
      timetable_cloud_r_old := timetable_cloud_r;
      
      if timetable_cloud_a <> timetable_cloud_a_old then
        timetable_cloud_analog[timetable_e_idx] := timetable_cloud_a;
      else
        timetable_cloud_a := timetable_cloud_analog[timetable_e_idx];
      end_if;
      timetable_cloud_a_old := timetable_cloud_a;
      
      if timetable_en <> timetable_en_old then
        timetable_enable[timetable_e_idx] := timetable_en;
      else
        timetable_en := timetable_enable[timetable_e_idx];
      end_if;
      timetable_en_old := timetable_en;
      
      timetable_refresh := 0;
      
      // ****************************************************************************
      // edit managed load timetables
      // ****************************************************************************
      
      if timetable_e_cmd > 0 then
        for i := 0 to 671 do
          if timetable_e[i] then
            case timetable_e_cmd of
              1  : // once off
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;   // clear once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0100;   // set once off
              2  : // once on
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;   // clear once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#1000;   // set once on
              3  : // once disable
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#1100;   // set once disable
              4  : // delete once
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#0011;  // clear once
              5  : // recurring off
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0001;   // set recurring off
              6  : // recurring on
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] or  2#0010;   // set recurring on
              7 : // delete recurring
                timetable[timetable_e_idx*672 + i] := timetable[timetable_e_idx*672 + i] and 2#1100;   // clear recurring
            end_case;
            timetable_e[i] := 0;
          end_if;
        end_for;
        timetable_e_cmd := 0;
      end_if;
      
      //*****************************************************************************
      // edit tariff timetable
      //*****************************************************************************
      
      case tariff_cmd of
        1 : // set LO
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := 0;
              timetable_e[i] := 0;
            end_if;
          end_for;
        2 : // set HI
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := 1;
              timetable_e[i] := 0;
            end_if;
          end_for;
        3 : // set CP
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := timetable_tariff[i] + 2;
              timetable_e[i] := 0;
            end_if;
          end_for;
        4 : // delete CP
          for i := 0 to 671 do
            if timetable_e[i] then
              timetable_tariff[i] := timetable_tariff[i] and 2#01;
              timetable_e[i] := 0;
            end_if;
          end_for;
      end_case;
      tariff_cmd := 0;
      
      //*****************************************************************************
      // edit analog timetable
      //*****************************************************************************
      
      i := 0;
      
      if timetable_analog_cmd[i] > 0 then
        for j := 0 to 671 do
          // write selected
          if timetable_e[j] and timetable_analog_cmd[i] = 1 then
            timetable_analog[i * 672 + j] := timetable_analog_val;
            timetable_e[j] := 0;
          elsif timetable_analog_cmd[i] = 2 then // claear all
            timetable_analog[i * 672 + j] := -1;
          end_if;
        end_for;
        timetable_analog_val := 0;
        timetable_analog_cmd[i] := 0;
      end_if;
      
      
      //*****************************************************************************
      // cloud edit timetables
      //*****************************************************************************
      
      for cmd_i := 0 to 50 do
      
        if optimization_command[cmd_i] > 0 then
      
          tt_s_h := optimization_start[cmd_i] / 1000;
          tt_s_h := min_max(tt_s_h, 0, 23);
          tt_s_m := (optimization_start[cmd_i] % 1000) / 10;
          tt_s_m := min_max(tt_s_m, 0, 59);
          tt_s_w := optimization_start[cmd_i] % 10;
          tt_s_w := min_max(tt_s_w, 1, 7);
          optimization_time[cmd_i] := min_max(optimization_time[cmd_i], 0, 600);
          if optimization_index[cmd_i] = 0 then
            for tt_i := 0 to 7 do
              tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
              case optimization_command[cmd_i] of
                1 : // set once
                  if timetable_cloud_once[tt_i] then
                    case optimization_value[cmd_i] of
                     -1 : // clear once
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      0 : // set once off
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                      1 : // set once on
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                    end_case;
                    if optimization_time[cmd_i] > 15 then
                      for i := 1 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(tt_i)*672+(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        if optimization_value[cmd_i] = -1 then
                          timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                        elsif optimization_value[cmd_i] = 0 or optimization_value[cmd_i] = 1 then
                          timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                        end_if;
                      end_for;
                    end_if;
                  end_if;
                2 : // set recurring
                  if timetable_cloud_recurring[tt_i] then
                    case optimization_value[cmd_i] of
                     -1 : // clear recurring
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                      0 : // set recurring off
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                        timetable[tt_s] := timetable[tt_s] or  2#0001; // set recurring off
                      1 : // set recurring on
                        timetable[tt_s] := timetable[tt_s] and 2#0011; // clear recurring
                        timetable[tt_s] := timetable[tt_s] or  2#0010; // set recurring on
                    end_case;
                  end_if;
                3 : // set tariff
                  if optimization_time[cmd_i] > 0 then
                    for i := 0 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                      if optimization_value[cmd_i] = 0 then
                          timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#10; // set lo
                      elsif optimization_value[cmd_i] = 1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#01; // set hi
                      elsif optimization_value[cmd_i] = 2 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#10; // set critical peak
                      elsif optimization_value[cmd_i] = -1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#01; // delete critical peak
                      end_if;
                    end_for;
                  end_if;
                4: // set mask
                  if timetable_cloud_once[tt_i] and optimization_time[cmd_i] >= 15 then
                    set_mask := optimization_value[cmd_i];
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
                    set_value := (set_mask and 1) > 0;
                    timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                    if set_value then
                      timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                    else
                      timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                    end_if;
                    for i := 1 to (set_mask/15) do
                      set_mask := set_mask shr 1;
                      tt_s := (tt_s + 1)%672;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if set_value <> bit(set_mask and 1) then
                        set_value := (set_mask and 1) > 0;
                        if set_value then
                          timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                        else
                          timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                        end_if;
                      else
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
              5: // set analog
                if timetable_cloud_analog[tt_i] then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                    optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-1,100);
                    timetable_analog[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
              end_case;
            end_for;
          elsif optimization_index[cmd_i] > 0 and optimization_index[cmd_i] <= 8 then
            tt_i := optimization_index[cmd_i]-1;
            tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
            case optimization_command[cmd_i] of
              1 : // set once
                if timetable_cloud_once[tt_i] then
                  case optimization_value[cmd_i] of
                   -1 : // clear once
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                    0 : // set once off
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                    1 : // set once on
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                  end_case;
                  if optimization_time[cmd_i] > 15 then
                    for i := 1 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(tt_i)*672+(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if optimization_value[cmd_i] = -1 then
                          timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      elsif optimization_value[cmd_i] = 0 or optimization_value[cmd_i] = 1 then
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
                end_if;
              2 : // set recurring
                if timetable_cloud_recurring[tt_i] then
                  case optimization_value[cmd_i] of
                   -1 : // clear recurring
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                    0 : // set recurring off
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                      timetable[tt_s] := timetable[tt_s] or  2#0001; // set recurring off
                    1 : // set recurring on
                      timetable[tt_s] := timetable[tt_s] and 2#1100; // clear recurring
                      timetable[tt_s] := timetable[tt_s] or  2#0010; // set recurring on
                  end_case;
                end_if;
              3 : // set tariff
                  if optimization_time[cmd_i] > 0 then
                    for i := 0 to (optimization_time[cmd_i]-1)/15 do
                      tt_s :=(96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i)%672;
                      if optimization_value[cmd_i] = 0 then
                          timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#10; // set lo
                      elsif optimization_value[cmd_i] = 1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#01; // set hi
                      elsif optimization_value[cmd_i] = 2 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] or 2#10; // set critical peak
                      elsif optimization_value[cmd_i] = -1 then
                        timetable_tariff[tt_s] := timetable_tariff[tt_s] and 2#01; // delete critical peak
                      end_if;
                    end_for;
                  end_if;
              4: // set mask
                if timetable_cloud_once[tt_i] and optimization_time[cmd_i] >= 15 then
                  set_mask := optimization_value[cmd_i];
                  tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15);
                  set_value := (set_mask and 1) > 0;
                  timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                  if set_value then
                    timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                  else
                    timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                  end_if;
                  if optimization_time[cmd_i] >= 30 then
                    for i := 1 to (optimization_time[cmd_i]/15)-1 do
                      set_mask := set_mask shr 1;
                      tt_s := (tt_s + 1);
                      if tt_s > (tt_i)*672+671 then
                        tt_s := tt_i*672;
                      end_if;
                      timetable[tt_s] := timetable[tt_s] and 2#0011; // clear once
                      if set_value <> bit(set_mask and 1) then
                        set_value := (set_mask and 1) > 0;
                        if set_value then
                          timetable[tt_s] := timetable[tt_s] or  2#1000; // set once on
                        else
                          timetable[tt_s] := timetable[tt_s] or  2#0100; // set once off
                        end_if;
                      else
                        timetable[tt_s] := timetable[tt_s] or  2#1100; // set once disable
                      end_if;
                    end_for;
                  end_if;
                end_if;
              5: // set analog
                if timetable_cloud_analog[tt_i] then
                  for i := 0 to (optimization_time[cmd_i]-1)/15 do
                    tt_s :=(tt_i)*672+96*((tt_s_w+6)%7)+4*tt_s_h+(tt_s_m/15)+i;
                    optimization_value[cmd_i] := min_max(optimization_value[cmd_i],-1,100);
                    timetable_analog[tt_s] := optimization_value[cmd_i];
                  end_for;
                end_if;
            end_case;
          end_if;
        end_if;
      
        optimization_command[cmd_i] := 0;
      
      end_for;
      
      f_timetable_crc32();
      
    end;
  begin
    
    f_modbus();
    
    f_read_consumer_source();
    
    f_managed_load();
    
    f_partials();
    
    f_timetable();
    
    
    
  end;
  function f_clear_socket_variables:void; language 'Structured Text';
  begin
    
    // eStore
    
    if socket_id = 2 then
      socket_id := 0;
    end_if;
    
    // HIQ Home power
    if socket_id = 3 then
      socket_id := 0;
    end_if;
    
    
  end;
  function f_gui:void; language 'Structured Text';
  begin
    
    // energy price
    current_energy_price := tariff_energy_price[tariff];
    
    
  end;
begin
  
  // ****************************************************************************
  // Application ID
  // yypppnnn => yy  2 digits year
  //             ppp 3 digits project number
  //             nnn 3 digits application SN within project
  //                yypppnnn
  application_id := 17020001;
  // Version number
  version_major   := 1; // major changes: added functionality, changed main HW components, ...
  version_minor   := 0; // cosmetic changes: added variables, updated functionalities, ...
  version_release := 2; // bug & issues fixes, ...
  // Version state
  // 0=alfa, 1=beta, 2=release candidate, 3=release
  version_state   := 3;
  // CyBro kernel version
  kernel_major   := 3;
  kernel_minor   := 0;
  kernel_release := 3;
  
  // ****************************************************************************
  
  if !ee_read_req then
  
    f_parameters();
  
    f_system();
  
    f_io_mux();
  
    if parameters_ok then
  
      f_algorithms();
  
    else
  
      // all off!
      for i := 0 to 17 do
        load_out[i] := 0;
        analog_out[i] := 0;
      end_for;
  
    end_if;
  
    f_clear_socket_variables();
  
    f_gui();
  
  end_if;
end;
#CODE_END

#DESCRIPTION_BEGIN
  103 : // read nok sensor devices data valid
    f_modbus_read(1,1,2,162,14);
    if modbus_status = 2 then
      // response OK
      for i := 0 to 13 do
        nok_data_valid[i] := f_read_bit(i);
      end_for;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  104: // read nok load manager devices presence
    f_modbus_read(1,1,2,50,14);
    if modbus_status = 2 then
      // response OK
      for i := 0 to 13 do
        if f_read_bit(i) <> nok_data_valid[i] then
          sensor_status[i] := 2; // error
        else
          sensor_status[i] := nok_data_valid[i];
        end_if;
      end_for;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  105: // read new device data valid
    f_modbus_read(1,1,2,239,1);
    if modbus_status = 2 then
      // response OK
      nok_nd_valid := f_read_bit(0);
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  106: // read new device presence
    f_modbus_read(1,1,2,239,1);
    if modbus_status = 2 then
      // response OK
      if nok_nd_valid <> f_read_bit(0) then
        nok_new_device_status := 2; // error
      else
        nok_new_device_status := nok_nd_valid;
      end_if;
      modbus_step := modbus_step + 1; // read nok devices data valid
    elsif modbus_status >=3 then
      // no response
      nok00_general_error := 1;
      nok00_network_status := 0; // no gw
      modbus_step := 200; // next device
    end_if;

  107: // clear new device slot if occupied
    if nok_new_device_status <> 0 then
      nok00_argument := 127;
      nok00_command := 4;
      modbus_step := 100;
    else
      modbus_step := modbus_step + 1;
    end_if;

  108:
    modbus_step := 200;
#DESCRIPTION_END

##PROGRAM_END_1

